/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.handler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.MessageContext;
import org.jboss.com.sun.xml.ws.util.ByteArrayDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageContextUtil {
    public static Integer getHttpStatusCode(MessageContext ctxt) {
        return (Integer)ctxt.get((Object)"javax.xml.ws.http.response.code");
    }

    public static void setHttpStatusCode(MessageContext ctxt, Integer code) {
        ctxt.put((Object)"javax.xml.ws.http.response.code", (Object)code);
        ctxt.setScope("javax.xml.ws.http.response.code", MessageContext.Scope.APPLICATION);
    }

    public static void setQueryString(MessageContext ctxt, String queryString) {
        ctxt.put((Object)"javax.xml.ws.http.request.querystring", (Object)queryString);
        ctxt.setScope("javax.xml.ws.http.request.querystring", MessageContext.Scope.APPLICATION);
    }

    public static void setPathInfo(MessageContext ctxt, String pathInfo) {
        ctxt.put((Object)"javax.xml.ws.http.request.pathinfo", (Object)pathInfo);
        ctxt.setScope("javax.xml.ws.http.request.pathinfo", MessageContext.Scope.APPLICATION);
    }

    public static void setHttpRequestMethod(MessageContext ctxt, String method) {
        ctxt.put((Object)"javax.xml.ws.http.request.method", (Object)method);
        ctxt.setScope("javax.xml.ws.http.request.method", MessageContext.Scope.APPLICATION);
    }

    public static void setHttpRequestHeaders(MessageContext ctxt, Map<String, List<String>> headers) {
        ctxt.put((Object)"javax.xml.ws.http.request.headers", headers);
        ctxt.setScope("javax.xml.ws.http.request.headers", MessageContext.Scope.APPLICATION);
    }

    public static void setHttpResponseHeaders(MessageContext ctxt, Map<String, List<String>> headers) {
        ctxt.put((Object)"javax.xml.ws.http.response.headers", headers);
        ctxt.setScope("javax.xml.ws.http.response.headers", MessageContext.Scope.APPLICATION);
    }

    public static Map<String, List<String>> getHttpResponseHeaders(MessageContext ctxt) {
        return (Map)ctxt.get((Object)"javax.xml.ws.http.response.headers");
    }

    public static void setWsdlOperation(MessageContext ctxt, QName name) {
        ctxt.put((Object)"javax.xml.ws.wsdl.operation", (Object)name);
        ctxt.setScope("javax.xml.ws.wsdl.operation", MessageContext.Scope.APPLICATION);
    }

    private static Map<String, DataHandler> getMessageAttachments(MessageContext ctxt) {
        Object att;
        String property = "javax.xml.ws.binding.attachments.inbound";
        Boolean out = (Boolean)ctxt.get((Object)"javax.xml.ws.handler.message.outbound");
        if (out != null && out.booleanValue()) {
            property = "javax.xml.ws.binding.attachments.outbound";
        }
        if ((att = ctxt.get((Object)property)) == null) {
            HashMap<String, DataHandler> attMap = new HashMap<String, DataHandler>();
            ctxt.put((Object)property, attMap);
            ctxt.setScope(property, MessageContext.Scope.APPLICATION);
            return attMap;
        }
        return (Map)att;
    }

    public static void copyInboundMessageAttachments(MessageContext ctxt, Iterator<AttachmentPart> attachments) throws SOAPException {
        Map<String, DataHandler> attachMap = MessageContextUtil.getMessageAttachments(ctxt);
        while (attachments.hasNext()) {
            AttachmentPart ap = attachments.next();
            DataHandler dh = new DataHandler((DataSource)new ByteArrayDataSource(ap.getRawContentBytes(), ap.getContentType()));
            attachMap.put(ap.getContentId(), dh);
        }
    }

    public static void addMessageAttachment(MessageContext ctxt, String cid, DataHandler dh) {
        Map<String, DataHandler> attachMap = MessageContextUtil.getMessageAttachments(ctxt);
        attachMap.put(cid, dh);
    }

    public static boolean ignoreFaultInMessage(MessageContext context) {
        if (context.get((Object)"ignore fault in message") == null) {
            return false;
        }
        return (Boolean)context.get((Object)"ignore fault in message");
    }
}

