/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.wsdl;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.WebServiceException;
import org.jboss.com.sun.xml.ws.wsdl.parser.Binding;
import org.jboss.com.sun.xml.ws.wsdl.parser.Port;
import org.jboss.com.sun.xml.ws.wsdl.parser.RuntimeWSDLParser;
import org.jboss.com.sun.xml.ws.wsdl.parser.Service;
import org.jboss.com.sun.xml.ws.wsdl.parser.WSDLDocument;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLContext {
    private final URL orgWsdlLocation;
    private String targetNamespace;
    private final WSDLDocument wsdlDoc;

    public WSDLContext(URL wsdlDocumentLocation, EntityResolver entityResolver) throws WebServiceException {
        assert (entityResolver != null);
        if (wsdlDocumentLocation == null) {
            throw new WebServiceException("No WSDL location Information present, error");
        }
        this.orgWsdlLocation = wsdlDocumentLocation;
        try {
            this.wsdlDoc = RuntimeWSDLParser.parse(wsdlDocumentLocation, entityResolver);
        }
        catch (IOException e) {
            throw new WebServiceException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new WebServiceException((Throwable)e);
        }
        catch (SAXException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public URL getWsdlLocation() {
        return this.orgWsdlLocation;
    }

    public String getOrigURLPath() {
        return this.orgWsdlLocation.getPath();
    }

    public QName getServiceQName() {
        return this.wsdlDoc.getFirstServiceName();
    }

    public boolean contains(QName serviceName) {
        return this.wsdlDoc.getServices().containsKey(serviceName);
    }

    public String getEndpoint(QName serviceName) {
        Iterator iter;
        if (serviceName == null) {
            throw new WebServiceException("Service unknown, can not identify ports for an unknown Service.");
        }
        Service service = this.wsdlDoc.getService(serviceName);
        String endpoint = null;
        if (service != null && (iter = service.entrySet().iterator()).hasNext()) {
            Port port = (Port)iter.next().getValue();
            endpoint = port.getAddress();
        }
        if (endpoint == null) {
            throw new WebServiceException("Endpoint not found. Check WSDL file to verify endpoint was provided.");
        }
        return endpoint;
    }

    public QName getPortName() {
        return this.wsdlDoc.getFirstPortName();
    }

    public String getBindingID(QName serviceName, QName portName) {
        return this.getWsdlDocument().getBindingId(serviceName, portName);
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String tns) {
        this.targetNamespace = tns;
    }

    public Set<QName> getPortsAsSet(QName serviceName) {
        Service service = this.wsdlDoc.getService(serviceName);
        if (service != null) {
            return service.keySet();
        }
        return null;
    }

    public boolean contains(QName serviceName, QName portName) {
        Service service = this.wsdlDoc.getService(serviceName);
        if (service != null) {
            Iterator iter = service.entrySet().iterator();
            while (iter.hasNext()) {
                Port port = (Port)iter.next().getValue();
                if (!port.getName().equals(portName)) continue;
                return true;
            }
        }
        return false;
    }

    public QName getFirstServiceName() {
        return this.wsdlDoc.getFirstServiceName();
    }

    public Set<QName> getAllServiceNames() {
        return this.wsdlDoc.getServices().keySet();
    }

    public WSDLDocument getWsdlDocument() {
        return this.wsdlDoc;
    }

    public Binding getWsdlBinding(QName service, QName port) {
        if (this.wsdlDoc == null) {
            return null;
        }
        return this.wsdlDoc.getBinding(service, port);
    }

    public String getEndpoint(QName serviceName, QName portQName) {
        Service service = this.wsdlDoc.getService(serviceName);
        if (service != null) {
            Port p = (Port)service.get(portQName);
            if (p != null) {
                return p.getAddress();
            }
            throw new WebServiceException("No ports found for service " + serviceName);
        }
        throw new WebServiceException("Service unknown, can not identify ports for an unknown Service.");
    }
}

