/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;

public class ChangeLogTask
extends Task
implements ExecuteStreamHandler {
    private File userConfigFile;
    private Properties userList = new Properties();
    private File cvsWorkingDirectory;
    private File outputFile;
    private Date thresholdDate;
    private BufferedReader input;
    private InputStreamReader errorInput;
    private PrintWriter output;
    private Vector filesets = new Vector();
    private String testURL = "http://jakarta.apache.org";
    private String executable = "cvs";
    private PrintWriter debug;
    private static final int GET_FILE = 1;
    private static final int GET_DATE = 2;
    private static final int GET_COMMENT = 3;
    private static final int GET_REVISION = 4;
    private static final SimpleDateFormat INPUT_DATE = new SimpleDateFormat("yyyy/MM/dd");
    private static final SimpleDateFormat FULL_INPUT_DATE = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    private static final SimpleDateFormat OUTPUT_DATE = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat OUTPUT_TIME = new SimpleDateFormat("HH:mm");

    public void setUsers(File file) {
        this.userConfigFile = file;
    }

    public void setWork(File file) {
        this.cvsWorkingDirectory = file;
    }

    public void setOutput(File file) {
        this.outputFile = file;
    }

    public void setExecutable(String string) {
        this.executable = string;
    }

    public void setDate(String string) {
        try {
            this.thresholdDate = INPUT_DATE.parse(string);
        }
        catch (ParseException parseException) {
            throw new BuildException("Bad date format [" + string + "].");
        }
    }

    public void setElapsed(Long l) {
        long l2 = System.currentTimeMillis();
        this.thresholdDate = new Date(l2 - l * 24L * 60L * 60L * 1000L);
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void setTestURL(String string) {
        this.testURL = string;
    }

    public void setDebug(File file) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        this.debug = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"), true);
    }

    private void readUserList() {
        if (this.userConfigFile != null) {
            if (!this.userConfigFile.exists()) {
                throw new BuildException("User list configuration file [" + this.userConfigFile.getAbsolutePath() + "] was not found. Please check location.");
            }
            try {
                this.userList.load(new FileInputStream(this.userConfigFile));
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
        }
    }

    private boolean testInternetAccess() throws BuildException {
        try {
            URL uRL = new URL(this.testURL);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.connect();
            httpURLConnection.disconnect();
        }
        catch (MalformedURLException malformedURLException) {
            throw new BuildException("Bad URL [" + this.testURL + "]");
        }
        catch (IOException iOException) {
            if (!this.outputFile.exists()) {
                try {
                    this.output = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), "UTF-8"));
                    this.output.println("<changelog>");
                    this.output.println("</changelog>");
                    this.output.flush();
                    this.output.close();
                }
                catch (IOException iOException2) {
                    throw new BuildException((Throwable)iOException2);
                }
            }
            return false;
        }
        return true;
    }

    public void execute() throws BuildException {
        Execute execute;
        if (this.cvsWorkingDirectory == null) {
            throw new BuildException("The [workDir] attribute must be set");
        }
        if (!this.cvsWorkingDirectory.exists()) {
            throw new BuildException("Cannot find CVS working directory [" + this.cvsWorkingDirectory.getAbsolutePath() + "]");
        }
        if (this.outputFile == null) {
            throw new BuildException("The [output] attribute must be set");
        }
        this.readUserList();
        if (!this.testInternetAccess()) {
            return;
        }
        Commandline commandline = new Commandline();
        commandline.setExecutable(this.executable);
        commandline.createArgument().setValue("log");
        if (this.thresholdDate != null) {
            commandline.createArgument().setValue("-d\">=" + OUTPUT_DATE.format(this.thresholdDate) + "\"");
        }
        if (!this.filesets.isEmpty()) {
            execute = this.filesets.elements();
            while (execute.hasMoreElements()) {
                FileSet fileSet = (FileSet)execute.nextElement();
                DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(((ProjectComponent)this).project);
                String[] stringArray = directoryScanner.getIncludedFiles();
                int n = 0;
                while (n < stringArray.length) {
                    commandline.createArgument().setValue(stringArray[n]);
                    ++n;
                }
            }
        }
        execute = new Execute((ExecuteStreamHandler)this);
        execute.setCommandline(commandline.getCommandline());
        execute.setAntRun(((ProjectComponent)this).project);
        execute.setWorkingDirectory(this.cvsWorkingDirectory);
        try {
            execute.execute();
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
    }

    public void setProcessInputStream(OutputStream outputStream) throws IOException {
    }

    public void setProcessErrorStream(InputStream inputStream) throws IOException {
        this.errorInput = new InputStreamReader(inputStream);
    }

    public void setProcessOutputStream(InputStream inputStream) throws IOException {
        this.input = new BufferedReader(new InputStreamReader(inputStream));
    }

    public void stop() {
    }

    public void start() throws IOException {
        Object object;
        this.output = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), "UTF-8"));
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n = 1;
        this.debug("State = GET_FILE");
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        while ((string2 = this.input.readLine()) != null) {
            this.debug("Text: [" + string2);
            switch (n) {
                case 1: {
                    if (!string2.startsWith("Working file:")) break;
                    string = string2.substring(14, string2.length());
                    n = 4;
                    this.debug("Next state = GET_REVISION");
                    break;
                }
                case 4: {
                    if (string2.startsWith("revision")) {
                        string6 = string2.substring(9);
                        n = 2;
                        this.debug("Next state = GET_DATE");
                        break;
                    }
                    if (!string2.startsWith("======")) break;
                    n = 1;
                    this.debug("Next state = GET_FILE");
                    break;
                }
                case 2: {
                    if (!string2.startsWith("date:")) break;
                    string3 = string2.substring(6, 22);
                    string2 = string2.substring(string2.indexOf(";") + 1);
                    string4 = string2.substring(10, string2.indexOf(";"));
                    if (this.userList != null && ((Hashtable)this.userList).containsKey(string4)) {
                        string4 = "<![CDATA[" + this.userList.getProperty(string4) + "]]>";
                    }
                    n = 3;
                    this.debug("Next state = GET_COMMENT");
                    break;
                }
                case 3: {
                    string5 = "";
                    while (string2 != null && !string2.startsWith("======") && !string2.startsWith("------")) {
                        string5 = string5 + string2 + "\n";
                        string2 = this.input.readLine();
                        this.debug("Text: [" + string2);
                    }
                    string5 = "<![CDATA[" + string5.substring(0, string5.length() - 1) + "]]>";
                    if (!hashtable.containsKey(string3 + string4 + string5)) {
                        object = new Entry(string3, string4, string5);
                        hashtable.put(string3 + string4 + string5, object);
                    } else {
                        object = (Entry)hashtable.get(string3 + string4 + string5);
                    }
                    ((Entry)object).addFile(string, string6);
                    if (string2.startsWith("======")) {
                        n = 1;
                        this.debug("Next state = GET_FILE");
                        break;
                    }
                    n = 4;
                    this.debug("Next state = GET_REVISION");
                }
            }
            while (this.errorInput.ready()) {
                this.errorInput.read();
            }
        }
        this.debug("Preparing to write changelog file");
        this.output.println("<changelog>");
        object = hashtable.elements();
        while (object.hasMoreElements()) {
            ((Entry)object.nextElement()).print();
        }
        this.output.println("</changelog>");
        this.output.flush();
        this.output.close();
    }

    private void debug(String string) {
        if (this.debug != null) {
            this.debug.println(string);
        }
    }

    private class Entry {
        private Date date;
        private final String author;
        private final String comment;
        private final Vector files = new Vector();

        public Entry(String string, String string2, String string3) {
            try {
                this.date = FULL_INPUT_DATE.parse(string);
            }
            catch (ParseException parseException) {
                ChangeLogTask.this.log("Bad date format [" + string + "].");
            }
            this.author = string2;
            this.comment = string3;
        }

        public void addFile(String string, String string2) {
            this.files.addElement(new RCSFile(string, string2));
        }

        public String toString() {
            return this.author + "\n" + this.date + "\n" + this.files + "\n" + this.comment;
        }

        public void print() {
            ChangeLogTask.this.output.println("\t<entry>");
            ChangeLogTask.this.output.println("\t\t<date>" + OUTPUT_DATE.format(this.date) + "</date>");
            ChangeLogTask.this.output.println("\t\t<time>" + OUTPUT_TIME.format(this.date) + "</time>");
            ChangeLogTask.this.output.println("\t\t<author>" + this.author + "</author>");
            Enumeration enumeration = this.files.elements();
            while (enumeration.hasMoreElements()) {
                RCSFile rCSFile = (RCSFile)enumeration.nextElement();
                ChangeLogTask.this.output.println("\t\t<file>");
                ChangeLogTask.this.output.println("\t\t\t<name>" + rCSFile.getName() + "</name>");
                ChangeLogTask.this.output.println("\t\t\t<revision>" + rCSFile.getRevision() + "</revision>");
                ChangeLogTask.this.output.println("\t\t</file>");
            }
            ChangeLogTask.this.output.println("\t\t<msg>" + this.comment + "</msg>");
            ChangeLogTask.this.output.println("\t</entry>");
        }

        private class RCSFile {
            private String name;
            private String revision;

            private RCSFile(String string, String string2) {
                this.name = string;
                this.revision = string2;
            }

            public String getName() {
                return this.name;
            }

            public String getRevision() {
                return this.revision;
            }
        }
    }
}

