/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.awt;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.net.URL;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.FontInfo;
import org.apache.fop.configuration.FontTriplet;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.render.awt.FontMetricsMapper;

public class FontSetup {
    private static int normal = 0;
    private static int bold = 1;
    private static int italic = 2;
    private static int bolditalic = 3;

    public static void setup(org.apache.fop.layout.FontInfo fontInfo, Graphics2D graphics) throws FOPException {
        MessageHandler.logln("setting up fonts");
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontMetricsMapper metric = new FontMetricsMapper("SansSerif", normal, graphics);
        fontInfo.addMetrics("F1", metric);
        metric = new FontMetricsMapper("SansSerif", italic, graphics);
        fontInfo.addMetrics("F2", metric);
        metric = new FontMetricsMapper("SansSerif", bold, graphics);
        fontInfo.addMetrics("F3", metric);
        metric = new FontMetricsMapper("SansSerif", bolditalic, graphics);
        fontInfo.addMetrics("F4", metric);
        metric = new FontMetricsMapper("Serif", normal, graphics);
        fontInfo.addMetrics("F5", metric);
        metric = new FontMetricsMapper("Serif", italic, graphics);
        fontInfo.addMetrics("F6", metric);
        metric = new FontMetricsMapper("Serif", bold, graphics);
        fontInfo.addMetrics("F7", metric);
        metric = new FontMetricsMapper("Serif", bolditalic, graphics);
        fontInfo.addMetrics("F8", metric);
        metric = new FontMetricsMapper("MonoSpaced", normal, graphics);
        fontInfo.addMetrics("F9", metric);
        metric = new FontMetricsMapper("MonoSpaced", italic, graphics);
        fontInfo.addMetrics("F10", metric);
        metric = new FontMetricsMapper("MonoSpaced", bold, graphics);
        fontInfo.addMetrics("F11", metric);
        metric = new FontMetricsMapper("MonoSpaced", bolditalic, graphics);
        fontInfo.addMetrics("F12", metric);
        metric = new FontMetricsMapper("Symbol", bolditalic, graphics);
        fontInfo.addMetrics("F13", metric);
        fontInfo.addMetrics("F14", metric);
        fontInfo.addFontProperties("F5", "any", "normal", "normal");
        fontInfo.addFontProperties("F6", "any", "italic", "normal");
        fontInfo.addFontProperties("F6", "any", "oblique", "normal");
        fontInfo.addFontProperties("F7", "any", "normal", "bold");
        fontInfo.addFontProperties("F8", "any", "italic", "bold");
        fontInfo.addFontProperties("F8", "any", "oblique", "bold");
        fontInfo.addFontProperties("F1", "sans-serif", "normal", "normal");
        fontInfo.addFontProperties("F2", "sans-serif", "oblique", "normal");
        fontInfo.addFontProperties("F2", "sans-serif", "italic", "normal");
        fontInfo.addFontProperties("F3", "sans-serif", "normal", "bold");
        fontInfo.addFontProperties("F4", "sans-serif", "oblique", "bold");
        fontInfo.addFontProperties("F4", "sans-serif", "italic", "bold");
        fontInfo.addFontProperties("F5", "serif", "normal", "normal");
        fontInfo.addFontProperties("F6", "serif", "oblique", "normal");
        fontInfo.addFontProperties("F6", "serif", "italic", "normal");
        fontInfo.addFontProperties("F7", "serif", "normal", "bold");
        fontInfo.addFontProperties("F8", "serif", "oblique", "bold");
        fontInfo.addFontProperties("F8", "serif", "italic", "bold");
        fontInfo.addFontProperties("F9", "monospace", "normal", "normal");
        fontInfo.addFontProperties("F10", "monospace", "oblique", "normal");
        fontInfo.addFontProperties("F10", "monospace", "italic", "normal");
        fontInfo.addFontProperties("F11", "monospace", "normal", "bold");
        fontInfo.addFontProperties("F12", "monospace", "oblique", "bold");
        fontInfo.addFontProperties("F12", "monospace", "italic", "bold");
        fontInfo.addFontProperties("F1", "Helvetica", "normal", "normal");
        fontInfo.addFontProperties("F2", "Helvetica", "oblique", "normal");
        fontInfo.addFontProperties("F2", "Helvetica", "italic", "normal");
        fontInfo.addFontProperties("F3", "Helvetica", "normal", "bold");
        fontInfo.addFontProperties("F4", "Helvetica", "oblique", "bold");
        fontInfo.addFontProperties("F4", "Helvetica", "italic", "bold");
        fontInfo.addFontProperties("F5", "Times", "normal", "normal");
        fontInfo.addFontProperties("F6", "Times", "oblique", "normal");
        fontInfo.addFontProperties("F6", "Times", "italic", "normal");
        fontInfo.addFontProperties("F7", "Times", "normal", "bold");
        fontInfo.addFontProperties("F8", "Times", "oblique", "bold");
        fontInfo.addFontProperties("F8", "Times", "italic", "bold");
        fontInfo.addFontProperties("F9", "Courier", "normal", "normal");
        fontInfo.addFontProperties("F10", "Courier", "oblique", "normal");
        fontInfo.addFontProperties("F10", "Courier", "italic", "normal");
        fontInfo.addFontProperties("F11", "Courier", "normal", "bold");
        fontInfo.addFontProperties("F12", "Courier", "oblique", "bold");
        fontInfo.addFontProperties("F12", "Courier", "italic", "bold");
        fontInfo.addFontProperties("F13", "Symbol", "normal", "normal");
        fontInfo.addFontProperties("F14", "ZapfDingbats", "normal", "normal");
        fontInfo.addFontProperties("F5", "Times-Roman", "normal", "normal");
        fontInfo.addFontProperties("F6", "Times-Roman", "oblique", "normal");
        fontInfo.addFontProperties("F6", "Times-Roman", "italic", "normal");
        fontInfo.addFontProperties("F7", "Times-Roman", "normal", "bold");
        fontInfo.addFontProperties("F8", "Times-Roman", "oblique", "bold");
        fontInfo.addFontProperties("F8", "Times-Roman", "italic", "bold");
        fontInfo.addFontProperties("F5", "Times Roman", "normal", "normal");
        fontInfo.addFontProperties("F6", "Times Roman", "oblique", "normal");
        fontInfo.addFontProperties("F6", "Times Roman", "italic", "normal");
        fontInfo.addFontProperties("F7", "Times Roman", "normal", "bold");
        fontInfo.addFontProperties("F8", "Times Roman", "oblique", "bold");
        fontInfo.addFontProperties("F8", "Times Roman", "italic", "bold");
        fontInfo.addFontProperties("F9", "Computer-Modern-Typewriter", "normal", "normal");
        FontSetup.addConfiguredFonts(fontInfo, 15, graphics);
    }

    public static void addConfiguredFonts(org.apache.fop.layout.FontInfo fontInfo, int num, Graphics2D graphics) throws FOPException {
        String internalName = null;
        List fontInfos = Configuration.getFonts();
        if (fontInfos == null) {
            return;
        }
        for (int i = 0; i < fontInfos.size(); ++i) {
            FontInfo configFontInfo = (FontInfo)fontInfos.get(i);
            try {
                URL metricsFile = configFontInfo.getMetricsFile();
                if (metricsFile == null) continue;
                internalName = "F" + num;
                ++num;
                List triplets = configFontInfo.getFontTriplets();
                for (int j = 0; j < triplets.size(); ++j) {
                    FontTriplet triplet = (FontTriplet)triplets.get(j);
                    boolean embed = configFontInfo.getEmbedFile() != null;
                    String family = embed ? triplet.getName() : "Dialog";
                    FontMetricsMapper metric = new FontMetricsMapper(family, FontSetup.getFontMetrics(triplet), graphics);
                    if (embed) {
                        metric.setEmbedFont(configFontInfo.getEmbedFile());
                    }
                    fontInfo.addMetrics(internalName, metric);
                    fontInfo.addFontProperties(internalName, triplet.getName(), triplet.getStyle(), triplet.getWeight());
                }
                continue;
            }
            catch (Exception ex) {
                MessageHandler.error("Failed to read font metrics file: " + ex.getMessage());
            }
        }
    }

    private static int getFontMetrics(FontTriplet triplet) {
        boolean isBold = "bold".equalsIgnoreCase(triplet.getWeight());
        boolean isItalic = "italic".equalsIgnoreCase(triplet.getStyle());
        if (isBold && isItalic) {
            return bolditalic;
        }
        if (isBold) {
            return bold;
        }
        if (isItalic) {
            return italic;
        }
        return normal;
    }
}

