/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment.xml;

import java.io.InputStream;
import java.net.URL;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployer;
import org.jboss.kernel.plugins.deployment.xml.BeanSchemaBinding;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;

public class BeanXMLDeployer
extends AbstractKernelDeployer {
    private static final Logger log = Logger.getLogger((Class)BeanXMLDeployer.class);
    protected SchemaBinding schemaBinding = BeanSchemaBinding.getSchemaBinding();

    public BeanXMLDeployer(Kernel kernel) throws Throwable {
        super(kernel);
    }

    public KernelDeployment deploy(URL uRL) throws Throwable {
        boolean bl = log.isTraceEnabled();
        if (uRL == null) {
            throw new IllegalArgumentException("Null url");
        }
        if (bl) {
            log.trace((Object)("Parsing " + uRL));
        }
        long l = System.currentTimeMillis();
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        KernelDeployment kernelDeployment = (KernelDeployment)unmarshaller.unmarshal(uRL.toString(), this.schemaBinding);
        if (kernelDeployment == null) {
            throw new RuntimeException("The xml " + uRL + " is not well formed!");
        }
        kernelDeployment.setName(uRL.toString());
        long l2 = System.currentTimeMillis();
        log.debug((Object)("Parsing " + uRL + " took " + (l2 - l) + " milliseconds"));
        if (bl) {
            log.trace((Object)("Deploying " + kernelDeployment));
        }
        this.deploy(kernelDeployment);
        l2 = System.currentTimeMillis();
        log.debug((Object)("Deploying " + uRL + " took " + (l2 - l) + " milliseconds"));
        if (bl) {
            log.trace((Object)("Deployed " + kernelDeployment.getInstalledContexts()));
        }
        return kernelDeployment;
    }

    public KernelDeployment deploy(String string, InputStream inputStream) throws Throwable {
        Unmarshaller unmarshaller;
        KernelDeployment kernelDeployment;
        boolean bl = log.isTraceEnabled();
        if (bl) {
            log.trace((Object)("Parsing " + string));
        }
        if ((kernelDeployment = (KernelDeployment)(unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller()).unmarshal(inputStream, this.schemaBinding)) == null) {
            throw new RuntimeException("The deployment " + string + " is not well formed!");
        }
        kernelDeployment.setName(string);
        if (bl) {
            log.trace((Object)("Deploying " + kernelDeployment));
        }
        this.deploy(kernelDeployment);
        if (bl) {
            log.trace((Object)("Deployed " + kernelDeployment.getInstalledContexts()));
        }
        return kernelDeployment;
    }
}

