/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

public class Interval {
    public int a;
    public int b;

    public Interval(int n, int n2) {
        this.a = n;
        this.b = n2;
    }

    public boolean equals(Object object) {
        Interval interval = (Interval)object;
        return this.a == interval.a && this.b == interval.b;
    }

    public boolean startsBeforeDisjoint(Interval interval) {
        return this.a < interval.a && this.b < interval.a;
    }

    public boolean startsBeforeNonDisjoint(Interval interval) {
        return this.a <= interval.a && this.b >= interval.a;
    }

    public boolean startsAfter(Interval interval) {
        return this.a > interval.a;
    }

    public boolean startsAfterDisjoint(Interval interval) {
        return this.a > interval.b;
    }

    public boolean startsAfterNonDisjoint(Interval interval) {
        return this.a > interval.a && this.a <= interval.b;
    }

    public boolean disjoint(Interval interval) {
        return this.startsBeforeDisjoint(interval) || this.startsAfterDisjoint(interval);
    }

    public boolean adjacent(Interval interval) {
        return this.a == interval.b + 1 || this.b == interval.a - 1;
    }

    public boolean properlyContains(Interval interval) {
        return interval.a >= this.a && interval.b <= this.b;
    }

    public Interval union(Interval interval) {
        return new Interval(Math.min(this.a, interval.a), Math.max(this.b, interval.b));
    }

    public Interval intersection(Interval interval) {
        return new Interval(Math.max(this.a, interval.a), Math.min(this.b, interval.b));
    }

    public Interval differenceNotProperlyContained(Interval interval) {
        Interval interval2 = null;
        if (interval.startsBeforeNonDisjoint(this)) {
            interval2 = new Interval(Math.max(this.a, interval.b + 1), this.b);
        } else if (interval.startsAfterNonDisjoint(this)) {
            interval2 = new Interval(this.a, interval.a - 1);
        }
        return interval2;
    }

    public String toString() {
        return this.a + ".." + this.b;
    }
}

