/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

public class RotatingID {
    private short count;
    private long lastTime = System.currentTimeMillis();
    private final long nodeID;

    public RotatingID(int nodeID) {
        if (nodeID < 0 || nodeID > 65535) {
            throw new IllegalArgumentException("node id must be between 0 to 65535 inclusive");
        }
        this.nodeID = nodeID;
    }

    public synchronized long getID() {
        long id1 = this.nodeID << 48;
        long id2 = System.currentTimeMillis() << 14;
        long id = id1 | id2 | (long)this.count;
        if (this.count == Short.MAX_VALUE) {
            this.count = 0;
            long now = System.currentTimeMillis();
            while (now == this.lastTime) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
            }
            this.lastTime = now;
        } else {
            this.count = (short)(this.count + 1);
        }
        return id;
    }
}

