/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.net.messaging.jms;

import com.icesoft.net.messaging.Message;
import com.icesoft.net.messaging.MessageHandler;
import com.icesoft.net.messaging.MessageSelector;
import com.icesoft.net.messaging.ObjectMessage;
import com.icesoft.net.messaging.TextMessage;
import com.icesoft.net.messaging.jms.AbstractJMSConnection;
import com.icesoft.net.messaging.jms.JMSAdapter;
import com.icesoft.net.messaging.jms.JMSConnection;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSSubscriberConnection
extends AbstractJMSConnection
implements JMSConnection {
    private static final Log LOG = LogFactory.getLog((Class)JMSSubscriberConnection.class);
    private TopicSubscriber topicSubscriber;
    private MessageReceiver messageReceiver;
    private boolean started = false;
    static /* synthetic */ Class class$com$icesoft$net$messaging$jms$JMSSubscriberConnection$MessageListener;
    static /* synthetic */ Class class$com$icesoft$net$messaging$jms$JMSSubscriberConnection$MessageReceiver;

    public JMSSubscriberConnection(Topic topic, JMSAdapter jmsAdapter) throws IllegalArgumentException {
        super(topic, jmsAdapter, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageHandler(MessageHandler messageHandler) {
        if (messageHandler != null && this.connected && this.messageReceiver != null) {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.connected && this.messageReceiver != null) {
                    this.messageReceiver.getMessageListener().addMessageHandler(messageHandler);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (this.connected) {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.connected) {
                    JMSException _jmsException;
                    block16: {
                        block15: {
                            _jmsException = null;
                            if (this.started) {
                                try {
                                    this.stop();
                                }
                                catch (JMSException exception) {
                                    _jmsException = exception;
                                }
                            }
                            if (this.messageReceiver != null) {
                                this.messageReceiver.requestStop();
                                this.messageReceiver.getMessageListener().clearMessageHandlers();
                            }
                            if (this.topicSubscriber != null) {
                                try {
                                    this.topicSubscriber.close();
                                }
                                catch (JMSException exception) {
                                    if (_jmsException != null) break block15;
                                    _jmsException = exception;
                                }
                            }
                        }
                        try {
                            super.close();
                        }
                        catch (JMSException exception) {
                            if (_jmsException != null) break block16;
                            _jmsException = exception;
                        }
                    }
                    this.messageReceiver = null;
                    this.topicSubscriber = null;
                    if (_jmsException != null) {
                        throw _jmsException;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageHandler(MessageHandler messageHandler) {
        if (messageHandler != null && this.connected && this.messageReceiver != null) {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.connected && this.messageReceiver != null) {
                    this.messageReceiver.getMessageListener().removeMessageHandler(messageHandler);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        if (this.connected && !this.started) {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.connected && !this.started) {
                    this.topicConnection.start();
                    this.started = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        if (this.started) {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.started) {
                    this.started = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(MessageSelector messageSelector, boolean noLocal) throws InvalidDestinationException, InvalidSelectorException, JMSException {
        if (this.connected && this.topicSubscriber == null) {
            Object object = this.connectionLock;
            synchronized (object) {
                block7: {
                    if (this.connected && this.topicSubscriber == null) {
                        this.topicSubscriber = this.topicSession.createSubscriber(this.topic, messageSelector != null ? messageSelector.toString() : null, noLocal);
                        this.messageReceiver = new MessageReceiver(new MessageListener(), this.topicSubscriber);
                        try {
                            this.jmsAdapter.getExecutorService().execute((Runnable)this.messageReceiver);
                        }
                        catch (RejectedExecutionException exception) {
                            if (!LOG.isFatalEnabled()) break block7;
                            LOG.fatal((Object)"messageReceiver could not be accepted for execution!", (Throwable)exception);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe() throws JMSException {
        if (this.connected) {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.connected) {
                    if (this.messageReceiver != null) {
                        this.messageReceiver.requestStop();
                        this.messageReceiver.getMessageListener().clearMessageHandlers();
                    }
                    try {
                        if (this.topicSubscriber != null) {
                            this.topicSubscriber.close();
                        }
                    }
                    finally {
                        this.topicSubscriber = null;
                    }
                }
            }
        }
    }

    private static Message convert(javax.jms.Message message) throws JMSException {
        if (message instanceof javax.jms.TextMessage) {
            return JMSSubscriberConnection.convert((javax.jms.TextMessage)message);
        }
        if (message instanceof javax.jms.ObjectMessage) {
            return JMSSubscriberConnection.convert((javax.jms.ObjectMessage)message);
        }
        return null;
    }

    private static ObjectMessage convert(javax.jms.ObjectMessage objectMessage) throws JMSException {
        ObjectMessage _objectMessage = new ObjectMessage(objectMessage.getObject());
        JMSSubscriberConnection.copyProperties((javax.jms.Message)objectMessage, _objectMessage);
        return _objectMessage;
    }

    private static TextMessage convert(javax.jms.TextMessage textMessage) throws JMSException {
        TextMessage _textMessage = new TextMessage(textMessage.getText());
        JMSSubscriberConnection.copyProperties((javax.jms.Message)textMessage, _textMessage);
        return _textMessage;
    }

    private static void copyProperties(javax.jms.Message source, Message destination) throws JMSException {
        Enumeration _propertyNames = source.getPropertyNames();
        while (_propertyNames.hasMoreElements()) {
            String _propertyName = (String)_propertyNames.nextElement();
            destination.setObjectProperty(_propertyName, source.getObjectProperty(_propertyName));
        }
    }

    private static class MessageReceiver
    implements Runnable {
        private static final Log LOG = LogFactory.getLog((Class)(class$com$icesoft$net$messaging$jms$JMSSubscriberConnection$MessageReceiver == null ? (class$com$icesoft$net$messaging$jms$JMSSubscriberConnection$MessageReceiver = JMSSubscriberConnection.class$("com.icesoft.net.messaging.jms.JMSSubscriberConnection$MessageReceiver")) : class$com$icesoft$net$messaging$jms$JMSSubscriberConnection$MessageReceiver));
        private MessageListener messageListener;
        private TopicSubscriber topicSubscriber;
        private boolean stopRequested;

        private MessageReceiver(MessageListener messageListener, TopicSubscriber topicSubscriber) {
            this.messageListener = messageListener;
            this.topicSubscriber = topicSubscriber;
        }

        public void run() {
            block5: {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)(this + " started."));
                }
                try {
                    while (!this.stopRequested) {
                        javax.jms.Message _message = this.topicSubscriber.receive(1000L);
                        if (_message == null) continue;
                        this.messageListener.onMessage(_message);
                    }
                }
                catch (JMSException exception) {
                    if (!LOG.isErrorEnabled()) break block5;
                    LOG.error((Object)"Failed to receive message due to an internal error!", (Throwable)exception);
                }
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(this + " stopped."));
            }
        }

        public String toString() {
            StringBuffer _string = new StringBuffer();
            _string.append("MessageReceiver [");
            try {
                _string.append(this.topicSubscriber.getMessageSelector());
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            _string.append("]");
            return _string.toString();
        }

        private void requestStop() {
            this.stopRequested = true;
        }

        private MessageListener getMessageListener() {
            return this.messageListener;
        }

        private boolean isStopRequested() {
            return this.stopRequested;
        }
    }

    private static class MessageListener
    implements javax.jms.MessageListener {
        private static final Log LOG = LogFactory.getLog((Class)(class$com$icesoft$net$messaging$jms$JMSSubscriberConnection$MessageListener == null ? (class$com$icesoft$net$messaging$jms$JMSSubscriberConnection$MessageListener = JMSSubscriberConnection.class$("com.icesoft.net.messaging.jms.JMSSubscriberConnection$MessageListener")) : class$com$icesoft$net$messaging$jms$JMSSubscriberConnection$MessageListener));
        private Set messageHandlerSet = new HashSet();

        private MessageListener() {
        }

        public void onMessage(javax.jms.Message message) {
            block6: {
                try {
                    Iterator _messageHandlers = this.messageHandlerSet.iterator();
                    Message _message = JMSSubscriberConnection.convert(message);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Incoming message:\r\n\r\n" + _message));
                    }
                    while (_messageHandlers.hasNext()) {
                        MessageHandler _messageHandler = (MessageHandler)_messageHandlers.next();
                        MessageSelector _messageSelector = _messageHandler.getMessageSelector();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("MessageHandler " + _messageHandler + ":\r\n" + _messageSelector));
                        }
                        if (_messageSelector != null && !_messageSelector.matches(_message)) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Match!");
                        }
                        _messageHandler.handle(_message);
                    }
                    message.acknowledge();
                }
                catch (JMSException exception) {
                    if (!LOG.isErrorEnabled()) break block6;
                    LOG.error((Object)"Failed to convert message due to some internal error!", (Throwable)exception);
                }
            }
        }

        private void addMessageHandler(MessageHandler messageHandler) {
            if (messageHandler != null && !this.messageHandlerSet.contains(messageHandler)) {
                this.messageHandlerSet.add(messageHandler);
            }
        }

        private void clearMessageHandlers() {
            this.messageHandlerSet.clear();
        }

        private void removeMessageHandler(MessageHandler messageHandler) {
            if (messageHandler != null && this.messageHandlerSet.contains(messageHandler)) {
                this.messageHandlerSet.remove(messageHandler);
            }
        }
    }
}

