/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.NodeEntry;

public class FIFOQueue
implements EvictionQueue {
    private Map nodeMap = new LinkedHashMap();
    private int numElements = 0;

    FIFOQueue() {
    }

    public NodeEntry getFirstNodeEntry() {
        if (this.nodeMap.size() > 0) {
            return (NodeEntry)this.nodeMap.values().iterator().next();
        }
        return null;
    }

    public NodeEntry getNodeEntry(Fqn fqn) {
        return (NodeEntry)this.nodeMap.get(fqn);
    }

    public NodeEntry getNodeEntry(String fqn) {
        return this.getNodeEntry(Fqn.fromString(fqn));
    }

    public boolean containsNodeEntry(NodeEntry entry) {
        Fqn fqn = entry.getFqn();
        return this.getNodeEntry(fqn) != null;
    }

    public void removeNodeEntry(NodeEntry entry) {
        NodeEntry e = (NodeEntry)this.nodeMap.remove(entry.getFqn());
        this.numElements -= e.getNumberOfElements();
    }

    public void addNodeEntry(NodeEntry entry) {
        if (!this.containsNodeEntry(entry)) {
            entry.queue = this;
            this.nodeMap.put(entry.getFqn(), entry);
            this.numElements += entry.getNumberOfElements();
        }
    }

    public int getNumberOfNodes() {
        return this.nodeMap.size();
    }

    public int getNumberOfElements() {
        return this.numElements;
    }

    public void modifyElementCount(int difference) {
        this.numElements += difference;
    }

    public void clear() {
        this.nodeMap.clear();
        this.numElements = 0;
    }

    public Iterator iterate() {
        return this.nodeMap.values().iterator();
    }
}

