/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactoryImpl;
import org.jboss.reflect.spi.AnnotatedInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.util.JBossObject;

public abstract class InheritableAnnotationHolder
extends JBossObject
implements AnnotatedInfo,
Serializable {
    private static final long serialVersionUID = 3257290210164289843L;
    static final Map UNKNOWN_ANNOTATIONS_MAP = Collections.unmodifiableMap(new HashMap());
    static final AnnotationValue[] UNKNOWN_ANNOTATIONS = new AnnotationValue[0];
    protected Map declaredAnnotations = UNKNOWN_ANNOTATIONS_MAP;
    protected Map allAnnotations = UNKNOWN_ANNOTATIONS_MAP;
    protected AnnotationValue[] allAnnotationsArray = UNKNOWN_ANNOTATIONS;
    protected AnnotationValue[] declaredAnnotationsArray = UNKNOWN_ANNOTATIONS;
    protected Object annotatedElement;
    protected IntrospectionTypeInfoFactoryImpl typeInfoFactory;

    public void setTypeInfoFactory(IntrospectionTypeInfoFactoryImpl introspectionTypeInfoFactoryImpl) {
        this.typeInfoFactory = introspectionTypeInfoFactoryImpl;
    }

    public void setAnnotatedElement(Object object) {
        this.annotatedElement = object;
    }

    public AnnotationValue[] getDeclaredAnnotations() {
        if (this.declaredAnnotationsArray == UNKNOWN_ANNOTATIONS) {
            this.setupAnnotations(this.typeInfoFactory.getAnnotations(this.annotatedElement));
        }
        return this.declaredAnnotationsArray;
    }

    public AnnotationValue[] getAnnotations() {
        if (this.allAnnotationsArray == UNKNOWN_ANNOTATIONS) {
            this.setupAnnotations(this.typeInfoFactory.getAnnotations(this.annotatedElement));
        }
        return this.allAnnotationsArray;
    }

    public AnnotationValue getAnnotation(String string) {
        if (this.allAnnotations == UNKNOWN_ANNOTATIONS_MAP) {
            this.setupAnnotations(this.typeInfoFactory.getAnnotations(this.annotatedElement));
        }
        return (AnnotationValue)this.allAnnotations.get(string);
    }

    public boolean isAnnotationPresent(String string) {
        if (this.allAnnotations == UNKNOWN_ANNOTATIONS_MAP) {
            this.setupAnnotations(this.typeInfoFactory.getAnnotations(this.annotatedElement));
        }
        return this.allAnnotations.containsKey(string);
    }

    public void setupAnnotations(AnnotationValue[] annotationValueArray) {
        InheritableAnnotationHolder inheritableAnnotationHolder = this.getSuperHolder();
        AnnotationValue[] annotationValueArray2 = inheritableAnnotationHolder.getAnnotations();
        if (annotationValueArray != null && annotationValueArray.length > 0) {
            int n;
            this.declaredAnnotations = new HashMap();
            this.declaredAnnotationsArray = annotationValueArray;
            for (n = 0; n < annotationValueArray.length; ++n) {
                this.declaredAnnotations.put(annotationValueArray[n].getAnnotationType().getName(), annotationValueArray[n]);
            }
            this.allAnnotations = new HashMap();
            if (inheritableAnnotationHolder != null && annotationValueArray2 != null && annotationValueArray2.length != 0) {
                for (n = 0; n < annotationValueArray2.length; ++n) {
                    AnnotationValue annotationValue = annotationValueArray2[n];
                    if (annotationValue.getAnnotationType().isAnnotationPresent("java.lang.annotation.Inherited")) {
                        // empty if block
                    }
                    this.allAnnotations.put(annotationValue.getAnnotationType().getName(), annotationValue);
                }
            } else {
                this.allAnnotationsArray = this.declaredAnnotationsArray;
            }
            for (n = 0; n < annotationValueArray.length; ++n) {
                this.allAnnotations.put(annotationValueArray[n].getAnnotationType().getName(), annotationValueArray[n]);
            }
            this.allAnnotationsArray = this.allAnnotations.values().toArray(new AnnotationValue[this.allAnnotations.size()]);
        } else if (inheritableAnnotationHolder != null) {
            this.allAnnotations = inheritableAnnotationHolder.getAllAnnotations();
            this.allAnnotationsArray = annotationValueArray2;
        }
    }

    protected Map getAllAnnotations() {
        if (this.allAnnotations == UNKNOWN_ANNOTATIONS_MAP) {
            this.setupAnnotations(this.typeInfoFactory.getAnnotations(this.annotatedElement));
        }
        return this.allAnnotations;
    }

    protected abstract InheritableAnnotationHolder getSuperHolder();
}

