/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.ws.addressing;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.ws.addressing.AddressingConstants;
import javax.xml.ws.addressing.AddressingException;
import javax.xml.ws.addressing.AddressingProperties;
import javax.xml.ws.addressing.AddressingType;
import javax.xml.ws.addressing.AttributedQName;
import javax.xml.ws.addressing.AttributedURI;
import javax.xml.ws.addressing.EndpointReference;
import javax.xml.ws.addressing.Relationship;
import org.jboss.logging.Logger;

public abstract class AddressingBuilder
implements AddressingType {
    private static Logger log = Logger.getLogger(AddressingBuilder.class);

    protected AddressingBuilder() {
    }

    public static AddressingBuilder getAddressingBuilder() {
        ClassLoader classLoader;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception x) {
            throw new AddressingException(x.toString(), x);
        }
        String name = null;
        try {
            name = System.getProperty("javax.xml.ws.addressing.AddressingBuilder");
            if (name != null) {
                return AddressingBuilder.newInstance(name, classLoader);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Could not create and instance of " + name + " trying " + "org.jboss.ws.extensions.addressing.soap.SOAPAddressingBuilderImpl"));
        }
        return AddressingBuilder.newInstance("org.jboss.ws.extensions.addressing.soap.SOAPAddressingBuilderImpl", classLoader);
    }

    private static AddressingBuilder newInstance(String className, ClassLoader classLoader) {
        try {
            Class<?> cls = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            return (AddressingBuilder)cls.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new AddressingException("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new AddressingException("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    public abstract AttributedURI newURI(URI var1);

    public abstract AttributedURI newURI(String var1) throws URISyntaxException;

    public abstract AttributedQName newQName(QName var1);

    public abstract Relationship newRelationship(URI var1);

    public abstract EndpointReference newEndpointReference(URI var1);

    public abstract AddressingProperties newAddressingProperties();

    public abstract AddressingConstants newAddressingConstants();
}

