/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.util;

import com.icesoft.faces.application.D2DViewHandler;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import org.w3c.dom.Element;

public class CoreUtils {
    private static Boolean renderPortletStyleClass;
    private static Boolean portletEnvironment;
    public static int toolTipcounter;

    public static String resolveResourceURL(FacesContext facesContext, String path) {
        return facesContext.getApplication().getViewHandler().getResourceURL(facesContext, path);
    }

    public static boolean isPortletEnvironment() {
        if (portletEnvironment == null) {
            try {
                portletEnvironment = new Boolean(FacesContext.getCurrentInstance().getExternalContext().getRequest() instanceof PortletRequest);
            }
            catch (NoClassDefFoundError e) {
                portletEnvironment = Boolean.FALSE;
            }
        }
        return portletEnvironment;
    }

    public static String getPortletStyleClass(String className) {
        if (CoreUtils.isPortletEnvironment() && CoreUtils.isRenderPortletStyleClass()) {
            return " " + className;
        }
        return "";
    }

    private static boolean isRenderPortletStyleClass() {
        if (renderPortletStyleClass == null) {
            String renderStyle = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("com.icesoft.faces.portlet.renderStyles");
            renderPortletStyleClass = renderStyle == null ? Boolean.TRUE : Boolean.valueOf(renderStyle);
        }
        return renderPortletStyleClass;
    }

    public static String addPortletStyleClassToQualifiedClass(String qualifiedStyleClass, String defaultClass, String portletClass) {
        return CoreUtils.addPortletStyleClassToQualifiedClass(qualifiedStyleClass, defaultClass, portletClass, false);
    }

    public static String addPortletStyleClassToQualifiedClass(String qualifiedStyleClass, String defaultClass, String portletClass, boolean disabled) {
        if (CoreUtils.isPortletEnvironment() && CoreUtils.isRenderPortletStyleClass()) {
            if (disabled) {
                return qualifiedStyleClass.replaceAll(defaultClass + "-dis", defaultClass + "-dis" + " " + portletClass);
            }
            return qualifiedStyleClass.replaceAll(defaultClass, defaultClass + " " + portletClass);
        }
        return qualifiedStyleClass;
    }

    public static void recoverFacesMessages(FacesContext facesContext, UIComponent uiComponent) {
        if (!(uiComponent instanceof UIInput)) {
            return;
        }
        UIInput input = (UIInput)uiComponent;
        String clientId = input.getClientId(facesContext);
        String localFacesMsgId = clientId + "$ice-msg$";
        String localRequired = clientId + "$ice-req$";
        if (input.getAttributes().get(localRequired) == null) {
            input.getAttributes().put(localRequired, new Boolean(input.isRequired()));
        }
        if (!input.isValid()) {
            Iterator messages = facesContext.getMessages(clientId);
            FacesMessage message = null;
            if (messages == null || !messages.hasNext()) {
                if (input.getAttributes().get(localFacesMsgId) != null) {
                    message = (FacesMessage)input.getAttributes().get(localFacesMsgId);
                    facesContext.addMessage(clientId, message);
                }
            } else {
                message = (FacesMessage)messages.next();
                input.getAttributes().put(localFacesMsgId, message);
            }
        } else {
            input.getAttributes().remove(localFacesMsgId);
        }
    }

    public static void addPanelTooltip(FacesContext facesContext, UIComponent uiComponent) {
        UIComponent form;
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        if (uiComponent.getAttributes().get("panelTooltip") == null) {
            return;
        }
        String panelTooltipId = String.valueOf(uiComponent.getAttributes().get("panelTooltip"));
        int delay = 500;
        String hideOn = "mouseout";
        boolean dynamic = false;
        String formId = "";
        String ctxValue = "";
        UIComponent panelTooltip = D2DViewHandler.findComponent(panelTooltipId, uiComponent);
        if (panelTooltip != null) {
            panelTooltipId = panelTooltip.getClientId(facesContext);
            if (panelTooltip.getAttributes().get("hideOn") != null) {
                hideOn = String.valueOf(panelTooltip.getAttributes().get("hideOn"));
            }
            if (panelTooltip.getAttributes().get("dynamic") != null) {
                dynamic = (Boolean)panelTooltip.getAttributes().get("dynamic");
            }
            if (panelTooltip.getAttributes().get("hoverDelay") != null) {
                delay = new Integer(String.valueOf(panelTooltip.getAttributes().get("hoverDelay")));
            }
            if (uiComponent.getAttributes().get("contextValue") != null) {
                ctxValue = String.valueOf(uiComponent.getAttributes().get("contextValue"));
            }
        }
        if ((form = DomBasicRenderer.findForm(panelTooltip)) != null) {
            formId = form.getClientId(facesContext);
        }
        Element rootElement = (Element)domContext.getRootNode();
        String onmouseover = String.valueOf(rootElement.getAttribute("onmouseover"));
        onmouseover = onmouseover + "; new ToolTipPanelPopup(this, '" + panelTooltipId + "', event, '" + hideOn + "','" + delay + "', '" + dynamic + "', '" + formId + "', '" + ctxValue + "','" + CoreUtils.resolveResourceURL(facesContext, "/xmlhttp/blank") + "');";
        rootElement.setAttribute("onmouseover", onmouseover);
    }

    static {
        toolTipcounter = 1;
    }
}

