/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel;

import org.jboss.kernel.KernelPermission;
import org.jboss.kernel.spi.config.KernelConfig;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.event.KernelEventManager;
import org.jboss.kernel.spi.registry.KernelBus;
import org.jboss.kernel.spi.registry.KernelRegistry;

public class Kernel {
    public static final KernelPermission ACCESS = new KernelPermission("access");
    public static final KernelPermission CONFIGURE = new KernelPermission("configure");
    private static final boolean enablePermissionChecking;
    protected KernelBus bus;
    protected KernelConfig config;
    protected KernelConfigurator configurator;
    protected KernelController controller;
    protected KernelEventManager eventManager;
    protected KernelRegistry registry;

    public static void checkAccess() {
        SecurityManager securityManager;
        if (enablePermissionChecking && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(ACCESS);
        }
    }

    public static void checkConfigure() {
        SecurityManager securityManager;
        if (enablePermissionChecking && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(CONFIGURE);
        }
    }

    public KernelBus getBus() {
        Kernel.checkAccess();
        return this.bus;
    }

    public void setBus(KernelBus kernelBus) {
        Kernel.checkConfigure();
        this.bus = kernelBus;
    }

    public KernelConfig getConfig() {
        Kernel.checkAccess();
        return this.config;
    }

    public void setConfig(KernelConfig kernelConfig) {
        Kernel.checkConfigure();
        this.config = kernelConfig;
    }

    public KernelConfigurator getConfigurator() {
        Kernel.checkAccess();
        return this.configurator;
    }

    public void setConfigurator(KernelConfigurator kernelConfigurator) {
        Kernel.checkConfigure();
        this.configurator = kernelConfigurator;
    }

    public KernelController getController() {
        Kernel.checkAccess();
        return this.controller;
    }

    public void setController(KernelController kernelController) {
        Kernel.checkConfigure();
        this.controller = kernelController;
    }

    public KernelEventManager getEventManager() {
        Kernel.checkAccess();
        return this.eventManager;
    }

    public void setEventManager(KernelEventManager kernelEventManager) {
        Kernel.checkConfigure();
        this.eventManager = kernelEventManager;
    }

    public KernelRegistry getRegistry() {
        Kernel.checkAccess();
        return this.registry;
    }

    public void setRegistry(KernelRegistry kernelRegistry) {
        Kernel.checkConfigure();
        this.registry = kernelRegistry;
    }

    static {
        boolean bl = false;
        try {
            bl = Boolean.getBoolean(KernelPermission.class.getName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        enablePermissionChecking = bl;
    }
}

