/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.tools.ws.processor.config.parser;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;
import org.jboss.com.sun.tools.ws.processor.config.Configuration;
import org.jboss.com.sun.tools.ws.processor.config.WSDLModelInfo;
import org.jboss.com.sun.tools.ws.processor.config.parser.InputParser;
import org.jboss.com.sun.tools.ws.processor.config.parser.JAXWSBindingInfoParser;
import org.jboss.com.sun.tools.ws.processor.util.ProcessorEnvironment;
import org.jboss.com.sun.tools.ws.wsdl.document.jaxws.JAXWSBindingsConstants;
import org.jboss.com.sun.xml.ws.streaming.XMLStreamReaderFactory;
import org.jboss.com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import org.jboss.com.sun.xml.ws.util.JAXWSUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationParser
extends InputParser {
    private WSDLModelInfo wsdlModelInfo;
    private JAXWSBindingInfoParser modelInfoParser;
    private Set<InputSource> jaxwsBindings = new HashSet<InputSource>();
    private Set<InputSource> jaxbBindings = new HashSet<InputSource>();
    private EntityResolver entityResolver;

    public CustomizationParser(EntityResolver entityResolver, ProcessorEnvironment env, Properties options) {
        super(env, options);
        this.entityResolver = entityResolver;
    }

    @Override
    protected Configuration parse(List<String> inputFiles) throws Exception {
        Configuration configuration = new Configuration(this.getEnv());
        this.wsdlModelInfo = new WSDLModelInfo();
        this.wsdlModelInfo.setLocation(inputFiles.get(0));
        if (this._options.get("wsdllocation") == null) {
            this._options.setProperty("wsdllocation", inputFiles.get(0));
        }
        this.modelInfoParser = new JAXWSBindingInfoParser(this.getEnv());
        Set bindingFiles = (Set)this._options.get("bindingFiles");
        for (String bindingFile : bindingFiles) {
            this.addBinding(bindingFile);
        }
        for (InputSource jaxwsBinding : this.jaxwsBindings) {
            Document doc = this.modelInfoParser.parse(jaxwsBinding);
            if (doc == null) continue;
            this.wsdlModelInfo.putJAXWSBindings(jaxwsBinding.getSystemId(), doc);
        }
        for (InputSource jaxbBinding : this.jaxbBindings) {
            this.wsdlModelInfo.addJAXBBIndings(jaxbBinding);
        }
        this.addHandlerChainInfo();
        configuration.setModelInfo(this.wsdlModelInfo);
        return configuration;
    }

    private void addBinding(String bindingLocation) throws Exception {
        JAXWSUtils.checkAbsoluteness(bindingLocation);
        InputSource is = null;
        if (this.entityResolver != null) {
            is = this.entityResolver.resolveEntity(null, bindingLocation);
        }
        if (is == null) {
            is = new InputSource(bindingLocation);
        }
        XMLStreamReader reader = XMLStreamReaderFactory.createFreshXMLStreamReader(is, true);
        XMLStreamReaderUtil.nextElementContent(reader);
        if (reader.getName().equals(JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            this.jaxwsBindings.add(is);
        } else if (reader.getName().equals(JAXWSBindingsConstants.JAXB_BINDINGS)) {
            this.jaxbBindings.add(is);
        } else {
            this.warn("configuration.notBindingFile");
        }
        reader.close();
    }

    private void addHandlerChainInfo() throws Exception {
        for (Map.Entry<String, Document> entry : this.wsdlModelInfo.getJAXWSBindings().entrySet()) {
            Element e = entry.getValue().getDocumentElement();
            NodeList nl = e.getElementsByTagNameNS("http://java.sun.com/xml/ns/javaee", "handler-chains");
            if (nl.getLength() == 0) continue;
            Element hc = (Element)nl.item(0);
            this.wsdlModelInfo.setHandlerConfig(hc);
            return;
        }
    }
}

