/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.assertion.PublisherAssertion;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.AddPublisherAssertions;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.GetAuthToken;
import org.apache.juddi.datatype.request.SaveBusiness;
import org.apache.juddi.datatype.response.AuthToken;
import org.apache.juddi.datatype.response.BusinessDetail;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.error.InvalidKeyPassedException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UserMismatchException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class AddPublisherAssertionsFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)AddPublisherAssertionsFunction.class);

    public AddPublisherAssertionsFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        AddPublisherAssertions request = (AddPublisherAssertions)regObject;
        AuthInfo authInfo = request.getAuthInfo();
        Vector assertionVector = request.getPublisherAssertionVector();
        String generic = request.getGeneric();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            dataStore.beginTrans();
            Publisher publisher = this.getPublisher(authInfo, dataStore);
            String publisherID = publisher.getPublisherID();
            for (int i = 0; i < assertionVector.size(); ++i) {
                PublisherAssertion assertion = (PublisherAssertion)assertionVector.elementAt(i);
                String fromKey = assertion.getFromKey();
                if (fromKey == null || fromKey.length() == 0) {
                    throw new InvalidKeyPassedException("add_publisherAssertion: fromKey=" + fromKey);
                }
                String toKey = assertion.getToKey();
                if (toKey == null || toKey.length() == 0) {
                    throw new InvalidKeyPassedException("add_publisherAssertion: toKey=" + toKey);
                }
                KeyedReference keyedRef = assertion.getKeyedReference();
                if (keyedRef == null) {
                    throw new InvalidKeyPassedException("add_publisherAssertion: keyedRef=" + keyedRef);
                }
                String tModelKey = keyedRef.getTModelKey();
                if (tModelKey == null || tModelKey.length() == 0) {
                    throw new InvalidKeyPassedException("add_publisherAssertion: tModelKey=" + keyedRef);
                }
                if (!dataStore.isValidBusinessKey(fromKey) && !dataStore.isValidTModelKey(fromKey)) {
                    throw new InvalidKeyPassedException("add_publisherAssertion: fromKey=" + fromKey);
                }
                if (!dataStore.isValidBusinessKey(toKey) && !dataStore.isValidTModelKey(toKey)) {
                    throw new InvalidKeyPassedException("add_publisherAssertion: toKey=" + toKey);
                }
                if (dataStore.isBusinessPublisher(fromKey, publisherID) || dataStore.isBusinessPublisher(toKey, publisherID) || dataStore.isTModelPublisher(fromKey, publisherID) || dataStore.isTModelPublisher(toKey, publisherID)) continue;
                throw new UserMismatchException("add_publisherAssertion: userID=" + publisherID + ", " + "fromKey=" + fromKey + ", " + "toKey=" + toKey);
            }
            dataStore.saveAssertions(publisherID, assertionVector);
            dataStore.commit();
        }
        catch (InvalidKeyPassedException keyex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)keyex.getMessage());
            throw keyex;
        }
        catch (UserMismatchException keyex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)keyex.getMessage());
            throw keyex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
        Result result = new Result(0);
        result.setErrCode(Result.lookupErrCode(0));
        DispositionReport dispRpt = new DispositionReport();
        dispRpt.setGeneric(generic);
        dispRpt.setOperator(Config.getOperator());
        dispRpt.addResult(result);
        return dispRpt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        try {
            GetAuthToken authTokenRequest1 = new GetAuthToken("sviens", "password");
            AuthToken authToken1 = (AuthToken)reg.execute(authTokenRequest1);
            AuthInfo authInfo1 = authToken1.getAuthInfo();
            BusinessEntity business1 = new BusinessEntity();
            business1.addName(new Name("Blockbuster", "en"));
            Vector<BusinessEntity> businessVector1 = new Vector<BusinessEntity>(1);
            businessVector1.addElement(business1);
            SaveBusiness sbReq1 = new SaveBusiness();
            sbReq1.setAuthInfo(authInfo1);
            sbReq1.setBusinessEntityVector(businessVector1);
            BusinessDetail detail1 = (BusinessDetail)reg.execute(sbReq1);
            Vector detailVector1 = detail1.getBusinessEntityVector();
            BusinessEntity b1 = (BusinessEntity)detailVector1.elementAt(0);
            GetAuthToken authTokenRequest2 = new GetAuthToken("steveviens", "password");
            AuthToken authToken2 = (AuthToken)reg.execute(authTokenRequest2);
            AuthInfo authInfo2 = authToken2.getAuthInfo();
            BusinessEntity business2 = new BusinessEntity();
            business2.addName(new Name("PopSecret", "en"));
            Vector<BusinessEntity> businessVector2 = new Vector<BusinessEntity>(1);
            businessVector2.addElement(business2);
            SaveBusiness sbReq2 = new SaveBusiness();
            sbReq2.setAuthInfo(authInfo2);
            sbReq2.setBusinessEntityVector(businessVector2);
            BusinessDetail detail2 = (BusinessDetail)reg.execute(sbReq2);
            Vector detailVector2 = detail2.getBusinessEntityVector();
            BusinessEntity b2 = (BusinessEntity)detailVector2.elementAt(0);
            String fromKey = b1.getBusinessKey();
            String toKey = b2.getBusinessKey();
            KeyedReference keyedReference = new KeyedReference("Partner Company", "peer-peer");
            keyedReference.setTModelKey("UUID:807A2C6A-EE22-470D-ADC7-E0424A337C03");
            PublisherAssertion assertion = new PublisherAssertion(fromKey, toKey, keyedReference);
            Vector<PublisherAssertion> assertionVector = new Vector<PublisherAssertion>();
            assertionVector.addElement(assertion);
            AddPublisherAssertions apaReq = new AddPublisherAssertions();
            apaReq.setAuthInfo(authInfo1);
            apaReq.setPublisherAssertionVector(assertionVector);
            DispositionReport dspRpt1 = (DispositionReport)reg.execute(apaReq);
            System.out.println("errno: " + dspRpt1.toString());
            System.out.println();
            DispositionReport dspRpt2 = (DispositionReport)reg.execute(apaReq);
            System.out.println("errno: " + dspRpt2.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            reg.dispose();
        }
    }
}

