/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.util;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Loader {
    private static Log log = LogFactory.getLog((Class)Loader.class);

    public static InputStream getResourceAsStream(String resource) {
        ClassLoader classLoader = null;
        InputStream stream = null;
        try {
            classLoader = Loader.getContextClassLoader();
            if (classLoader != null) {
                log.debug((Object)("Trying to find [" + resource + "] using context classloader " + classLoader + "."));
                stream = classLoader.getResourceAsStream(resource);
                if (stream != null) {
                    return stream;
                }
            }
            if ((classLoader = Loader.class.getClassLoader()) != null) {
                log.debug((Object)("Trying to find [" + resource + "] using " + classLoader + " class loader."));
                stream = classLoader.getResourceAsStream(resource);
                if (stream != null) {
                    return stream;
                }
            }
        }
        catch (Throwable th) {
            log.warn((Object)("Exception thrown from Loader.getResource(\"" + resource + "\")."), th);
        }
        log.debug((Object)("Trying to find [" + resource + "] using ClassLoader.getSystemResource()."));
        return ClassLoader.getSystemResourceAsStream(resource);
    }

    public static URL getResource(String resource) {
        ClassLoader classLoader = null;
        URL url = null;
        try {
            classLoader = Loader.getContextClassLoader();
            if (classLoader != null) {
                log.debug((Object)("Trying to find [" + resource + "] using context classloader " + classLoader + "."));
                url = classLoader.getResource(resource);
                if (url != null) {
                    return url;
                }
            }
            if ((classLoader = Loader.class.getClassLoader()) != null) {
                log.debug((Object)("Trying to find [" + resource + "] using " + classLoader + " class loader."));
                url = classLoader.getResource(resource);
                if (url != null) {
                    return url;
                }
            }
        }
        catch (Throwable th) {
            log.warn((Object)("Exception thrown from Loader.getResource(\"" + resource + "\")."), th);
        }
        log.debug((Object)("Trying to find [" + resource + "] using ClassLoader.getSystemResource()."));
        return ClassLoader.getSystemResource(resource);
    }

    private static ClassLoader getContextClassLoader() throws IllegalAccessException, InvocationTargetException {
        Method method = null;
        try {
            method = Thread.class.getMethod("getContextClassLoader", null);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
    }

    public static Class getClassForName(String name) throws ClassNotFoundException, NoClassDefFoundError {
        Class<?> clazz = null;
        try {
            log.info((Object)"Using the Context ClassLoader");
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            clazz = Class.forName(name, true, ccl);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to load the class " + name + " with context class loader " + e));
        }
        if (null == clazz) {
            ClassLoader scl = ClassLoader.getSystemClassLoader();
            try {
                log.info((Object)"Using the System ClassLoader");
                clazz = Class.forName(name, true, scl);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to load the class " + name + " with system class loader " + e));
            }
        }
        return clazz;
    }
}

