/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;

public class PointbaseDelegate
extends StdJDBCDelegate {
    public PointbaseDelegate(Log logger, String tablePrefix, String instanceId) {
        super(logger, tablePrefix, instanceId);
    }

    public PointbaseDelegate(Log logger, String tablePrefix, String instanceId, Boolean useProperties) {
        super(logger, tablePrefix, instanceId, useProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int insertJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        int insertResult;
        block6: {
            ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
            int len = baos.toByteArray().length;
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            PreparedStatement ps = null;
            insertResult = 0;
            try {
                ps = conn.prepareStatement(this.rtp("INSERT INTO {0}JOB_DETAILS (JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, REQUESTS_RECOVERY, JOB_DATA)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)"));
                ps.setString(1, job.getName());
                ps.setString(2, job.getGroup());
                ps.setString(3, job.getDescription());
                ps.setString(4, job.getJobClass().getName());
                ps.setBoolean(5, job.isDurable());
                ps.setBoolean(6, job.isVolatile());
                ps.setBoolean(7, job.isStateful());
                ps.setBoolean(8, job.requestsRecovery());
                ps.setBinaryStream(9, (InputStream)bais, len);
                insertResult = ps.executeUpdate();
                Object var9_8 = null;
                if (null == ps) break block6;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException ignore) {}
            ps.close();
        }
        if (insertResult <= 0) return insertResult;
        String[] jobListeners = job.getJobListenerNames();
        int i = 0;
        while (jobListeners != null) {
            if (i >= jobListeners.length) return insertResult;
            this.insertJobListener(conn, job, jobListeners[i]);
            ++i;
        }
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int updateJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        int insertResult;
        block6: {
            ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
            int len = baos.toByteArray().length;
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            PreparedStatement ps = null;
            insertResult = 0;
            try {
                ps = conn.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET DESCRIPTION = ?, JOB_CLASS_NAME = ?, IS_DURABLE = ?, IS_VOLATILE = ?, IS_STATEFUL = ?, REQUESTS_RECOVERY = ?, JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
                ps.setString(1, job.getDescription());
                ps.setString(2, job.getJobClass().getName());
                ps.setBoolean(3, job.isDurable());
                ps.setBoolean(4, job.isVolatile());
                ps.setBoolean(5, job.isStateful());
                ps.setBoolean(6, job.requestsRecovery());
                ps.setBinaryStream(7, (InputStream)bais, len);
                ps.setString(8, job.getName());
                ps.setString(9, job.getGroup());
                insertResult = ps.executeUpdate();
                Object var9_8 = null;
                if (null == ps) break block6;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException ignore) {}
            ps.close();
        }
        if (insertResult <= 0) return insertResult;
        this.deleteJobListeners(conn, job.getName(), job.getGroup());
        String[] jobListeners = job.getJobListenerNames();
        int i = 0;
        while (jobListeners != null) {
            if (i >= jobListeners.length) return insertResult;
            this.insertJobListener(conn, job, jobListeners[i]);
            ++i;
        }
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int insertTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        int insertResult;
        block12: {
            ByteArrayOutputStream baos = this.serializeJobData(trigger.getJobDataMap());
            int len = baos.toByteArray().length;
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            PreparedStatement ps = null;
            insertResult = 0;
            try {
                ps = conn.prepareStatement(this.rtp("INSERT INTO {0}TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, IS_VOLATILE, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
                ps.setString(1, trigger.getName());
                ps.setString(2, trigger.getGroup());
                ps.setString(3, trigger.getJobName());
                ps.setString(4, trigger.getJobGroup());
                ps.setBoolean(5, trigger.isVolatile());
                ps.setString(6, trigger.getDescription());
                ps.setBigDecimal(7, new BigDecimal(String.valueOf(trigger.getNextFireTime().getTime())));
                long prevFireTime = -1L;
                if (trigger.getPreviousFireTime() != null) {
                    prevFireTime = trigger.getPreviousFireTime().getTime();
                }
                ps.setBigDecimal(8, new BigDecimal(String.valueOf(prevFireTime)));
                ps.setString(9, state);
                if (trigger instanceof SimpleTrigger) {
                    ps.setString(10, "SIMPLE");
                } else if (trigger instanceof CronTrigger) {
                    ps.setString(10, "CRON");
                } else {
                    ps.setString(10, "BLOB");
                }
                ps.setBigDecimal(11, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
                long endTime = 0L;
                if (trigger.getEndTime() != null) {
                    endTime = trigger.getEndTime().getTime();
                }
                ps.setBigDecimal(12, new BigDecimal(String.valueOf(endTime)));
                ps.setString(13, trigger.getCalendarName());
                ps.setInt(14, trigger.getMisfireInstruction());
                ps.setBinaryStream(15, (InputStream)bais, len);
                insertResult = ps.executeUpdate();
                Object var15_13 = null;
                if (null == ps) break block12;
            }
            catch (Throwable throwable) {
                Object var15_14 = null;
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException ignore) {}
            ps.close();
        }
        if (insertResult <= 0) return insertResult;
        String[] trigListeners = trigger.getTriggerListenerNames();
        int i = 0;
        while (trigListeners != null) {
            if (i >= trigListeners.length) return insertResult;
            this.insertTriggerListener(conn, trigger, trigListeners[i]);
            ++i;
        }
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int updateTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        int insertResult;
        block13: {
            ByteArrayOutputStream baos = this.serializeJobData(trigger.getJobDataMap());
            int len = baos.toByteArray().length;
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            PreparedStatement ps = null;
            insertResult = 0;
            try {
                ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, IS_VOLATILE = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, JOB_DATA = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                ps.setString(1, trigger.getJobName());
                ps.setString(2, trigger.getJobGroup());
                ps.setBoolean(3, trigger.isVolatile());
                ps.setString(4, trigger.getDescription());
                long nextFireTime = -1L;
                if (trigger.getNextFireTime() != null) {
                    nextFireTime = trigger.getNextFireTime().getTime();
                }
                ps.setBigDecimal(5, new BigDecimal(String.valueOf(nextFireTime)));
                long prevFireTime = -1L;
                if (trigger.getPreviousFireTime() != null) {
                    prevFireTime = trigger.getPreviousFireTime().getTime();
                }
                ps.setBigDecimal(6, new BigDecimal(String.valueOf(prevFireTime)));
                ps.setString(7, state);
                if (trigger instanceof SimpleTrigger) {
                    ps.setString(8, "SIMPLE");
                } else if (trigger instanceof CronTrigger) {
                    ps.setString(8, "CRON");
                } else {
                    ps.setString(8, "BLOB");
                }
                ps.setBigDecimal(9, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
                long endTime = 0L;
                if (trigger.getEndTime() != null) {
                    endTime = trigger.getEndTime().getTime();
                }
                ps.setBigDecimal(10, new BigDecimal(String.valueOf(endTime)));
                ps.setString(11, trigger.getCalendarName());
                ps.setInt(12, trigger.getMisfireInstruction());
                ps.setBinaryStream(13, (InputStream)bais, len);
                ps.setString(14, trigger.getName());
                ps.setString(15, trigger.getGroup());
                insertResult = ps.executeUpdate();
                Object var17_14 = null;
                if (null == ps) break block13;
            }
            catch (Throwable throwable) {
                Object var17_15 = null;
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException ignore) {}
            ps.close();
        }
        if (insertResult <= 0) return insertResult;
        this.deleteTriggerListeners(conn, trigger.getName(), trigger.getGroup());
        String[] trigListeners = trigger.getTriggerListenerNames();
        int i = 0;
        while (trigListeners != null) {
            if (i >= trigListeners.length) return insertResult;
            this.insertTriggerListener(conn, trigger, trigListeners[i]);
            ++i;
        }
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateJobData(Connection conn, JobDetail job) throws IOException, SQLException {
        int n;
        block5: {
            ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
            int len = baos.toByteArray().length;
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            PreparedStatement ps = null;
            try {
                ps = conn.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
                ps.setBinaryStream(1, (InputStream)bais, len);
                ps.setString(2, job.getName());
                ps.setString(3, job.getGroup());
                n = ps.executeUpdate();
                Object var9_8 = null;
                if (null == ps) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var9_9 = null;
                    if (null == ps) break block6;
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {}
                }
                throw throwable;
            }
            try {
                ps.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        int n;
        block5: {
            ByteArrayOutputStream baos = this.serializeObject(calendar);
            byte[] buf = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            PreparedStatement ps = null;
            try {
                ps = conn.prepareStatement(this.rtp("INSERT INTO {0}CALENDARS (CALENDAR_NAME, CALENDAR)  VALUES(?, ?)"));
                ps.setString(1, calendarName);
                ps.setBinaryStream(2, (InputStream)bais, buf.length);
                n = ps.executeUpdate();
                Object var10_9 = null;
                if (null == ps) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var10_10 = null;
                    if (null == ps) break block6;
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {}
                }
                throw throwable;
            }
            try {
                ps.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        int n;
        block5: {
            ByteArrayOutputStream baos = this.serializeObject(calendar);
            byte[] buf = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            PreparedStatement ps = null;
            try {
                ps = conn.prepareStatement(this.rtp("UPDATE {0}CALENDARS SET CALENDAR = ?  WHERE CALENDAR_NAME = ?"));
                ps.setBinaryStream(1, (InputStream)bais, buf.length);
                ps.setString(2, calendarName);
                n = ps.executeUpdate();
                Object var10_9 = null;
                if (null == ps) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var10_10 = null;
                    if (null == ps) break block6;
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {}
                }
                throw throwable;
            }
            try {
                ps.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        return n;
    }

    protected Object getObjectFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        Object obj = null;
        byte[] binaryData = rs.getBytes(colName);
        ByteArrayInputStream binaryInput = new ByteArrayInputStream(binaryData);
        if (null != binaryInput && ((InputStream)binaryInput).available() != 0) {
            ObjectInputStream in = new ObjectInputStream(binaryInput);
            obj = in.readObject();
            in.close();
        }
        return obj;
    }

    protected Object getJobDetailFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        if (this.canUseProperties()) {
            byte[] data = rs.getBytes(colName);
            if (data == null) {
                return null;
            }
            ByteArrayInputStream binaryInput = new ByteArrayInputStream(data);
            return binaryInput;
        }
        return this.getObjectFromBlob(rs, colName);
    }
}

