/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.locks.ReentrantLock;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.ejb3.BaseContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJB3Util;
import org.jboss.ejb3.SessionContainer;
import org.jboss.ejb3.interceptor.InterceptorInfo;
import org.jboss.serial.io.MarshalledObject;

public class StatefulBeanContext
extends BaseContext
implements Externalizable {
    private Object id;
    private boolean txSynchronized = false;
    private boolean inInvocation = false;
    private String containerName;
    private Hashtable initialContextProperties;
    private MarshalledObject beanMO;
    private ReentrantLock lock = new ReentrantLock();
    private boolean discarded;
    public volatile boolean markedForPassivation = false;
    public volatile boolean inUse = false;
    public volatile long lastUsed = System.currentTimeMillis();

    public boolean isDiscarded() {
        return this.discarded;
    }

    public void setDiscarded(boolean discarded) {
        this.discarded = discarded;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public boolean isInInvocation() {
        return this.inInvocation;
    }

    public void setInInvocation(boolean inInvocation) {
        this.inInvocation = inInvocation;
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public boolean isTxSynchronized() {
        return this.txSynchronized;
    }

    public void setTxSynchronized(boolean txSynchronized) {
        this.txSynchronized = txSynchronized;
    }

    public void remove() {
    }

    public void setContainer(Container container) {
        this.containerName = container.getEjbName();
        this.initialContextProperties = container.getInitialContextProperties();
        super.setContainer(container);
    }

    public Container getContainer() {
        if (this.container == null) {
            SessionContainer result;
            try {
                InitialContext ctx = EJB3Util.getInitialContext(this.initialContextProperties);
                result = (SessionContainer)SessionContainer.getContainersContext(ctx).lookup(this.containerName);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
            SessionContainer container = result;
            this.setContainer(container);
        }
        return this.container;
    }

    public Object getInstance() {
        if (this.bean == null) {
            this.extractBeanAndInterceptors();
            this.getContainer().invokePostActivate(this);
        }
        return this.bean;
    }

    public SimpleMetaData getMetaData() {
        return super.getMetaData();
    }

    public Object[] getInterceptorInstances(InterceptorInfo[] interceptorInfos) {
        if (this.bean == null) {
            this.extractBeanAndInterceptors();
        }
        return super.getInterceptorInstances(interceptorInfos);
    }

    protected void extractBeanAndInterceptors() {
        try {
            Object[] beanAndInterceptors = (Object[])this.beanMO.get();
            this.bean = beanAndInterceptors[0];
            ArrayList list = (ArrayList)beanAndInterceptors[1];
            this.interceptorInstances = new HashMap();
            if (list != null) {
                for (Object o : list) {
                    this.interceptorInstances.put(o.getClass(), o);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.containerName);
        out.writeObject(this.id);
        out.writeObject(this.metadata);
        if (this.bean == null) {
            out.writeObject(this.beanMO);
        } else {
            Object[] beanAndInterceptors = new Object[2];
            beanAndInterceptors[0] = this.bean;
            if (this.interceptorInstances != null && this.interceptorInstances.size() > 0) {
                ArrayList list = new ArrayList();
                list.addAll(this.interceptorInstances.values());
                beanAndInterceptors[1] = list;
            }
            this.beanMO = new MarshalledObject((Object)beanAndInterceptors);
            out.writeObject(this.beanMO);
        }
        out.writeObject(this.initialContextProperties);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.containerName = in.readUTF();
        this.id = in.readObject();
        this.metadata = (SimpleMetaData)in.readObject();
        this.beanMO = (MarshalledObject)in.readObject();
        this.initialContextProperties = (Hashtable)in.readObject();
    }
}

