/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.util.StringTokenizer;
import org.jacorb.util.ObjectUtil;
import org.jacorb.util.ValueHandler;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.IDLEntity;

public class RepositoryID {
    public static String className(String string, ClassLoader classLoader) {
        return RepositoryID.className(string, null, classLoader);
    }

    public static String className(String string, String string2, ClassLoader classLoader) {
        if (string.startsWith("RMI:")) {
            string = RepositoryID.convertFromISOLatin1(string);
            return string.substring(4, string.indexOf(58, 4)) + (string2 != null ? string2 : "");
        }
        if (string.startsWith("IDL:")) {
            String string3 = string.substring(4, string.lastIndexOf(58)) + (string2 != null ? string2 : "");
            if (string3.equals("omg.org/CORBA/WStringValue")) {
                return "java.lang.String";
            }
            int n = string3.indexOf("/");
            String string4 = n == -1 ? "" : string3.substring(0, n);
            if (string4.equals("omg.org")) {
                return RepositoryID.ir2scopes("org.omg", string3.substring(n + 1), classLoader);
            }
            if (string4.indexOf(46) != -1) {
                return RepositoryID.ir2scopes(RepositoryID.reversePrefix(string4), string3.substring(n + 1), classLoader);
            }
            return RepositoryID.ir2scopes("", string3, classLoader);
        }
        throw new INTF_REPOS("Unrecognized RepositoryID: " + string);
    }

    private static String convertFromISOLatin1(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf("\\U", n)) != -1) {
            stringBuffer.append(string.substring(n, n2));
            n = n2 + 6;
            char c = (char)Integer.parseInt(string.substring(n2 + 2, n2 + 6), 16);
            stringBuffer.append(c);
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private static final String reversePrefix(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken() + '.' + string2;
        }
        return string2;
    }

    private static String ir2scopes(String string, String string2, ClassLoader classLoader) {
        if (string2.indexOf("/") < 0) {
            return string2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
        int n = stringTokenizer.countTokens();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            Class clazz = null;
            clazz = stringBuffer.toString().length() > 0 ? RepositoryID.loadClass(stringBuffer.toString() + "." + string3, classLoader) : RepositoryID.loadClass(string3, classLoader);
            if (clazz == null) {
                if (stringBuffer.toString().length() > 0) {
                    stringBuffer.append("." + string3);
                } else {
                    stringBuffer.append(string3);
                }
            } else if (n2 < n - 1) {
                stringBuffer.append("." + string3 + "Package");
            } else {
                stringBuffer.append("." + string3);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String repId(Class clazz) {
        if (IDLEntity.class.isAssignableFrom(clazz)) {
            String string = clazz.getName();
            String string2 = "";
            if (string.startsWith("org.omg") || string.startsWith("org/omg")) {
                if (string.length() > 7) {
                    string2 = string.substring(7);
                }
                return "IDL:omg.org/" + RepositoryID.scopesToIR(string2) + ":1.0";
            }
            return "IDL:" + RepositoryID.scopesToIR(string) + ":1.0";
        }
        return ValueHandler.getRMIRepositoryID(clazz);
    }

    private static String scopesToIR(String string) {
        if (string.indexOf(".") < 0) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringArray[n] = string2.endsWith("Package") ? string2.substring(0, string2.indexOf("Package")) : string2;
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length > 1) {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuffer.append(stringArray[i] + "/");
            }
        }
        stringBuffer.append(stringArray[stringArray.length - 1]);
        return stringBuffer.toString();
    }

    public static String toRepositoryID(String string, boolean bl, ClassLoader classLoader) {
        if (string.equals("") || string.startsWith("IDL:") || string.startsWith("RMI:")) {
            return string;
        }
        if (bl) {
            Class clazz = RepositoryID.loadClass(string, classLoader);
            if (clazz == null) {
                throw new IllegalArgumentException("cannot find class: " + string);
            }
            return RepositoryID.repId(clazz);
        }
        return "IDL:" + string + ":1.0";
    }

    public static String toRepositoryID(String string, ClassLoader classLoader) {
        return RepositoryID.toRepositoryID(string, true, classLoader);
    }

    private static Class loadClass(String string, ClassLoader classLoader) {
        try {
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
            return ObjectUtil.classForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static BoxedValueHelper createBoxedValueHelper(String string, ClassLoader classLoader) {
        String string2 = RepositoryID.className(string, "Helper", classLoader);
        Class clazz = RepositoryID.loadClass(string2, classLoader);
        if (clazz != null) {
            try {
                return (BoxedValueHelper)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }
}

