/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.handler;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.util.xml.XmlUtil;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.WebServiceException;

class LogicalMessageImpl
implements LogicalMessage {
    private Packet packet;
    private Source payloadSrc = null;
    private boolean payloadModifed = false;

    public LogicalMessageImpl(Packet packet) {
        this.packet = packet;
    }

    boolean isPayloadModifed() {
        return this.payloadModifed;
    }

    Source getModifiedPayload() {
        if (!this.payloadModifed) {
            throw new RuntimeException("Payload not modified.");
        }
        return this.payloadSrc;
    }

    public Source getPayload() {
        if (!this.payloadModifed) {
            this.payloadSrc = this.packet.getMessage().readPayloadAsSource();
            this.payloadModifed = true;
        }
        if (this.payloadSrc == null) {
            return null;
        }
        if (this.payloadSrc instanceof DOMSource) {
            return this.payloadSrc;
        }
        try {
            Transformer transformer = XmlUtil.newTransformer();
            DOMResult domResult = new DOMResult();
            transformer.transform(this.payloadSrc, domResult);
            this.payloadSrc = new DOMSource(domResult.getNode());
            return this.payloadSrc;
        }
        catch (TransformerException te) {
            throw new WebServiceException(te);
        }
    }

    public void setPayload(Source payload) {
        this.payloadModifed = true;
        this.payloadSrc = payload;
    }

    public Object getPayload(JAXBContext context) {
        try {
            Source payloadSrc = this.getPayload();
            if (payloadSrc == null) {
                return null;
            }
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return unmarshaller.unmarshal(payloadSrc);
        }
        catch (JAXBException e) {
            throw new WebServiceException(e);
        }
    }

    public void setPayload(Object payload, JAXBContext context) {
        this.payloadModifed = true;
        try {
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            DOMResult domResult = new DOMResult();
            marshaller.marshal(payload, (Result)domResult);
            this.payloadSrc = new DOMSource(domResult.getNode());
        }
        catch (JAXBException e) {
            throw new WebServiceException(e);
        }
    }
}

