/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.tools.reflect;

import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.tools.reflect.ReflectedArrayProperty;
import cirrus.hibernate.tools.reflect.ReflectedClass;
import cirrus.hibernate.tools.reflect.ReflectedCollectionProperty;
import cirrus.hibernate.tools.reflect.ReflectedComponent;
import cirrus.hibernate.tools.reflect.ReflectedListProperty;
import cirrus.hibernate.tools.reflect.ReflectedMapProperty;
import cirrus.hibernate.tools.reflect.ReflectedProperty;
import cirrus.hibernate.tools.reflect.ReflectedSetProperty;
import cirrus.hibernate.type.Type;
import cirrus.hibernate.type.TypeFactory;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Vector;

public class MappingByReflection {
    private static String[] defaultKeys = new String[]{"uid", "UID", "id", "ID", "key", "KEY", "pk", "PK"};
    private ClassLoader classLoader;
    private boolean verbose = true;
    protected int maxDepth = 0;
    protected String[] niceKeys = defaultKeys;
    protected StringBuffer buf;
    protected Hashtable rClasses;
    protected Hashtable abstractClasses = new Hashtable(5);
    protected Hashtable cycleBuster;
    private Hashtable usedTableNames;
    private Hashtable usedColumnNames;
    private Vector entities;
    private Vector roots;
    private char[] prefix = StringHelper.repeat("\t", 100).toCharArray();
    private String interact_usage = "usage: class.name | uid=<newUID> | done";
    static /* synthetic */ Class class$cirrus$hibernate$PersistentEnum;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$Collection;

    public static void main(String[] args) {
        FileWriter outputWriter = null;
        int len = args.length;
        if (len == 0) {
            System.out.println("<!-- No args provided, no classes reflected! -->");
        } else if (len == 1 && "--interact".equals(args[0])) {
            MappingByReflection map = new MappingByReflection(null, ClassLoader.getSystemClassLoader());
            map.interact();
        } else {
            MappingByReflection map = new MappingByReflection(null, ClassLoader.getSystemClassLoader());
            int i = 0;
            while (i < len) {
                if (args[i].startsWith("--")) {
                    if (args[i].startsWith("--setUID=")) {
                        map.setUID(args[i].substring(9));
                    } else if (args[i].startsWith("--addUID=")) {
                        map.addUID(args[i].substring(9));
                    } else if (args[i].startsWith("--depth=")) {
                        try {
                            map.maxDepth = Integer.parseInt(args[i].substring(8));
                        }
                        catch (NumberFormatException e) {
                            System.err.println("<!-- Can't set maxDepth " + e.getMessage() + "-->");
                        }
                    } else if (args[i].equals("--quiet")) {
                        map.verbose = false;
                    } else if (args[i].startsWith("--output=")) {
                        outputWriter = MappingByReflection.makeWriter(args[i].substring(9));
                    } else if (args[i].startsWith("--abstract=")) {
                        map.abstractClasses.put(args[i].substring(11), "");
                    }
                } else {
                    map.addClass(args[i], true);
                }
                ++i;
            }
            map.writeXML(outputWriter);
        }
    }

    public void writeXML(Writer outputWriter) {
        String xml = this.getXML();
        if (outputWriter != null) {
            try {
                outputWriter.write(xml);
                outputWriter.flush();
            }
            catch (Exception e) {
                outputWriter = null;
            }
        }
        if (this.verbose || outputWriter == null) {
            System.out.println(xml);
        }
    }

    private static FileWriter makeWriter(String fileName) {
        try {
            FileWriter fw = new FileWriter(fileName);
            return fw;
        }
        catch (Exception e) {
            System.err.println("<!-- Error making FileWriter " + e.getMessage() + "-->");
            return null;
        }
    }

    public MappingByReflection(String[] className, ClassLoader loader) {
        this.setClassLoader(loader);
        this.reset();
        if (className != null) {
            int len = className.length;
            int i = 0;
            while (i < len) {
                this.addClass(className[i], true);
                ++i;
            }
        }
    }

    private void interact() {
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        StreamTokenizer st = new StreamTokenizer(r);
        st.wordChars(33, 126);
        System.out.println(this.interact_usage);
        System.out.print("? ");
        boolean allIsWell = true;
        while (allIsWell) {
            int tt;
            try {
                tt = st.nextToken();
            }
            catch (Exception e) {
                System.out.println("IOException; done");
                tt = -1;
            }
            switch (tt) {
                case -1: {
                    allIsWell = false;
                    break;
                }
                case 10: {
                    st.eolIsSignificant(false);
                    break;
                }
                case -2: {
                    System.out.println("number!? ");
                    System.out.println(this.interact_usage);
                    System.out.print("? ");
                    break;
                }
                case -3: {
                    String name = st.sval;
                    if ("done".equals(name)) {
                        allIsWell = false;
                        break;
                    }
                    if (name.startsWith("uid=")) {
                        String uid = name.substring(4);
                        System.out.print("niceKey(" + uid + ")=>");
                        this.addUID(uid);
                        int i = 0;
                        while (i < this.niceKeys.length) {
                            System.out.print(" ");
                            System.out.print(this.niceKeys[i]);
                            ++i;
                        }
                        System.out.print("\n? ");
                        break;
                    }
                    System.out.println("addClass(" + name + ")");
                    this.addClass(name, true);
                    System.out.print("? ");
                    break;
                }
            }
        }
        System.out.println(this.getXML());
    }

    public void reset() {
        this.buf = new StringBuffer();
        this.roots = new Vector();
        this.entities = new Vector();
        this.rClasses = new Hashtable();
        this.usedTableNames = new Hashtable();
        this.buf.append("<?xml version=\"1.0\"?>\n").append("<!DOCTYPE hibernate-mapping PUBLIC\n").append("\t\"-//Hibernate/Hibernate Mapping DTD//EN\"\n").append("\t\"http://hibernate.sourceforge.net/hibernate-mapping.dtd\">\n");
    }

    public void addClass(String className, boolean verbose) {
        ReflectedClass rc;
        Class clazz = this.checkClassNamed(className, verbose);
        if (clazz != null && (rc = this.reallyAdd(clazz, verbose)) == null && verbose) {
            this.buf.append("<!-- ").append(clazz.getName()).append(" cannot be added, no UID found! -->\n");
        }
    }

    public void setUID(String uid) {
        String[] uida = new String[]{uid};
        this.niceKeys = uida;
    }

    public void addUID(String uid) {
        String[] uida = new String[this.niceKeys.length + 1];
        int i = 0;
        while (i < this.niceKeys.length) {
            uida[i + 1] = this.niceKeys[i];
            ++i;
        }
        uida[0] = uid;
        this.niceKeys = uida;
        int i2 = 0;
        while (i2 < this.niceKeys.length) {
            System.out.print(" ");
            System.out.print(this.niceKeys[i2]);
            ++i2;
        }
    }

    public ReflectedClass[] getRoots() {
        Object[] v = new ReflectedClass[this.roots.size()];
        this.roots.copyInto(v);
        return v;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ReflectedClass reallyAdd(Class clazz, boolean verbose) {
        ReflectedClass rc = (ReflectedClass)this.rClasses.get(clazz);
        Class superclass = clazz.getSuperclass();
        if (rc == null) {
            rc = new ReflectedClass(this, clazz);
        } else if (rc.isPersistent()) {
            if (!verbose) return rc;
            this.buf.append("<!-- ").append(clazz.getName()).append(" already added -->\n");
            return rc;
        }
        rc.setPersistent(true);
        if (rc.getUidProp(this.niceKeys) != null) {
            rc.addSuperclassProps();
            this.roots.add(rc);
            return rc;
        }
        if (superclass != null && this.abstractClasses.containsKey(superclass.getName())) {
            rc.addSuperclassProps();
            if (rc.getUidProp(this.niceKeys) != null) {
                this.roots.add(rc);
                return rc;
            }
            rc.setPersistent(false);
            return null;
        }
        if (superclass == null) {
            rc.setPersistent(false);
            return null;
        }
        ReflectedClass sup = this.reallyAdd(superclass, false);
        if (sup == null) {
            rc.setPersistent(false);
            return null;
        }
        sup.addReflectedClass(rc);
        return rc;
    }

    protected String nextName(String best, Hashtable h) {
        Integer seen = (Integer)h.get(best);
        if (seen == null) {
            h.put(best, new Integer(1));
            return best;
        }
        h.put(best, new Integer(seen + 1));
        return best + "_" + seen;
    }

    protected String tableNameFor(String name) {
        String best = StringHelper.unqualify(name);
        return this.nextName(best, this.usedTableNames);
    }

    protected String columnNameFor(String best) {
        return this.nextName(best, this.usedColumnNames);
    }

    protected void emitPrefix(int n) {
        int e = n * 1;
        if (e > this.prefix.length) {
            e = this.prefix.length;
        }
        this.buf.append(this.prefix, 0, e);
    }

    public String getXML() {
        this.buf.append("<hibernate-mapping>\n");
        int eln = this.entities.size();
        int i = 0;
        while (i < eln) {
            PEntity pet = (PEntity)this.roots.get(i);
            this.usedColumnNames = new Hashtable();
            pet.getXML(1, true);
            ++i;
        }
        int len = this.roots.size();
        int i2 = 0;
        while (i2 < len) {
            ReflectedClass rc = (ReflectedClass)this.roots.get(i2);
            this.usedColumnNames = new Hashtable();
            rc.getXML(1);
            ++i2;
        }
        this.buf.append("</hibernate-mapping>\n");
        return this.buf.toString();
    }

    private Class checkClassNamed(String className, boolean v) {
        try {
            Class<?> clazz = this.classLoader.loadClass(className);
            return this.checkClass(clazz, className, v);
        }
        catch (Exception e) {
            if (v) {
                this.buf.append("<!-- Class ").append(className).append(" gave exception ").append(e).append(" -->\n");
            }
            return null;
        }
    }

    protected ReflectedProperty makeProperty(String name, Class cls) {
        String tynm = cls.getName();
        Type htyp = TypeFactory.basic(tynm);
        if (htyp != null) {
            return new ReflectedProperty(name, cls, this, "basic");
        }
        if (cls.isArray()) {
            return new ReflectedArrayProperty(name, cls, this);
        }
        if ((class$cirrus$hibernate$PersistentEnum == null ? (class$cirrus$hibernate$PersistentEnum = MappingByReflection.class$("cirrus.hibernate.PersistentEnum")) : class$cirrus$hibernate$PersistentEnum).isAssignableFrom(cls)) {
            return new ReflectedProperty(name, cls, this, "enum");
        }
        if ((class$java$util$List == null ? (class$java$util$List = MappingByReflection.class$("java.util.List")) : class$java$util$List).isAssignableFrom(cls)) {
            return new ReflectedListProperty(name, cls, this);
        }
        if ((class$java$util$Map == null ? (class$java$util$Map = MappingByReflection.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(cls)) {
            return new ReflectedMapProperty(name, cls, this);
        }
        if ((class$java$util$Set == null ? (class$java$util$Set = MappingByReflection.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(cls)) {
            return new ReflectedSetProperty(name, cls, this);
        }
        if ((class$java$util$Collection == null ? (class$java$util$Collection = MappingByReflection.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(cls)) {
            return new ReflectedCollectionProperty(name, cls, this);
        }
        Class comp = this.checkComponent(cls, tynm, true);
        if (comp == null) {
            return new ReflectedProperty(name, cls, this, "custom");
        }
        ReflectedClass rc = (ReflectedClass)this.rClasses.get(comp);
        if (rc == null) {
            rc = new ReflectedClass(this, comp);
        }
        return new ReflectedComponent(name, cls, this, rc);
    }

    protected Class checkClass(Class clazz, String className, boolean v) {
        return this.checkClCoGuts(clazz, className, v, "<!-- Class ");
    }

    protected Class checkComponent(Class clazz, String className, boolean v) {
        return this.checkClCoGuts(clazz, className, v, "<!-- Component ");
    }

    private Class checkClCoGuts(Class clazz, String className, boolean v, String c) {
        Constructor<Object> z;
        if (clazz.isPrimitive()) {
            if (v) {
                this.buf.append(c).append(className).append(" is a primitive! -->\n");
            }
            return null;
        }
        if (clazz.isArray()) {
            if (v) {
                this.buf.append(c).append(className).append(" is an array! -->\n");
            }
            return null;
        }
        if (clazz.isInterface()) {
            if (v) {
                this.buf.append(c).append(className).append(" is an interface! -->\n");
            }
            return null;
        }
        if (clazz.getDeclaringClass() != null) {
            if (v) {
                this.buf.append(c).append(className).append(" is a nested class! -->\n");
            }
            return null;
        }
        try {
            z = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            z = null;
        }
        catch (SecurityException e) {
            if (v) {
                this.buf.append(c).append(className).append(" cannot be reflected due to a SecurityException! -->\n");
            }
            return null;
        }
        if (z == null) {
            try {
                Constructor<?>[] cs = clazz.getDeclaredConstructors();
                int i = 0;
                while (i < cs.length) {
                    if (cs[i].getParameterTypes().length == 0) {
                        z = cs[i];
                        break;
                    }
                    ++i;
                }
            }
            catch (SecurityException e) {
                if (v) {
                    this.buf.append(c).append(className).append(" cannot be reflected due to a SecurityException! -->\n");
                }
                return null;
            }
        }
        if (z == null) {
            if (v) {
                this.buf.append(c).append(className).append(" has no 0-arg constructor! -->\n");
            }
            return null;
        }
        return clazz;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PEntity {
        PEntity() {
        }

        void getXML(int level, boolean isRoot) {
        }
    }
}

