/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.rmi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import javax.net.SocketFactory;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.UnMarshallerDecorator;
import org.jboss.remoting.transport.rmi.RMIServerInvokerInf;
import org.jboss.remoting.transport.rmi.RemotingRMIClientSocketFactory;
import org.jboss.remoting.transport.rmi.RemotingRMIServerSocketFactory;

public class RMIServerInvoker
extends ServerInvoker
implements RMIServerInvokerInf {
    private Remote stub;
    public static final String SOCKET_FACTORY = "socketFactory";
    public static final int BACKLOG_DEFAULT = 200;
    public static final int DEFAULT_REGISTRY_PORT = 3455;
    public static final String REGISTRY_PORT_KEY = "registryPort";
    private Marshaller marshaller = null;
    private UnMarshaller unmarshaller = null;
    private SocketFactory socketFactory = null;

    public RMIServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    protected void setup() throws Exception {
        super.setup();
        int bindPort = this.getServerBindPort();
        Registry registry = null;
        registry = this.getRegistry();
        String bindHost = this.getServerBindAddress();
        String clientConnectHost = this.getClientConnectAddress();
        if (clientConnectHost == null) {
            clientConnectHost = bindHost;
        }
        RemotingRMIServerSocketFactory ssf = new RemotingRMIServerSocketFactory(this.getServerSocketFactory(), 200, bindHost, this.getTimeout());
        RemotingRMIClientSocketFactory csf = new RemotingRMIClientSocketFactory(this.getSocketFactory(), clientConnectHost, this.getTimeout());
        this.stub = UnicastRemoteObject.exportObject(this, bindPort, csf, ssf);
        this.log.debug("Binding registry to remoting/RMIServerInvoker/" + bindPort);
        registry.rebind("remoting/RMIServerInvoker/" + bindPort, this);
        this.unmarshaller = MarshalFactory.getUnMarshaller(this.getLocator(), this.getClass().getClassLoader());
        this.marshaller = MarshalFactory.getMarshaller(this.getLocator(), this.getClass().getClassLoader());
    }

    public SocketFactory getSocketFactory() throws IOException {
        if (this.socketFactory == null) {
            this.socketFactory = this.createSocketFactory();
        }
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory factory) {
        this.socketFactory = factory;
    }

    protected SocketFactory createSocketFactory() throws IOException {
        if (this.socketFactory == null) {
            String socketFactoryString = (String)this.configuration.get(SOCKET_FACTORY);
            ClassLoader classLoader = null;
            if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
                classLoader = this.getClass().getClassLoader();
            }
            try {
                Class<?> cl = classLoader.loadClass(socketFactoryString);
                Constructor<?> socketConstructor = null;
                socketConstructor = cl.getConstructor(new Class[0]);
                this.socketFactory = (SocketFactory)socketConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                this.log.debug("Could not create socket factory by classname (" + socketFactoryString + ").  Error message: " + e.getMessage());
            }
        }
        if (this.socketFactory == null) {
            this.log.debug("Did not find socket factory configuration as mbean service or classname.  Creating default server socket.");
            this.socketFactory = this.getDefaultSocketFactory();
        }
        this.log.debug("Created server socket factory: " + this.socketFactory);
        return this.socketFactory;
    }

    protected SocketFactory getDefaultSocketFactory() {
        return null;
    }

    public RMIServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    private Registry getRegistry() throws Exception {
        String value;
        Registry registry = null;
        int port = 3455;
        Map params = this.getConfiguration();
        if (params != null && (value = (String)params.get(REGISTRY_PORT_KEY)) != null) {
            try {
                port = Integer.parseInt(value);
                this.log.debug("Using port " + port + " for rmi registry.");
            }
            catch (NumberFormatException e) {
                throw new Exception("Can not set the RMIServerInvoker RMI registry to port " + value + ".  This is not a valid port number.");
            }
        }
        try {
            this.log.debug("Creating registry for " + port);
            registry = LocateRegistry.createRegistry(port);
        }
        catch (ExportException exportEx) {
            this.log.debug("Locating registry for " + port);
            registry = LocateRegistry.getRegistry(port);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Got registry: " + registry);
        }
        return registry;
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    public void destroy() {
        super.destroy();
        try {
            try {
                this.log.debug("unbinding remoting/RMIServerInvoker/" + this.locator.getPort() + " from registry running on port " + (this.locator.getPort() + 1));
                Registry registry = this.getRegistry();
                registry.unbind("remoting/RMIServerInvoker/" + this.locator.getPort());
            }
            catch (Exception e) {
                this.log.error("Error unbinding RMIServerInvoker from RMI registry.", e);
            }
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public boolean isTransportBiDirectional() {
        return true;
    }

    public final Remote getStub() {
        return this.stub;
    }

    public Object transport(Object invocation) throws RemoteException, IOException {
        Object payload = invocation;
        if (this.unmarshaller != null) {
            if (this.unmarshaller instanceof UnMarshallerDecorator) {
                payload = ((UnMarshallerDecorator)((Object)this.unmarshaller)).removeDecoration(payload);
            } else {
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(byteOut);
                oos.writeObject(payload);
                oos.flush();
                ByteArrayInputStream is = new ByteArrayInputStream(byteOut.toByteArray());
                try {
                    oos.close();
                    payload = this.unmarshaller.read(is, null);
                    is.close();
                }
                catch (ClassNotFoundException e) {
                    this.log.error("Could not unmarshall invocation request" + payload, e);
                    throw new IOException(e.getMessage());
                }
            }
        }
        Object response = this.invoke(payload);
        return response;
    }
}

