/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.message.config;

import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthParam;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.config.ServerAuthContext;
import javax.security.auth.message.module.ServerAuthModule;
import org.jboss.security.auth.message.config.JBossServerAuthConfig;

public class JBossServerAuthContext
implements ServerAuthContext {
    private JBossServerAuthConfig config = null;

    public JBossServerAuthContext(JBossServerAuthConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        this.config = config;
    }

    public void cleanSubject(Subject subject, Map sharedState) throws AuthException {
        Iterator iter = this.config.getServerAuthModules().iterator();
        while (iter.hasNext()) {
            ((ServerAuthModule)iter.next()).cleanSubject(subject, sharedState);
        }
    }

    public AuthStatus secureResponse(AuthParam authParam, Subject service, Map sharedState) throws AuthException {
        Iterator iter = this.config.getServerAuthModules().iterator();
        AuthStatus status = null;
        while (iter.hasNext() && (status = ((ServerAuthModule)iter.next()).secureResponse(authParam, service, sharedState)) != AuthStatus.FAIL) {
        }
        return status;
    }

    public AuthStatus validateRequest(AuthParam authParam, Subject client, Subject service, Map sharedState) throws AuthException {
        Iterator iter = this.config.getServerAuthModules().iterator();
        AuthStatus status = null;
        while (iter.hasNext() && (status = ((ServerAuthModule)iter.next()).validateRequest(authParam, client, service, sharedState)) != AuthStatus.FAIL) {
        }
        return status;
    }
}

