/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import junit.framework.TestCase;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.DOMWriter;
import org.jboss.wsf.test.JBossWSTestHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class JBossWSTest
extends TestCase {
    protected Logger log = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private JBossWSTestHelper delegate = new JBossWSTestHelper();

    public JBossWSTest() {
    }

    public JBossWSTest(String string) {
        super(string);
    }

    public MBeanServerConnection getServer() throws NamingException {
        JBossWSTest jBossWSTest = this;
        return jBossWSTest.delegate.getServer();
    }

    public boolean isTargetJBoss50() {
        return this.delegate.isTargetJBoss50();
    }

    public boolean isTargetJBoss42() {
        return this.delegate.isTargetJBoss42();
    }

    public boolean isTargetJBoss40() {
        return this.delegate.isTargetJBoss40();
    }

    public boolean isIntegrationNative() {
        return this.delegate.isIntegrationNative();
    }

    public boolean isIntegrationSunRI() {
        return this.delegate.isIntegrationSunRI();
    }

    public boolean isIntegrationXFire() {
        return this.delegate.isIntegrationXFire();
    }

    public void deploy(String string) throws Exception {
        this.delegate.deploy(string);
    }

    public void undeploy(String string) throws Exception {
        this.delegate.undeploy(string);
    }

    public String getServerHost() {
        JBossWSTest jBossWSTest = this;
        return jBossWSTest.delegate.getServerHost();
    }

    protected InitialContext getInitialContext(String string) throws NamingException {
        InitialContext initialContext = new InitialContext();
        Hashtable<?, ?> hashtable = initialContext.getEnvironment();
        hashtable.put("java.naming.factory.url.pkgs", "org.jboss.naming.client");
        hashtable.put("j2ee.clientName", string);
        return new InitialContext(hashtable);
    }

    protected InitialContext getInitialContext() throws NamingException {
        return this.getInitialContext("jbossws-client");
    }

    public boolean hasJDK15() {
        try {
            Class.forName("java.lang.Enum");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static void assertEquals(Element element, Element element2, boolean bl) {
        JBossWSTest.normalizeWhitspace(element, bl);
        JBossWSTest.normalizeWhitspace(element2, bl);
        String string = DOMWriter.printNode(element, false);
        String string2 = DOMWriter.printNode(element2, false);
        if (!string.equals(string2)) {
            System.out.println("\nExp: " + string + "\nWas: " + string2);
            Logger.getLogger(JBossWSTest.class).error((Object)("\nExp: " + string + "\nWas: " + string2));
        }
        JBossWSTest.assertEquals((String)string, (String)string2);
    }

    public static void assertEquals(Element element, Element element2) {
        JBossWSTest.assertEquals(element, element2, false);
    }

    public static void assertEquals(Object object, Object object2) {
        if (object instanceof Object[] && object2 instanceof Object[]) {
            JBossWSTest.assertEqualsArray((Object[])object, (Object[])object2);
        } else if (object instanceof byte[] && object2 instanceof byte[]) {
            JBossWSTest.assertEqualsArray((byte[])object, (byte[])object2);
        } else if (object instanceof boolean[] && object2 instanceof boolean[]) {
            JBossWSTest.assertEqualsArray((boolean[])object, (boolean[])object2);
        } else if (object instanceof short[] && object2 instanceof short[]) {
            JBossWSTest.assertEqualsArray((short[])object, (short[])object2);
        } else if (object instanceof int[] && object2 instanceof int[]) {
            JBossWSTest.assertEqualsArray((int[])object, (int[])object2);
        } else if (object instanceof long[] && object2 instanceof long[]) {
            JBossWSTest.assertEqualsArray((long[])object, (long[])object2);
        } else if (object instanceof float[] && object2 instanceof float[]) {
            JBossWSTest.assertEqualsArray((float[])object, (float[])object2);
        } else if (object instanceof double[] && object2 instanceof double[]) {
            JBossWSTest.assertEqualsArray((double[])object, (double[])object2);
        } else {
            TestCase.assertEquals((Object)object, (Object)object2);
        }
    }

    private static void assertEqualsArray(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null && objectArray2 == null) {
            return;
        }
        if (objectArray != null && objectArray2 != null) {
            if (objectArray.length != objectArray2.length) {
                JBossWSTest.fail((String)("Expected <" + objectArray.length + "> array items, but was <" + objectArray2.length + ">"));
            } else {
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    Object object2 = objectArray2[i];
                    JBossWSTest.assertEquals(object, object2);
                }
            }
        } else if (objectArray == null) {
            JBossWSTest.fail((String)("Expected a null array, but was: " + Arrays.asList(objectArray2)));
        } else if (objectArray2 == null) {
            JBossWSTest.fail((String)("Expected " + Arrays.asList(objectArray) + ", but was: null"));
        }
    }

    private static void assertEqualsArray(byte[] byArray, byte[] byArray2) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(byArray, byArray2));
    }

    private static void assertEqualsArray(boolean[] blArray, boolean[] blArray2) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(blArray, blArray2));
    }

    private static void assertEqualsArray(short[] sArray, short[] sArray2) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(sArray, sArray2));
    }

    private static void assertEqualsArray(int[] nArray, int[] nArray2) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(nArray, nArray2));
    }

    private static void assertEqualsArray(long[] lArray, long[] lArray2) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(lArray, lArray2));
    }

    private static void assertEqualsArray(float[] fArray, float[] fArray2) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(fArray, fArray2));
    }

    private static void assertEqualsArray(double[] dArray, double[] dArray2) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(dArray, dArray2));
    }

    private static void normalizeWhitspace(Element element, boolean bl) {
        boolean bl2 = false;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        String string = element.getNodeName();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3 && (string2 = node.getNodeValue()).trim().length() == 0) {
                arrayList.add(node);
            }
            if (node.getNodeType() != 1) continue;
            JBossWSTest.normalizeWhitspace((Element)node, bl);
            bl2 = true;
        }
        if (bl2 || bl) {
            for (Node node : arrayList) {
                element.removeChild(node);
            }
        }
    }
}

