/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpInternalErrorException;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.InvocationContext;
import com.meterware.servletunit.InvocationContextFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import org.xml.sax.SAXException;

public class ServletUnitClient
extends WebClient {
    private InvocationContextFactory _invocationContextFactory;
    private static final Cookie[] NO_COOKIES = new Cookie[0];

    public static ServletUnitClient newClient(InvocationContextFactory factory) {
        return new ServletUnitClient(factory);
    }

    public InvocationContext newInvocation(String requestString) throws IOException, MalformedURLException {
        return this.newInvocation(new GetMethodWebRequest(requestString));
    }

    public InvocationContext newInvocation(WebRequest request) throws IOException, MalformedURLException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeMessageBody(request, baos);
        return this._invocationContextFactory.newInvocation(request, this.getCookies(), this.getHeaderFields(), baos.toByteArray());
    }

    public WebResponse getResponse(InvocationContext invocation) throws MalformedURLException, IOException, SAXException {
        this.updateClient(invocation.getServletResponse());
        return this.getFrameContents(invocation.getTarget());
    }

    protected WebResponse newResponse(WebRequest request) throws MalformedURLException, IOException {
        try {
            InvocationContext invocation = this.newInvocation(request);
            invocation.getServlet().service((ServletRequest)invocation.getRequest(), (ServletResponse)invocation.getResponse());
            return invocation.getServletResponse();
        }
        catch (ServletException e) {
            throw new HttpInternalErrorException(request.getURL(), (Throwable)e);
        }
    }

    private ServletUnitClient(InvocationContextFactory factory) {
        this._invocationContextFactory = factory;
    }

    private Cookie[] getCookies() {
        String cookieHeader = (String)this.getHeaderFields().get("Cookie");
        if (cookieHeader == null) {
            return NO_COOKIES;
        }
        Vector<Cookie> cookies = new Vector<Cookie>();
        StringTokenizer st = new StringTokenizer(cookieHeader, "=;");
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            String value = st.nextToken();
            cookies.addElement(new Cookie(name, value));
        }
        Object[] results = new Cookie[cookies.size()];
        cookies.copyInto(results);
        return results;
    }
}

