/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.io.IoHelper;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.Project;
import de.hunsicker.jalopy.swing.AbstractSettingsPage;
import de.hunsicker.jalopy.swing.AddRemoveList;
import de.hunsicker.jalopy.swing.SettingsContainer;
import de.hunsicker.swing.ErrorDialog;
import de.hunsicker.swing.util.SwingHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ProjectSettingsPage
extends AbstractSettingsPage {
    private static final String FILENAME_PROJECT = "project.dat";
    private static final String EMPTY_STRING = "".intern();
    private AddRemoveList _projectsList;
    private JButton _addButton;
    private JButton _removeButton;

    public ProjectSettingsPage() {
        this.initialize();
    }

    ProjectSettingsPage(SettingsContainer container) {
        super(container);
        this.initialize();
    }

    public void updateSettings() {
    }

    private void setActive(ProjectListEntry entry) {
        DefaultListModel model = (DefaultListModel)this._projectsList.getModel();
        int i = 0;
        int size = model.size();
        while (i < size) {
            ProjectListEntry e = (ProjectListEntry)model.get(i);
            if (e.active) {
                e.active = false;
                break;
            }
            ++i;
        }
        entry.active = true;
        this._projectsList.repaint();
    }

    private Project getActiveProject() {
        try {
            File file = new File(Convention.getSettingsDirectory(), FILENAME_PROJECT);
            if (file.exists()) {
                return (Project)IoHelper.deserialize(file);
            }
            return Convention.getDefaultProject();
        }
        catch (IOException ex) {
            return Convention.getDefaultProject();
        }
    }

    private Collection getProjectEntries() {
        File directory = Convention.getSettingsDirectory();
        File[] files = directory.listFiles();
        Project activeProject = this.getActiveProject();
        ArrayList<ProjectListEntry> projects = new ArrayList<ProjectListEntry>(6);
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory() && !files[i].getName().equals("default")) {
                File file = new File(files[i], FILENAME_PROJECT);
                try {
                    if (file.exists()) {
                        Project project = (Project)IoHelper.deserialize(file);
                        ProjectListEntry entry = new ProjectListEntry(project.getName(), project.getDescription(), project.equals(activeProject), project.equals(Convention.getDefaultProject()));
                        projects.add(entry);
                    }
                }
                catch (IOException ex) {
                    file.delete();
                }
            }
            ++i;
        }
        if (projects.isEmpty()) {
            Project defaultProject = Convention.getDefaultProject();
            projects.add(new ProjectListEntry(defaultProject.getName(), defaultProject.getDescription(), true, true));
        } else {
            boolean active = false;
            int i2 = 0;
            int size = projects.size();
            while (i2 < size) {
                ProjectListEntry e = (ProjectListEntry)projects.get(i2);
                if (e.active) {
                    active = true;
                }
                ++i2;
            }
            Project defaultProject = Convention.getDefaultProject();
            projects.add(new ProjectListEntry(defaultProject.getName(), defaultProject.getDescription(), !active, true));
        }
        Collections.sort(projects);
        return projects;
    }

    private void initialize() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        Collection projects = this.getProjectEntries();
        this._projectsList = new ProjectList(this.bundle.getString("TLE_ADD_PROJECT"), null, projects);
        this._projectsList.setCellRenderer(new ProjectListCellRenderer());
        JScrollPane keysScrollPane = new JScrollPane(this._projectsList);
        SwingHelper.setConstraints(c, 0, 0, 8, 8, 1.0, 1.0, 17, 1, c.insets, 0, 0);
        layout.setConstraints(keysScrollPane, c);
        this.add(keysScrollPane);
        c.insets.bottom = 2;
        c.insets.top = 10;
        c.insets.left = 10;
        c.insets.right = 0;
        SwingHelper.setConstraints(c, 9, 1, 0, 1, 0.0, 0.0, 18, 2, c.insets, 0, 0);
        this._addButton = this._projectsList.getAddButton();
        layout.setConstraints(this._addButton, c);
        this.add(this._addButton);
        c.insets.left = 10;
        c.insets.right = 0;
        c.insets.bottom = 0;
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 9, 2, 0, 1, 0.0, 0.0, 18, 2, c.insets, 0, 0);
        this._removeButton = this._projectsList.getRemoveButton();
        this._removeButton.setEnabled(false);
        this._removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ProjectListEntry entry = (ProjectListEntry)ProjectSettingsPage.this._projectsList.getSelectedValue();
                if (entry != null) {
                    try {
                        Convention.removeProject(new Project(entry.name, entry.description));
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(ProjectSettingsPage.this, ProjectSettingsPage.this.bundle.getString("MSG_ERROR_REMOVING_PROJECT"), ProjectSettingsPage.this.bundle.getString("TLE_ERROR_REMOVING_PROJECT"), 0);
                    }
                }
            }
        });
        layout.setConstraints(this._removeButton, c);
        this.add(this._removeButton);
        final JButton activateButton = SwingHelper.createButton(this.bundle.getString("BTN_ACTIVATE"));
        activateButton.setEnabled(false);
        c.insets.top = 15;
        SwingHelper.setConstraints(c, 9, 3, 0, 1, 0.0, 1.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(activateButton, c);
        this.add(activateButton);
        activateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ProjectListEntry entry = (ProjectListEntry)ProjectSettingsPage.this._projectsList.getSelectedValue();
                if (entry != null) {
                    try {
                        Convention.setProject(new Project(entry.name, entry.description));
                        ProjectSettingsPage.this.setActive(entry);
                        if (ProjectSettingsPage.this.getContainer() != null) {
                            ProjectSettingsPage.this.getContainer().clearCache();
                        }
                        activateButton.setEnabled(false);
                        ProjectSettingsPage.this._removeButton.setEnabled(false);
                    }
                    catch (Throwable ex) {
                        ErrorDialog dialog = ErrorDialog.create(SwingUtilities.windowForComponent(ProjectSettingsPage.this), ex);
                        dialog.setVisible(true);
                        dialog.dispose();
                    }
                }
            }
        });
        this._projectsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                if (ev.getValueIsAdjusting()) {
                    return;
                }
                ProjectListEntry entry = (ProjectListEntry)ProjectSettingsPage.this._projectsList.getSelectedValue();
                if (entry != null) {
                    if (entry.standard) {
                        ((ProjectSettingsPage)ProjectSettingsPage.this)._projectsList.removeButton.setEnabled(false);
                    } else {
                        ((ProjectSettingsPage)ProjectSettingsPage.this)._projectsList.removeButton.setEnabled(true);
                    }
                    if (entry.active) {
                        activateButton.setEnabled(false);
                        ((ProjectSettingsPage)ProjectSettingsPage.this)._projectsList.removeButton.setEnabled(false);
                    } else {
                        activateButton.setEnabled(true);
                    }
                } else {
                    ((ProjectSettingsPage)ProjectSettingsPage.this)._projectsList.removeButton.setEnabled(false);
                    activateButton.setEnabled(false);
                }
            }
        });
    }

    static /* synthetic */ String access$500() {
        return EMPTY_STRING;
    }

    private static final class ProjectListEntry
    implements Comparable {
        final String description;
        final String name;
        boolean active;
        final boolean standard;

        public ProjectListEntry(String name, String description, boolean active) {
            this(name, description, false, false);
        }

        ProjectListEntry(String name, String description, boolean active, boolean standard) {
            this.name = name;
            this.description = description;
            this.standard = standard;
            this.active = active;
        }

        public int compareTo(Object o) {
            if (o instanceof ProjectListEntry) {
                return this.name.compareTo(((ProjectListEntry)o).name);
            }
            throw new ClassCastException();
        }

        public boolean equals(Object o) {
            if (o instanceof ProjectListEntry) {
                return this.name.equals(((ProjectListEntry)o).name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    private static final class ProjectListCellRenderer
    extends DefaultListCellRenderer {
        private ProjectListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ProjectListEntry entry = (ProjectListEntry)value;
            JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (entry.active) {
                Font font = this.getFont().deriveFont(1);
                component.setFont(font);
            }
            return component;
        }
    }

    private static final class ProjectList
    extends AddRemoveList {
        static /* synthetic */ Class class$javax$swing$event$ListSelectionListener;

        public ProjectList(String title, String text, Collection data) {
            super(title, text, data);
            EventListener[] listeners = this.listenerList.getListeners(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = ProjectList.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener);
            int i = 0;
            while (i < listeners.length) {
                this.listenerList.remove(class$javax$swing$event$ListSelectionListener == null ? ProjectList.class$("javax.swing.event.ListSelectionListener") : class$javax$swing$event$ListSelectionListener, listeners[i]);
                ++i;
            }
        }

        protected JDialog getAddDialog(Frame owner) {
            return new AddDialog(owner, this.title, this.text);
        }

        protected JDialog getAddDialog(Dialog owner) {
            return new AddDialog(owner, this.title, this.text);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private class AddDialog
        extends JDialog {
            public AddDialog(Frame owner, String title, String text) {
                super(owner);
                this.initialize(title, text);
            }

            public AddDialog(Dialog owner, String title, String text) {
                super(owner);
                this.initialize(title, text);
            }

            private void initialize(String title, String text) {
                this.setTitle(title);
                this.setModal(true);
                this.setDefaultCloseOperation(2);
                Container contentPane = this.getContentPane();
                GridBagLayout layout = new GridBagLayout();
                GridBagConstraints c = new GridBagConstraints();
                contentPane.setLayout(layout);
                JLabel nameLabel = new JLabel(ProjectList.this.bundle.getString("LBL_NAME"));
                c.insets.top = 10;
                c.insets.left = 5;
                c.insets.right = 5;
                SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
                layout.setConstraints(nameLabel, c);
                contentPane.add(nameLabel);
                JTextField nameTextField = new JTextField(20);
                nameLabel.setLabelFor(nameTextField);
                c.insets.top = 2;
                SwingHelper.setConstraints(c, 0, 1, 12, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
                layout.setConstraints(nameTextField, c);
                contentPane.add(nameTextField);
                JLabel descriptionLabel = new JLabel(ProjectList.this.bundle.getString("LBL_DESCRIPTION"));
                c.insets.top = 10;
                c.insets.left = 5;
                c.insets.right = 5;
                SwingHelper.setConstraints(c, 0, 2, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
                layout.setConstraints(descriptionLabel, c);
                contentPane.add(descriptionLabel);
                JTextArea descriptionTextArea = new JTextArea(3, 20);
                descriptionTextArea.setLineWrap(true);
                descriptionLabel.setLabelFor(descriptionTextArea);
                c.insets.top = 2;
                SwingHelper.setConstraints(c, 0, 3, 12, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
                JScrollPane descriptionSrollPane = new JScrollPane(descriptionTextArea);
                layout.setConstraints(descriptionSrollPane, c);
                contentPane.add(descriptionSrollPane);
                JButton cancelButton = SwingHelper.createButton(ProjectList.this.bundle.getString("BTN_CANCEL"), false);
                cancelButton.addActionListener(new ActionListener(this){
                    private final /* synthetic */ AddDialog this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent e) {
                        this.this$1.setVisible(false);
                        this.this$1.dispose();
                    }
                });
                JButton okButton = SwingHelper.createButton(ProjectList.this.bundle.getString("BTN_OK"), false);
                okButton.addActionListener(new ActionListener(this, nameTextField, descriptionTextArea){
                    private final /* synthetic */ JTextField val$nameTextField;
                    private final /* synthetic */ JTextArea val$descriptionTextArea;
                    private final /* synthetic */ AddDialog this$1;
                    {
                        this.this$1 = this$1;
                        this.val$nameTextField = val$nameTextField;
                        this.val$descriptionTextArea = val$descriptionTextArea;
                    }

                    public void actionPerformed(ActionEvent e) {
                        String description;
                        String name = this.val$nameTextField.getText().trim();
                        ProjectListEntry entry = new ProjectListEntry(name, description = this.val$descriptionTextArea.getText().trim(), false);
                        if (AddDialog.access$400((AddDialog)this.this$1).listModel.contains(entry)) {
                            JOptionPane.showMessageDialog(this.this$1, AddDialog.access$400((AddDialog)this.this$1).bundle.getString("MSG_PROJECT_EXISTS"), AddDialog.access$400((AddDialog)this.this$1).bundle.getString("TLE_PROJECT_EXISTS"), 0);
                            return;
                        }
                        if (name.trim().equals(ProjectSettingsPage.access$500())) {
                            Object[] args = new Object[]{name};
                            JOptionPane.showMessageDialog(this.this$1, MessageFormat.format(AddDialog.access$400((AddDialog)this.this$1).bundle.getString("MSG_PROJECT_INVALID_NAME"), args), AddDialog.access$400((AddDialog)this.this$1).bundle.getString("TLE_PROJECT_INVALID_NAME"), 0);
                            return;
                        }
                        if (description.length() > 256) {
                            JOptionPane.showMessageDialog(this.this$1, AddDialog.access$400((AddDialog)this.this$1).bundle.getString("MSG_PROJECT_INVALID_DESC"), AddDialog.access$400((AddDialog)this.this$1).bundle.getString("TLE_PROJECT_INVALID_DESC"), 0);
                            return;
                        }
                        try {
                            Convention.addProject(new Project(name, description));
                            E selValue = AddDialog.access$400(this.this$1).getSelectedValue();
                            AddDialog.access$400((AddDialog)this.this$1).listModel.add(0, entry);
                            AddDialog.access$400(this.this$1).setSelectedValue(selValue, false);
                        }
                        catch (IOException ex) {
                            ErrorDialog dialog = ErrorDialog.create(this.this$1, ex);
                            dialog.setVisible(true);
                            dialog.dispose();
                        }
                        catch (IllegalArgumentException ex) {
                            JOptionPane.showMessageDialog(this.this$1, ex.getMessage(), AddDialog.access$400((AddDialog)this.this$1).bundle.getString("TLE_PROJECT_INVALID_NAME"), 0);
                            return;
                        }
                        this.this$1.dispose();
                    }
                });
                this.getRootPane().setDefaultButton(okButton);
                c.insets.top = 15;
                c.insets.bottom = 5;
                SwingHelper.setConstraints(c, 9, 4, 1, 1, 1.0, 0.0, 13, 0, c.insets, 0, 0);
                layout.setConstraints(okButton, c);
                contentPane.add(okButton);
                c.insets.left = 0;
                SwingHelper.setConstraints(c, 11, 4, 0, 1, 0.0, 0.0, 17, 0, c.insets, 0, 0);
                layout.setConstraints(cancelButton, c);
                contentPane.add(cancelButton);
            }

            static /* synthetic */ ProjectList access$400(AddDialog x0) {
                return x0.ProjectList.this;
            }
        }
    }
}

