/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.LifecycleHandler;
import org.jboss.wsf.spi.invocation.InvocationHandler;

public class DefaultLifecycleHandler
implements LifecycleHandler {
    protected final Logger log = Logger.getLogger(this.getClass());

    public void create(Endpoint endpoint) {
        this.log.debug((Object)("Create: " + endpoint.getName()));
        InvocationHandler invocationHandler = endpoint.getInvocationHandler();
        if (invocationHandler == null) {
            throw new IllegalStateException("Invocation handler not available");
        }
        invocationHandler.init(endpoint);
        endpoint.setState(Endpoint.EndpointState.CREATED);
    }

    public void start(Endpoint endpoint) {
        this.log.debug((Object)("Start: " + endpoint.getName()));
        Endpoint.EndpointState endpointState = endpoint.getState();
        if (endpointState == Endpoint.EndpointState.UNDEFINED || endpointState == Endpoint.EndpointState.DESTROYED) {
            this.log.error((Object)("Cannot start endpoint in state: " + endpointState));
        } else {
            if (endpoint.getEndpointMetrics() != null) {
                endpoint.getEndpointMetrics().start();
            }
            endpoint.setState(Endpoint.EndpointState.STARTED);
        }
    }

    public void stop(Endpoint endpoint) {
        this.log.debug((Object)("Stop: " + endpoint.getName()));
        Endpoint.EndpointState endpointState = endpoint.getState();
        if (endpointState != Endpoint.EndpointState.STARTED) {
            this.log.error((Object)("Cannot stop endpoint in state: " + endpointState));
        } else {
            if (endpoint.getEndpointMetrics() != null) {
                endpoint.getEndpointMetrics().stop();
            }
            endpoint.setState(Endpoint.EndpointState.STOPPED);
        }
    }

    public void destroy(Endpoint endpoint) {
        this.log.debug((Object)("Destroy: " + endpoint.getName()));
        endpoint.setState(Endpoint.EndpointState.DESTROYED);
    }
}

