/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.jms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.bpel.graph.basic.Receive;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.graph.def.BpelVisitorSupport;
import org.jbpm.bpel.graph.struct.Pick;
import org.jbpm.bpel.graph.struct.Sequence;
import org.jbpm.bpel.integration.def.ReceiveAction;
import org.jbpm.bpel.integration.jms.IntegrationControl;
import org.jbpm.bpel.integration.jms.StartListener;

class StartListenersBuilder
extends BpelVisitorSupport {
    private final IntegrationControl integrationControl;
    private final Session jmsSession;
    private List startListeners = new ArrayList();
    private JMSException jmsException;
    private static final Log log = LogFactory.getLog((Class)StartListenersBuilder.class);

    StartListenersBuilder(IntegrationControl integrationControl) throws JMSException {
        this.integrationControl = integrationControl;
        this.jmsSession = integrationControl.getJmsConnection().createSession(false, 2);
    }

    public List getStartListeners() throws JMSException {
        if (this.jmsException != null) {
            throw this.jmsException;
        }
        return this.startListeners;
    }

    public void visit(Receive receive) {
        if (!receive.isCreateInstance() || this.jmsException != null) {
            return;
        }
        try {
            this.createListener(receive.getBpelProcessDefinition(), receive.getReceiveAction());
        }
        catch (JMSException e) {
            this.jmsException = e;
        }
    }

    public void visit(Pick pick) {
        if (!pick.isCreateInstance() || this.jmsException != null) {
            return;
        }
        try {
            BpelProcessDefinition processDefinition = pick.getBpelProcessDefinition();
            Iterator onMessageIt = pick.getOnMessages().iterator();
            while (onMessageIt.hasNext()) {
                this.createListener(processDefinition, (ReceiveAction)onMessageIt.next());
            }
        }
        catch (JMSException e) {
            this.jmsException = e;
        }
    }

    public void visit(Sequence sequence) {
        ((Activity)((Object)sequence.getNodes().get(0))).accept(this);
    }

    private void createListener(BpelProcessDefinition processDefinition, ReceiveAction receiveAction) throws JMSException {
        MessageConsumer consumer = this.createConsumer(receiveAction);
        JbpmConfiguration jbpmConfiguration = this.integrationControl.getIntegrationServiceFactory().getJbpmConfiguration();
        StartListener listener = new StartListener(processDefinition.getId(), receiveAction.getId(), consumer, jbpmConfiguration);
        this.startListeners.add(listener);
        log.debug((Object)("created start listener: process=" + (Object)((Object)processDefinition) + ", receiver=" + receiveAction));
    }

    private MessageConsumer createConsumer(ReceiveAction receiveAction) throws JMSException {
        Destination destination = this.integrationControl.getPartnerLinkEntry(receiveAction.getPartnerLink()).getDestination();
        String selector = "jbpm_bpel_partnerLinkId=" + receiveAction.getPartnerLink().getId() + " AND " + "jbpm_bpel_operationName" + "='" + receiveAction.getOperation().getName() + '\'';
        return this.jmsSession.createConsumer(destination, selector);
    }
}

