/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.engine;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.Session;
import cirrus.hibernate.collections.PersistentCollection;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.impl.CollectionPersister;
import cirrus.hibernate.persister.ClassPersister;
import cirrus.hibernate.proxy.HibernateProxy;
import cirrus.hibernate.proxy.HibernateProxyHelper;
import cirrus.hibernate.type.AbstractComponentType;
import cirrus.hibernate.type.AssociationType;
import cirrus.hibernate.type.PersistentCollectionType;
import cirrus.hibernate.type.Type;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Cascades {
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$engine$Cascades == null ? (class$cirrus$hibernate$engine$Cascades = Cascades.class$("cirrus.hibernate.engine.Cascades")) : class$cirrus$hibernate$engine$Cascades));
    public static final CascadingAction ACTION_DELETE = new CascadingAction(){

        void cascade(Session session, Object child) throws SQLException, HibernateException {
            log.trace((Object)"cacading to delete()");
            session.delete(child);
        }

        boolean shouldCascadeCollection(Object collection) {
            return true;
        }
    };
    public static final CascadingAction ACTION_SAVE_UPDATE = new CascadingAction(){

        void cascade(Session session, Object child) throws SQLException, HibernateException {
            if (!(child instanceof HibernateProxy) || !HibernateProxyHelper.getLazyInitializer((HibernateProxy)child).isUninitialized()) {
                log.trace((Object)"cacading to saveOrUpdate()");
                session.saveOrUpdate(child);
            }
        }

        boolean shouldCascadeCollection(Object collection) {
            return !(collection instanceof PersistentCollection) || ((PersistentCollection)collection).wasInitialized();
        }
    };
    public static final int CASCADE_AFTER_INSERT_BEFORE_DELETE = 1;
    public static final int CASCADE_BEFORE_INSERT_AFTER_DELETE = 2;
    public static final int CASCADE_AFTER_INSERT_BEFORE_DELETE_VIA_COLLECTION = 3;
    public static final int CASCADE_ON_UPDATE = 0;
    public static final CascadeStyle STYLE_ALL = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return true;
        }
    };
    public static final CascadeStyle STYLE_EXCEPT_DELETE = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return action != ACTION_DELETE;
        }
    };
    public static final CascadeStyle STYLE_ONLY_DELETE = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return action == ACTION_DELETE;
        }
    };
    public static final CascadeStyle STYLE_NONE = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return false;
        }
    };
    public static final IdentifierValue SAVE_ANY = new IdentifierValue(){

        public final boolean isUnsaved(Serializable id) {
            return true;
        }
    };
    public static final IdentifierValue SAVE_NONE = new IdentifierValue(){

        public final boolean isUnsaved(Serializable id) {
            return false;
        }
    };
    public static final IdentifierValue SAVE_NULL = new IdentifierValue(){

        public final boolean isUnsaved(Serializable id) {
            return id == null;
        }
    };
    static /* synthetic */ Class class$cirrus$hibernate$engine$Cascades;

    private static void cascade(SessionImplementor session, Object child, Type type, CascadingAction action, int cascadeTo) throws SQLException, HibernateException {
        block8: {
            block9: {
                Iterator iter;
                block10: {
                    if (child == null) break block8;
                    if (!type.isAssociationType()) break block9;
                    if (!((AssociationType)((Object)type)).getForeignKeyType().cascadeNow(cascadeTo)) break block8;
                    if (!type.isEntityType()) break block10;
                    action.cascade(session, child);
                    break block8;
                }
                if (!type.isPersistentCollectionType()) break block8;
                int cascadeVia = cascadeTo == 1 ? 3 : cascadeTo;
                PersistentCollectionType pctype = (PersistentCollectionType)type;
                CollectionPersister persister = session.getFactory().getCollectionPersister(pctype.getRole());
                Type elemType = persister.getElementType();
                if (action.shouldCascadeCollection(child)) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("cascading to collection: " + pctype.getRole()));
                    }
                    iter = pctype.getElementsIterator(child);
                } else {
                    PersistentCollection pc;
                    iter = child instanceof PersistentCollection ? ((pc = (PersistentCollection)child).hasQueuedAdds() ? pc.queuedAddsIterator() : null) : null;
                }
                if (iter != null) {
                    while (iter.hasNext()) {
                        Cascades.cascade(session, iter.next(), elemType, action, cascadeVia);
                    }
                }
                break block8;
            }
            if (type.isComponentType()) {
                AbstractComponentType ctype = (AbstractComponentType)type;
                Object[] children = ctype.getPropertyValues(child);
                Type[] types = ctype.getSubtypes();
                int i = 0;
                while (i < types.length) {
                    if (ctype.cascade(i).doCascade(action)) {
                        Cascades.cascade(session, children[i], types[i], action, cascadeTo);
                    }
                    ++i;
                }
            }
        }
    }

    public static void cascade(SessionImplementor session, ClassPersister persister, Object parent, CascadingAction action, int cascadeTo) throws SQLException, HibernateException {
        if (persister.hasCascades()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("processing cascades for: " + persister.getClassName()));
            }
            Type[] types = persister.getPropertyTypes();
            CascadeStyle[] cascadeStyles = persister.getPropertyCascadeStyles();
            int i = 0;
            while (i < types.length) {
                if (cascadeStyles[i].doCascade(action)) {
                    Cascades.cascade(session, persister.getPropertyValue(parent, i), types[i], action, cascadeTo);
                }
                ++i;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("done processing cascades for: " + persister.getClassName()));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class IdentifierValue {
        private final Object value;

        protected IdentifierValue() {
            this.value = null;
        }

        public IdentifierValue(Object value) {
            this.value = value;
        }

        public boolean isUnsaved(Serializable id) {
            return id == null || this.value.equals(id);
        }
    }

    public static abstract class CascadeStyle {
        protected CascadeStyle() {
        }

        abstract boolean doCascade(CascadingAction var1);
    }

    public static abstract class CascadingAction {
        protected CascadingAction() {
        }

        abstract void cascade(Session var1, Object var2) throws SQLException, HibernateException;

        abstract boolean shouldCascadeCollection(Object var1);
    }
}

