/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.loader;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.engine.SessionFactoryImplementor;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.impl.CollectionPersister;
import cirrus.hibernate.loader.Loader;
import cirrus.hibernate.loader.OuterJoinLoader;
import cirrus.hibernate.loader.UniqueEntityLoader;
import cirrus.hibernate.persister.ClassPersister;
import cirrus.hibernate.persister.Loadable;
import cirrus.hibernate.type.Type;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;

public class EntityLoader
extends OuterJoinLoader
implements UniqueEntityLoader {
    private final Type[] idType;
    private final ClassPersister persister;

    public EntityLoader(Loadable persister, SessionFactoryImplementor factory) throws MappingException {
        super(factory.getDialect());
        this.idType = new Type[]{persister.getIdentifierType()};
        this.persister = persister;
        String alias = OuterJoinLoader.alias(persister.getClassName(), 0);
        List associations = this.walkTree(persister, alias, factory);
        int joins = associations.size();
        this.suffixes = new String[joins + 1];
        int i = 0;
        while (i <= joins) {
            this.suffixes[i] = joins == 0 ? "" : Integer.toString(i);
            ++i;
        }
        this.sql = Loader.sqlSelect((joins == 0 ? "" : this.selectString(associations) + ", ") + OuterJoinLoader.selectString(persister, alias, this.suffixes[joins]), persister.fromClauseFragment(alias, true), this.outerJoinGenerator.outerJoinStringAfterFrom(associations), OuterJoinLoader.whereString(persister.getIdentifierColumnNames(), alias), this.outerJoinGenerator.outerJoinStringAfterWhere(associations) + persister.outerJoinsAfterWhere(alias, true));
        this.classPersisters = new Loadable[joins + 1];
        int i2 = 0;
        while (i2 < joins) {
            this.classPersisters[i2] = ((OuterJoinLoader.OuterJoinableAssociation)associations.get((int)i2)).subpersister;
            ++i2;
        }
        this.classPersisters[joins] = persister;
    }

    protected CollectionPersister getCollectionPersister() {
        return null;
    }

    public Object load(SessionImplementor session, Serializable id, Object object) throws HibernateException, SQLException {
        List list = this.loadEntity(session, new Object[]{id}, this.idType, object, id, false);
        if (list.size() == 1) {
            int len = this.classPersisters.length;
            return len == 1 ? list.get(0) : ((Object[])list.get(0))[len - 1];
        }
        if (list.size() == 0) {
            return null;
        }
        throw new HibernateException("More than one row with the given identifier was found: " + id + ", for class: " + this.persister.getClassName());
    }
}

