/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.map;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.cache.CacheConcurrencyStrategy;
import cirrus.hibernate.cache.CacheException;
import cirrus.hibernate.cache.JCSCache;
import cirrus.hibernate.cache.ReadOnlyCache;
import cirrus.hibernate.cache.ReadWriteCache;
import cirrus.hibernate.helpers.ReflectHelper;
import cirrus.hibernate.id.IdentifierGenerator;
import cirrus.hibernate.id.PersistentIdentifierGenerator;
import cirrus.hibernate.map.Array;
import cirrus.hibernate.map.Bag;
import cirrus.hibernate.map.Collection;
import cirrus.hibernate.map.List;
import cirrus.hibernate.map.Map;
import cirrus.hibernate.map.PersistentClass;
import cirrus.hibernate.map.PrimitiveArray;
import cirrus.hibernate.map.RootClass;
import cirrus.hibernate.map.Set;
import cirrus.hibernate.map.Table;
import cirrus.hibernate.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Root {
    static final String ROOT_ROLE_NAME = "";
    static final char ROLE_SEPERATOR = '/';
    Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$map$Root == null ? (class$cirrus$hibernate$map$Root = Root.class$("cirrus.hibernate.map.Root")) : class$cirrus$hibernate$map$Root));
    private final java.util.Map classes;
    private final java.util.Map collections;
    private final java.util.Map tables;
    private final java.util.Map queries;
    private final java.util.Map generators;
    private final String schemaName;
    private final String defaultCascade;
    private static final String[] NO_STRINGS = new String[0];
    private static final Type[] NO_TYPES = new Type[0];
    private static final Integer[] NO_INTEGERS = new Integer[0];
    private static final HashMap idgenerators = new HashMap();
    static /* synthetic */ Class class$cirrus$hibernate$map$Root;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$cirrus$hibernate$id$PersistentIdentifierGenerator;
    static /* synthetic */ Class class$cirrus$hibernate$id$UUIDHexGenerator;
    static /* synthetic */ Class class$cirrus$hibernate$id$UUIDStringGenerator;
    static /* synthetic */ Class class$cirrus$hibernate$id$HiLoGenerator;
    static /* synthetic */ Class class$cirrus$hibernate$id$HiLoHexGenerator;
    static /* synthetic */ Class class$cirrus$hibernate$id$LongGenerator;
    static /* synthetic */ Class class$cirrus$hibernate$id$HexGenerator;
    static /* synthetic */ Class class$cirrus$hibernate$id$Assigned;
    static /* synthetic */ Class class$cirrus$hibernate$id$NativeGenerator;
    static /* synthetic */ Class class$cirrus$hibernate$id$SequenceGenerator;
    static /* synthetic */ Class class$cirrus$hibernate$id$SequenceHiLoGenerator;

    public Root(Document doc, java.util.Map classes, java.util.Map collections, java.util.Map tables, java.util.Map generators, java.util.Map queries) throws Exception {
        this.classes = classes;
        this.collections = collections;
        this.queries = queries;
        this.tables = tables;
        this.generators = generators;
        Node hmNode = doc.getElementsByTagName("hibernate-mapping").item(0);
        Node schemaNode = hmNode.getAttributes().getNamedItem("schema");
        this.schemaName = schemaNode == null ? null : schemaNode.getNodeValue();
        Node dcNode = hmNode.getAttributes().getNamedItem("default-cascade");
        this.defaultCascade = dcNode == null ? "none" : dcNode.getNodeValue();
        NodeList nodes = hmNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node n = nodes.item(i);
            String name = n.getNodeName();
            CollectionType collectType = CollectionType.collectionTypeFromString(name);
            if (collectType != null) {
                Collection collection = collectType.create(n, ROOT_ROLE_NAME, null, this);
                this.addCollection(collection);
            } else if (name.equals("class")) {
                RootClass rootclass = new RootClass(n, this);
                this.log.debug((Object)("Root class: " + rootclass.getName() + " -> " + rootclass.getTable().getName()));
                this.addPersistentClass(rootclass);
            } else if (name.equals("query")) {
                String qname = n.getAttributes().getNamedItem("name").getNodeValue();
                String query = n.getFirstChild().getNodeValue();
                this.log.debug((Object)("Named query: " + qname + " -> " + query));
                String old = queries.put(qname, query);
                if (old != null) {
                    throw new MappingException("duplicate query name: " + qname);
                }
            }
            ++i;
        }
    }

    public Type getCollectionType(String role) throws MappingException {
        Collection coll = (Collection)this.collections.get(role);
        if (coll == null) {
            throw new MappingException("undeclared collection role: " + role);
        }
        return coll.getType();
    }

    public void addPersistentClass(PersistentClass persistentClass) throws MappingException {
        PersistentClass old = this.classes.put(persistentClass.getPersistentClass(), persistentClass);
        if (old != null) {
            throw new MappingException("duplicate class mapping: " + persistentClass.getPersistentClass().getName());
        }
    }

    public void addCollection(Collection collection) throws MappingException {
        Collection old = this.collections.put(collection.getRole(), collection);
        if (old != null) {
            throw new MappingException("duplicate collection role: " + collection.getRole());
        }
    }

    public Table addTable(String schema, String name) {
        String key = schema != null ? schema + "." + name : name;
        Table table = (Table)this.tables.get(key);
        if (table == null) {
            table = new Table();
            table.setName(name);
            table.setSchema(schema);
            this.tables.put(key, table);
        }
        return table;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getDefaultCascade() {
        return this.defaultCascade;
    }

    public IdentifierGenerator createIDGenerator(Node node) throws Exception {
        String className = node.getAttributes().getNamedItem("class").getNodeValue();
        Class idgenClass = (Class)idgenerators.get(className);
        if (idgenClass == null) {
            try {
                idgenClass = ReflectHelper.classForName(className);
            }
            catch (Exception e) {
                throw new HibernateException("ID generator class not found: " + className);
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        NodeList nodes = node.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node childNode = nodes.item(i);
            if (childNode.getNodeName().equals("param")) {
                list.add(childNode.getFirstChild().getNodeValue());
            }
            ++i;
        }
        int size = list.size();
        Object[] argTypes = new Class[size];
        Object[] args = new String[size];
        Arrays.fill(argTypes, class$java$lang$String == null ? (class$java$lang$String = Root.class$("java.lang.String")) : class$java$lang$String);
        list.toArray(args);
        Object gen = null;
        try {
            gen = idgenClass.getConstructor((Class<?>[])argTypes).newInstance(args);
        }
        catch (NoSuchMethodException e) {
            throw new MappingException("Exception while trying to instantiate " + idgenClass.getName() + " with " + list, e);
        }
        IdentifierGenerator idgen = gen;
        if ((class$cirrus$hibernate$id$PersistentIdentifierGenerator == null ? (class$cirrus$hibernate$id$PersistentIdentifierGenerator = Root.class$("cirrus.hibernate.id.PersistentIdentifierGenerator")) : class$cirrus$hibernate$id$PersistentIdentifierGenerator).isAssignableFrom(idgenClass)) {
            this.generators.put(((PersistentIdentifierGenerator)idgen).generatorKey(), idgen);
        }
        return idgen;
    }

    public CacheConcurrencyStrategy createJCSCache(Node node, String name, PersistentClass owner) throws MappingException {
        JCSCache jcs;
        String usage = node.getAttributes().getNamedItem("usage").getNodeValue();
        try {
            jcs = new JCSCache();
        }
        catch (NoClassDefFoundError ncf) {
            this.log.warn((Object)"Could not instantiate cache - probably the JCS jar is missing", (Throwable)ncf);
            return null;
        }
        try {
            jcs.setClass(name);
        }
        catch (CacheException ce) {
            throw new MappingException("Could not instantiate JCS", (Throwable)((Object)ce));
        }
        if (usage.equals("read-only")) {
            if (owner.isMutable()) {
                this.log.warn((Object)("read-only cache configured for mutable: " + name));
            }
            return new ReadOnlyCache(jcs);
        }
        if (usage.equals("read-write")) {
            return new ReadWriteCache(jcs);
        }
        throw new MappingException("jcs-cache usage attribute should be read-write or read-only");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        idgenerators.put("uuid.hex", class$cirrus$hibernate$id$UUIDHexGenerator == null ? (class$cirrus$hibernate$id$UUIDHexGenerator = Root.class$("cirrus.hibernate.id.UUIDHexGenerator")) : class$cirrus$hibernate$id$UUIDHexGenerator);
        idgenerators.put("uuid.string", class$cirrus$hibernate$id$UUIDStringGenerator == null ? (class$cirrus$hibernate$id$UUIDStringGenerator = Root.class$("cirrus.hibernate.id.UUIDStringGenerator")) : class$cirrus$hibernate$id$UUIDStringGenerator);
        idgenerators.put("hilo.long", class$cirrus$hibernate$id$HiLoGenerator == null ? (class$cirrus$hibernate$id$HiLoGenerator = Root.class$("cirrus.hibernate.id.HiLoGenerator")) : class$cirrus$hibernate$id$HiLoGenerator);
        idgenerators.put("hilo.hex", class$cirrus$hibernate$id$HiLoHexGenerator == null ? (class$cirrus$hibernate$id$HiLoHexGenerator = Root.class$("cirrus.hibernate.id.HiLoHexGenerator")) : class$cirrus$hibernate$id$HiLoHexGenerator);
        idgenerators.put("vm.long", class$cirrus$hibernate$id$LongGenerator == null ? (class$cirrus$hibernate$id$LongGenerator = Root.class$("cirrus.hibernate.id.LongGenerator")) : class$cirrus$hibernate$id$LongGenerator);
        idgenerators.put("vm.hex", class$cirrus$hibernate$id$HexGenerator == null ? (class$cirrus$hibernate$id$HexGenerator = Root.class$("cirrus.hibernate.id.HexGenerator")) : class$cirrus$hibernate$id$HexGenerator);
        idgenerators.put("assigned", class$cirrus$hibernate$id$Assigned == null ? (class$cirrus$hibernate$id$Assigned = Root.class$("cirrus.hibernate.id.Assigned")) : class$cirrus$hibernate$id$Assigned);
        idgenerators.put("native", class$cirrus$hibernate$id$NativeGenerator == null ? (class$cirrus$hibernate$id$NativeGenerator = Root.class$("cirrus.hibernate.id.NativeGenerator")) : class$cirrus$hibernate$id$NativeGenerator);
        idgenerators.put("sequence", class$cirrus$hibernate$id$SequenceGenerator == null ? (class$cirrus$hibernate$id$SequenceGenerator = Root.class$("cirrus.hibernate.id.SequenceGenerator")) : class$cirrus$hibernate$id$SequenceGenerator);
        idgenerators.put("seqhilo.long", class$cirrus$hibernate$id$SequenceHiLoGenerator == null ? (class$cirrus$hibernate$id$SequenceHiLoGenerator = Root.class$("cirrus.hibernate.id.SequenceHiLoGenerator")) : class$cirrus$hibernate$id$SequenceHiLoGenerator);
    }

    public static abstract class CollectionType {
        private String xmlTag;
        private static final CollectionType MAP = new CollectionType("map"){

            public Collection create(Node node, String prefix, PersistentClass owner, Root root) throws MappingException {
                return new Map(node, prefix, owner, root);
            }
        };
        private static final CollectionType SET = new CollectionType("set"){

            public Collection create(Node node, String prefix, PersistentClass owner, Root root) throws MappingException {
                return new Set(node, prefix, owner, root);
            }
        };
        private static final CollectionType LIST = new CollectionType("list"){

            public Collection create(Node node, String prefix, PersistentClass owner, Root root) throws MappingException {
                return new List(node, prefix, owner, root);
            }
        };
        private static final CollectionType BAG = new CollectionType("bag"){

            public Collection create(Node node, String prefix, PersistentClass owner, Root root) throws MappingException {
                return new Bag(node, prefix, owner, root);
            }
        };
        private static final CollectionType ARRAY = new CollectionType("array"){

            public Collection create(Node node, String prefix, PersistentClass owner, Root root) throws MappingException {
                return new Array(node, prefix, owner, root);
            }
        };
        private static final CollectionType PRIMITIVE_ARRAY = new CollectionType("primitive-array"){

            public Collection create(Node node, String prefix, PersistentClass owner, Root root) throws MappingException {
                return new PrimitiveArray(node, prefix, owner, root);
            }
        };
        private static final HashMap INSTANCES = new HashMap();

        public abstract Collection create(Node var1, String var2, PersistentClass var3, Root var4) throws MappingException;

        CollectionType(String xmlTag) {
            this.xmlTag = xmlTag;
        }

        public String toString() {
            return this.xmlTag;
        }

        public static CollectionType collectionTypeFromString(String xmlTagName) {
            return (CollectionType)INSTANCES.get(xmlTagName);
        }

        static {
            INSTANCES.put(MAP.toString(), MAP);
            INSTANCES.put(BAG.toString(), BAG);
            INSTANCES.put(SET.toString(), SET);
            INSTANCES.put(LIST.toString(), LIST);
            INSTANCES.put(ARRAY.toString(), ARRAY);
            INSTANCES.put(PRIMITIVE_ARRAY.toString(), PRIMITIVE_ARRAY);
        }
    }
}

