/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.util.event.servlet;

import com.icesoft.faces.util.event.servlet.ContextDestroyedEvent;
import com.icesoft.faces.util.event.servlet.ContextEvent;
import com.icesoft.faces.util.event.servlet.ContextEventListener;
import com.icesoft.faces.util.event.servlet.ContextEventPublisher;
import com.icesoft.faces.util.event.servlet.ContextInitializedEvent;
import com.icesoft.faces.util.event.servlet.ICEfacesIDDisposedEvent;
import com.icesoft.faces.util.event.servlet.ICEfacesIDRetrievedEvent;
import com.icesoft.faces.util.event.servlet.SessionDestroyedEvent;
import com.icesoft.faces.util.event.servlet.ViewNumberRetrievedEvent;
import com.icesoft.faces.webapp.http.servlet.ServletContextConfiguration;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContextEventRepeater
implements HttpSessionListener,
ServletContextListener {
    private static final String MESSAGING_CONTEXT_EVENT_PUBLISHER_CLASS_NAME = "com.icesoft.faces.util.event.servlet.MessagingContextEventPublisher";
    private static final Log LOG = LogFactory.getLog((Class)ContextEventRepeater.class);
    private static SessionDispatcher.Listener SessionDispatcherListener = new SessionDispatcher.Listener();
    private static Map bufferedContextEvents = new HashMap();
    private static ContextEventPublisher contextEventPublisher;
    private static Map listeners;

    public static synchronized void addListener(ContextEventListener contextEventListener) {
        if (contextEventListener == null || listeners.containsKey(contextEventListener)) {
            return;
        }
        listeners.put(contextEventListener, null);
        if (contextEventListener.receiveBufferedEvents()) {
            ContextEventRepeater.sendBufferedEvents(contextEventListener);
        }
    }

    public synchronized void contextDestroyed(ServletContextEvent event) {
        ContextDestroyedEvent contextDestroyedEvent;
        block5: {
            SessionDispatcherListener.contextDestroyed(event);
            contextDestroyedEvent = new ContextDestroyedEvent(event);
            Iterator it = listeners.keySet().iterator();
            while (it.hasNext()) {
                ((ContextEventListener)it.next()).contextDestroyed(contextDestroyedEvent);
            }
            listeners.clear();
            bufferedContextEvents.clear();
            if (contextEventPublisher != null) {
                try {
                    contextEventPublisher.publish(contextDestroyedEvent);
                }
                catch (Exception exception) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug((Object)"Couldn't publish event!", (Throwable)exception);
                }
            }
        }
        if (LOG.isInfoEnabled()) {
            ServletContext servletContext = contextDestroyedEvent.getServletContext();
            LOG.info((Object)("Servlet Context Name: " + servletContext.getServletContextName() + ", " + "Server Info: " + servletContext.getServerInfo()));
        }
    }

    public synchronized void contextInitialized(ServletContextEvent event) {
        block11: {
            SessionDispatcherListener.contextInitialized(event);
            ServletContextConfiguration _configuration = new ServletContextConfiguration("com.icesoft.faces", event.getServletContext());
            boolean isAsyncHttpServiceAvailable = this.isAsyncHttpServiceAvailable();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Asynchronous HTTP Service available: " + isAsyncHttpServiceAvailable));
            }
            if (isAsyncHttpServiceAvailable && _configuration.getAttribute("blockingRequestHandler", _configuration.getAttributeAsBoolean("async.server", true) ? "icefaces-ahs" : "icefaces").equalsIgnoreCase("icefaces-ahs")) {
                try {
                    contextEventPublisher = (ContextEventPublisher)Class.forName(MESSAGING_CONTEXT_EVENT_PUBLISHER_CLASS_NAME).newInstance();
                    contextEventPublisher.setContextEventRepeater(this);
                    try {
                        contextEventPublisher.publish(new ContextInitializedEvent(event));
                    }
                    catch (Exception exception) {
                        contextEventPublisher = null;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Couldn't publish event!", (Throwable)exception);
                        }
                    }
                }
                catch (ClassNotFoundException exception) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"MessagingContextEventPublisher is not found!");
                    }
                }
                catch (IllegalAccessException exception) {
                    if (LOG.isFatalEnabled()) {
                        LOG.fatal((Object)"Failed to access constructor of MessagingContextEventPublisher!", (Throwable)exception);
                    }
                }
                catch (InstantiationException exception) {
                    if (!LOG.isFatalEnabled()) break block11;
                    LOG.fatal((Object)"Failed to instantiate MessagingContextEventPublisher!", (Throwable)exception);
                }
            }
        }
    }

    public static synchronized void iceFacesIdDisposed(HttpSession source, String iceFacesId) {
        ICEfacesIDDisposedEvent iceFacesIdDisposedEvent;
        block5: {
            iceFacesIdDisposedEvent = new ICEfacesIDDisposedEvent(source, iceFacesId);
            bufferedContextEvents.put(iceFacesIdDisposedEvent, source);
            Iterator _listeners = listeners.keySet().iterator();
            while (_listeners.hasNext()) {
                ((ContextEventListener)_listeners.next()).iceFacesIdDisposed(iceFacesIdDisposedEvent);
            }
            if (contextEventPublisher != null) {
                try {
                    contextEventPublisher.publish(iceFacesIdDisposedEvent);
                }
                catch (Exception exception) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug((Object)"Couldn't publish event!", (Throwable)exception);
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ICEfaces ID disposed: " + iceFacesIdDisposedEvent.getICEfacesID()));
        }
    }

    public static synchronized void iceFacesIdRetrieved(HttpSession source, String iceFacesId) {
        ICEfacesIDRetrievedEvent iceFacesIdRetrievedEvent;
        block5: {
            iceFacesIdRetrievedEvent = new ICEfacesIDRetrievedEvent(source, iceFacesId);
            bufferedContextEvents.put(iceFacesIdRetrievedEvent, source);
            Iterator _listeners = listeners.keySet().iterator();
            while (_listeners.hasNext()) {
                ((ContextEventListener)_listeners.next()).iceFacesIdRetrieved(iceFacesIdRetrievedEvent);
            }
            if (contextEventPublisher != null) {
                try {
                    contextEventPublisher.publish(iceFacesIdRetrievedEvent);
                }
                catch (Exception exception) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug((Object)"Couldn't publish event!", (Throwable)exception);
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ICEfaces ID retrieved: " + iceFacesIdRetrievedEvent.getICEfacesID()));
        }
    }

    public static synchronized void removeListener(ContextEventListener contextEventListener) {
        if (contextEventListener == null) {
            return;
        }
        listeners.remove(contextEventListener);
    }

    public synchronized void sessionCreated(HttpSessionEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("session Created event: " + event.getSession().getId()));
        }
    }

    public synchronized void sessionDestroyed(HttpSessionEvent event) {
        SessionDestroyedEvent sessionDestroyedEvent;
        block6: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("SessionDestroyed event, session: " + event.getSession().getId()));
            }
            SessionDispatcherListener.sessionDestroyed(event);
            sessionDestroyedEvent = new SessionDestroyedEvent(event);
            Iterator _listeners = listeners.keySet().iterator();
            while (_listeners.hasNext()) {
                ((ContextEventListener)_listeners.next()).sessionDestroyed(sessionDestroyedEvent);
            }
            ContextEventRepeater.removeBufferedEvents(event.getSession());
            if (contextEventPublisher != null) {
                try {
                    contextEventPublisher.publish(sessionDestroyedEvent);
                }
                catch (Exception exception) {
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug((Object)"Couldn't publish event!", (Throwable)exception);
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ICEfaces ID: " + sessionDestroyedEvent.getICEfacesID()));
        }
    }

    public static synchronized void viewNumberRetrieved(HttpSession source, String icefacesID, int viewNumber) {
        ViewNumberRetrievedEvent viewNumberRetrievedEvent;
        block5: {
            viewNumberRetrievedEvent = new ViewNumberRetrievedEvent(source, icefacesID, viewNumber);
            bufferedContextEvents.put(viewNumberRetrievedEvent, source);
            Iterator _listeners = listeners.keySet().iterator();
            while (_listeners.hasNext()) {
                ((ContextEventListener)_listeners.next()).viewNumberRetrieved(viewNumberRetrievedEvent);
            }
            if (contextEventPublisher != null) {
                try {
                    contextEventPublisher.publish(viewNumberRetrievedEvent);
                }
                catch (Exception exception) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug((Object)"Couldn't publish event!", (Throwable)exception);
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("New View number created: " + viewNumberRetrievedEvent.getViewNumber()));
        }
    }

    ContextEvent[] getBufferedContextEvents() {
        Set _contextEventSet = bufferedContextEvents.keySet();
        return _contextEventSet.toArray(new ContextEvent[_contextEventSet.size()]);
    }

    private boolean isAsyncHttpServiceAvailable() {
        try {
            this.getClass().getClassLoader().loadClass("com.icesoft.faces.async.server.AsyncHttpServerAdaptingServlet");
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    private static synchronized void removeBufferedEvents(HttpSession session) {
        Iterator it = bufferedContextEvents.keySet().iterator();
        Object event = null;
        HttpSession bufferedSession = null;
        while (it.hasNext()) {
            event = it.next();
            bufferedSession = (HttpSession)bufferedContextEvents.get(event);
            if (!bufferedSession.equals(session)) continue;
            it.remove();
        }
    }

    private static synchronized void sendBufferedEvents(ContextEventListener contextEventListener) {
        Iterator it = bufferedContextEvents.keySet().iterator();
        while (it.hasNext()) {
            Object event = it.next();
            if (event instanceof ICEfacesIDRetrievedEvent) {
                contextEventListener.iceFacesIdRetrieved((ICEfacesIDRetrievedEvent)event);
                continue;
            }
            if (!(event instanceof ViewNumberRetrievedEvent)) continue;
            contextEventListener.viewNumberRetrieved((ViewNumberRetrievedEvent)event);
        }
    }

    static {
        listeners = new WeakHashMap();
    }
}

