/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.endpointref;

import com.ibm.wsdl.extensions.soap.SOAPConstants;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.bpel.endpointref.EndpointReference;
import org.jbpm.bpel.integration.catalog.ServiceCatalog;
import org.jbpm.bpel.wsdl.xml.WsdlUtil;

public abstract class SoapEndpointReference
extends EndpointReference {
    private String address;
    private QName serviceName;
    private String portName;
    private static final Log log = LogFactory.getLog((Class)SoapEndpointReference.class);

    protected SoapEndpointReference() {
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getPortName() {
        return this.portName;
    }

    public String toString() {
        QName portTypeName;
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("address", (Object)this.address);
        String scheme = this.getScheme();
        if (scheme != null) {
            builder.append("scheme", (Object)scheme);
        }
        if ((portTypeName = this.getPortTypeName()) != null) {
            builder.append("portType", (Object)portTypeName);
        }
        if (this.serviceName != null) {
            builder.append("service", (Object)this.serviceName);
            if (this.portName != null) {
                builder.append("port", (Object)this.portName);
            }
        }
        return builder.toString();
    }

    public Port selectPort(ServiceCatalog catalog) {
        Port port;
        if (this.serviceName == null) {
            List services = catalog.lookupServices(this.getPortTypeName());
            port = this.selectPort(services);
        } else {
            Service service = catalog.lookupService(this.serviceName);
            port = this.selectPort(service);
        }
        return port;
    }

    protected Port selectPort(List services) {
        QName portTypeName = this.getPortTypeName();
        Port selectedPort = null;
        Iterator serviceIt = services.iterator();
        block0: while (serviceIt.hasNext()) {
            Service service = (Service)serviceIt.next();
            Iterator portIt = service.getPorts().values().iterator();
            while (portIt.hasNext()) {
                Port port = (Port)portIt.next();
                Binding binding = port.getBinding();
                if (!binding.getPortType().getQName().equals(portTypeName) || !SoapEndpointReference.isSoapBinding(binding)) continue;
                String portAddress = SoapEndpointReference.getSoapAddress(port);
                log.debug((Object)("found candidate port: name=" + port.getName() + ", address=" + portAddress + ", service=" + service.getQName() + ", portType=" + portTypeName));
                if (this.address != null && this.address.equals(portAddress)) {
                    selectedPort = port;
                    break block0;
                }
                if (selectedPort != null) continue;
                selectedPort = port;
            }
        }
        if (selectedPort == null) {
            throw new RuntimeException("no port implements the required port type: portType=" + portTypeName);
        }
        return selectedPort;
    }

    protected Port selectPort(Service service) {
        Port port;
        if (service == null) {
            throw new RuntimeException("service not found: service=" + this.serviceName);
        }
        QName portTypeName = this.getPortTypeName();
        if (this.portName != null) {
            port = service.getPort(this.portName);
            if (port == null) {
                throw new RuntimeException("port not found: service=" + this.serviceName + ", port=" + this.portName);
            }
            Binding binding = port.getBinding();
            if (!portTypeName.equals(binding.getPortType().getQName())) {
                throw new RuntimeException("port does not implement the required port type: service=" + this.serviceName + ", port=" + this.portName + ", portType=" + portTypeName);
            }
            if (!SoapEndpointReference.isSoapBinding(binding)) {
                throw new RuntimeException("non-soap ports not supported: service=" + this.serviceName + ", port=" + this.portName + ", portType=" + portTypeName);
            }
        } else {
            port = null;
            Iterator portIt = service.getPorts().values().iterator();
            while (portIt.hasNext()) {
                Port aPort = (Port)portIt.next();
                Binding binding = aPort.getBinding();
                if (!binding.getPortType().getQName().equals(portTypeName) || !SoapEndpointReference.isSoapBinding(binding)) continue;
                if (this.address != null && this.address.equals(SoapEndpointReference.getSoapAddress(aPort))) {
                    port = aPort;
                    break;
                }
                if (port != null) continue;
                port = aPort;
            }
            if (port == null) {
                throw new RuntimeException("no port implements the required port type and is bound to soap: service=" + this.serviceName + ", portType=" + portTypeName);
            }
        }
        return port;
    }

    protected static boolean isSoapBinding(Binding binding) {
        return WsdlUtil.getExtension(binding.getExtensibilityElements(), SOAPConstants.Q_ELEM_SOAP_BINDING) != null;
    }

    protected static String getSoapAddress(Port port) {
        SOAPAddress soapAddress = (SOAPAddress)WsdlUtil.getExtension(port.getExtensibilityElements(), SOAPConstants.Q_ELEM_SOAP_ADDRESS);
        return soapAddress != null ? soapAddress.getLocationURI() : null;
    }
}

