/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.metadata.AddMethodMetaData;
import org.jboss.xb.binding.metadata.CharactersMetaData;
import org.jboss.xb.binding.metadata.ClassMetaData;
import org.jboss.xb.binding.metadata.MapEntryMetaData;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.sunday.unmarshalling.AllBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeHandler;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementInterceptor;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.RtCharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.RtElementHandler;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class TypeBinding {
    private final QName qName;
    private ElementBinding arrayItem;
    private Map attrs = Collections.EMPTY_MAP;
    private ElementHandler handler = RtElementHandler.INSTANCE;
    private CharactersHandler simpleType;
    private ClassMetaData classMetaData;
    private ValueMetaData valueMetaData;
    private PropertyMetaData propertyMetaData;
    private MapEntryMetaData mapEntryMetaData;
    private SchemaBinding schemaBinding;
    private TypeBinding baseType;
    private boolean skip;
    private CharactersMetaData charMetaData;
    private PropertyMetaData wildcardPropertyMetaData;
    private AddMethodMetaData addMethodMetaData;
    private ValueAdapter valueAdapter = ValueAdapter.NOOP;
    private Boolean startElementCreatesObject;
    private WildcardBinding wildcard;
    private ModelGroupBinding modelGroup;

    public TypeBinding() {
        this(null);
    }

    public TypeBinding(QName qName) {
        this(qName, RtCharactersHandler.INSTANCE);
    }

    public TypeBinding(QName qName, CharactersHandler simple) {
        this.qName = qName;
        this.simpleType = simple;
    }

    public TypeBinding(QName qName, TypeBinding baseType) {
        this(qName, baseType.simpleType);
        if (baseType.modelGroup != null) {
            try {
                this.modelGroup = (ModelGroupBinding)baseType.modelGroup.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new JBossXBRuntimeException(e.getMessage());
            }
        }
        this.arrayItem = baseType.arrayItem;
        this.attrs = new HashMap(baseType.attrs);
        this.classMetaData = baseType.classMetaData;
        this.valueMetaData = baseType.valueMetaData;
        this.propertyMetaData = baseType.propertyMetaData;
        this.mapEntryMetaData = baseType.mapEntryMetaData;
        this.schemaBinding = baseType.schemaBinding;
        this.baseType = baseType;
        if (!baseType.isStartElementCreatesObject()) {
            this.handler = baseType.handler;
        }
    }

    public QName getQName() {
        return this.qName;
    }

    public ElementBinding getElement(QName name) {
        return this.getElement(name, null);
    }

    public ElementBinding getElement(QName name, Attributes atts) {
        ElementBinding element = null;
        if (this.modelGroup != null) {
            element = this.modelGroup.newCursor().getElement(name, atts);
        }
        if (element == null && this.wildcard != null) {
            element = this.wildcard.getElement(name, atts);
        }
        return element;
    }

    public void addElement(ElementBinding binding) {
        if (this.modelGroup == null) {
            this.modelGroup = new AllBinding();
            if (binding.isMultiOccurs()) {
                this.arrayItem = binding;
            }
        } else {
            this.arrayItem = null;
        }
        this.modelGroup.addElement(binding);
    }

    public ElementBinding addElement(QName name, TypeBinding type) {
        ElementBinding el = new ElementBinding(this.schemaBinding, name, type);
        this.addElement(el);
        return el;
    }

    public void addGroup(Map group) {
        Iterator i = group.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            QName name = (QName)entry.getKey();
            TypeBinding type = (TypeBinding)entry.getValue();
            this.addElement(name, type);
        }
    }

    public AttributeBinding getAttribute(QName qName) {
        return (AttributeBinding)this.attrs.get(qName);
    }

    public Attributes expandWithDefaultAttributes(Attributes attrs) {
        if (this.attrs.size() == 0) {
            return attrs;
        }
        HashMap attrsNotSeen = new HashMap(this.attrs);
        for (int n = 0; n < attrs.getLength(); ++n) {
            QName name = new QName(attrs.getURI(n), attrs.getLocalName(n));
            attrsNotSeen.remove(name);
        }
        Attributes expandedAttrs = attrs;
        if (attrsNotSeen.size() > 0) {
            AttributesImpl tmp = new AttributesImpl(attrs);
            Iterator iter = attrsNotSeen.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                QName name = (QName)entry.getKey();
                AttributeBinding binding = (AttributeBinding)entry.getValue();
                String constraint = binding.getDefaultConstraint();
                if (constraint == null) continue;
                QName typeName = binding.getType().getQName();
                tmp.addAttribute(name.getNamespaceURI(), name.getLocalPart(), name.toString(), typeName.toString(), constraint);
            }
            expandedAttrs = tmp;
        }
        return expandedAttrs;
    }

    public AttributeBinding addAttribute(QName name, TypeBinding type, AttributeHandler handler) {
        AttributeBinding attr = new AttributeBinding(this.schemaBinding, name, type, handler);
        switch (this.attrs.size()) {
            case 0: {
                this.attrs = Collections.singletonMap(name, attr);
                break;
            }
            case 1: {
                this.attrs = new HashMap(this.attrs);
            }
            default: {
                this.attrs.put(name, attr);
            }
        }
        return attr;
    }

    public CharactersHandler getSimpleType() {
        return this.simpleType;
    }

    public void setSimpleType(CharactersHandler simpleType) {
        this.simpleType = simpleType;
    }

    public void setHandler(ElementHandler handler) {
        this.handler = handler;
    }

    public ElementHandler getHandler() {
        return this.handler;
    }

    public void pushInterceptor(QName qName, ElementInterceptor interceptor) {
        ElementBinding el = this.getElement(qName);
        if (el == null) {
            el = this.addElement(qName, new TypeBinding());
        }
        el.pushInterceptor(interceptor);
    }

    public TypeBinding getBaseType() {
        return this.baseType;
    }

    public boolean isSimple() {
        return this.modelGroup == null && this.attrs.isEmpty();
    }

    public boolean isArrayWrapper() {
        return this.arrayItem != null || this.modelGroup != null && this.modelGroup.getArrayItem() != null;
    }

    public ElementBinding getArrayItem() {
        return this.arrayItem == null ? (this.modelGroup == null ? null : this.modelGroup.getArrayItem()) : this.arrayItem;
    }

    public ClassMetaData getClassMetaData() {
        return this.classMetaData;
    }

    public void setClassMetaData(ClassMetaData classMetaData) {
        this.classMetaData = classMetaData;
    }

    public SchemaBinding getSchemaBinding() {
        return this.schemaBinding;
    }

    public void setSchemaBinding(SchemaBinding schemaBinding) {
        this.schemaBinding = schemaBinding;
    }

    public void setValueMetaData(ValueMetaData valueMetaData) {
        this.valueMetaData = valueMetaData;
    }

    public ValueMetaData getValueMetaData() {
        return this.valueMetaData;
    }

    public PropertyMetaData getPropertyMetaData() {
        return this.propertyMetaData;
    }

    public void setPropertyMetaData(PropertyMetaData propertyMetaData) {
        this.propertyMetaData = propertyMetaData;
    }

    public MapEntryMetaData getMapEntryMetaData() {
        return this.mapEntryMetaData;
    }

    public void setMapEntryMetaData(MapEntryMetaData mapEntryMetaData) {
        this.mapEntryMetaData = mapEntryMetaData;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public CharactersMetaData getCharactersMetaData() {
        return this.charMetaData;
    }

    public void setCharactersMetaData(CharactersMetaData charMetaData) {
        this.charMetaData = charMetaData;
    }

    public PropertyMetaData getWildcardPropertyMetaData() {
        return this.wildcardPropertyMetaData;
    }

    public void setWildcardPropertyMetaData(PropertyMetaData wildcardPropertyMetaData) {
        this.wildcardPropertyMetaData = wildcardPropertyMetaData;
    }

    public void setAddMethodMetaData(AddMethodMetaData addMethodMetaData) {
        this.addMethodMetaData = addMethodMetaData;
    }

    public AddMethodMetaData getAddMethodMetaData() {
        return this.addMethodMetaData;
    }

    public ValueAdapter getValueAdapter() {
        return this.valueAdapter;
    }

    public void setValueAdapter(ValueAdapter valueAdapter) {
        this.valueAdapter = valueAdapter;
    }

    public boolean isStartElementCreatesObject() {
        return this.startElementCreatesObject == null ? this.modelGroup != null || !this.attrs.isEmpty() : this.startElementCreatesObject;
    }

    public void setStartElementCreatesObject(boolean startElementCreatesObject) {
        this.startElementCreatesObject = startElementCreatesObject ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setWildcard(WildcardBinding wildcard) {
        this.wildcard = wildcard;
    }

    public boolean hasWildcard() {
        return this.wildcard != null;
    }

    public ModelGroupBinding getModelGroup() {
        return this.modelGroup;
    }

    public void setModelGroup(ModelGroupBinding modelGroup) {
        this.modelGroup = modelGroup;
    }
}

