/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.dynany;

import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.Any;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.TypeCode;
import org.jacorb.orb.dynany.DynAny;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.InputStream;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynSequenceHelper;

public final class DynSequence
extends DynAny
implements org.omg.DynamicAny.DynSequence {
    private final List members = new ArrayList();
    private int length;
    private org.omg.CORBA.TypeCode elementType;

    DynSequence(DynAnyFactory dynAnyFactory, org.omg.CORBA.TypeCode typeCode, ORB oRB, Logger logger) throws TypeMismatch {
        super(dynAnyFactory, oRB, logger);
        org.omg.CORBA.TypeCode typeCode2 = TypeCode.originalType(typeCode);
        if (typeCode2.kind() != TCKind.tk_sequence) {
            throw new TypeMismatch();
        }
        try {
            this.typeCode = typeCode2;
            this.elementType = TypeCode.originalType(this.type().content_type());
            this.limit = this.typeCode.length();
            this.length = 0;
        }
        catch (BadKind badKind) {
            throw this.unexpectedException(badKind);
        }
        if (this.elementType == null) {
            throw new INTERNAL("DynSequence.set_length, elementType null");
        }
    }

    public void from_any(org.omg.CORBA.Any any) throws InvalidValue, TypeMismatch {
        this.checkDestroyed();
        if (!this.type().equivalent(any.type())) {
            throw new TypeMismatch();
        }
        try {
            this.typeCode = TypeCode.originalType(any.type());
            super.from_any(any);
            this.limit = this.type().length();
            InputStream inputStream = any.create_input_stream();
            this.length = inputStream.read_long();
            if (this.length > 0) {
                this.pos = 0;
            }
            if (this.limit != 0 && this.length > this.limit) {
                throw new InvalidValue();
            }
            this.members.clear();
            this.elementType = TypeCode.originalType(this.type().content_type());
            for (int i = 0; i < this.length; ++i) {
                Any any2 = (Any)this.orb.create_any();
                any2.read_value(inputStream, this.elementType);
                this.members.add(any2);
            }
        }
        catch (BadKind badKind) {
            throw this.unexpectedException(badKind);
        }
        if (this.elementType == null) {
            throw new INTERNAL("DynSequence.set_length, elementType null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.CORBA.Any to_any() {
        this.checkDestroyed();
        org.omg.CORBA.Any any = this.orb.create_any();
        any.type(this.type());
        CDROutputStream cDROutputStream = new CDROutputStream(this.orb);
        try {
            cDROutputStream.write_long(this.length);
            for (int i = 0; i < this.length; ++i) {
                cDROutputStream.write_value(this.elementType, ((Any)this.members.get(i)).create_input_stream());
            }
            CDRInputStream cDRInputStream = new CDRInputStream(this.orb, cDROutputStream.getBufferCopy());
            try {
                any.read_value(cDRInputStream, this.type());
                org.omg.CORBA.Any any2 = any;
                cDRInputStream.close();
                return any2;
            }
            catch (Throwable throwable) {
                cDRInputStream.close();
                throw throwable;
            }
        }
        finally {
            cDROutputStream.close();
        }
    }

    public boolean equal(org.omg.DynamicAny.DynAny dynAny) {
        this.checkDestroyed();
        if (!this.type().equal(dynAny.type())) {
            return false;
        }
        org.omg.DynamicAny.DynSequence dynSequence = DynSequenceHelper.narrow(dynAny);
        if (dynSequence.get_length() != this.get_length()) {
            return false;
        }
        org.omg.CORBA.Any[] anyArray = this.get_elements();
        org.omg.CORBA.Any[] anyArray2 = dynSequence.get_elements();
        for (int i = 0; i < anyArray.length; ++i) {
            if (anyArray[i].equal(anyArray2[i])) continue;
            return false;
        }
        return true;
    }

    public int get_length() {
        this.checkDestroyed();
        return this.length;
    }

    public void set_length(int n) throws InvalidValue {
        this.checkDestroyed();
        if (this.limit > 0 && n > this.limit) {
            throw new InvalidValue();
        }
        if (this.elementType == null) {
            throw new INTERNAL("DynSequence.set_length, elementType null");
        }
        if (n == 0) {
            this.members.clear();
            this.pos = -1;
        } else if (n > this.length) {
            try {
                for (int i = this.length; i < n; ++i) {
                    this.members.add(this.dynFactory.create_dyn_any_from_type_code(this.elementType).to_any());
                }
            }
            catch (InconsistentTypeCode inconsistentTypeCode) {
                throw this.unexpectedException(inconsistentTypeCode);
            }
            if (this.pos == -1) {
                this.pos = n - this.length - 1;
            }
        } else if (n < this.length) {
            int n2 = this.length - n;
            for (int i = 0; i < n2; ++i) {
                int n3 = this.length - 1 - i;
                this.members.remove(n3);
            }
            if (this.pos > n) {
                this.pos = -1;
            }
        }
        this.length = n;
    }

    public org.omg.CORBA.Any[] get_elements() {
        this.checkDestroyed();
        org.omg.CORBA.Any[] anyArray = new Any[this.members.size()];
        int n = this.members.size();
        while (n-- > 0) {
            anyArray[n] = (Any)this.members.get(n);
        }
        return anyArray;
    }

    public void set_elements(org.omg.CORBA.Any[] anyArray) throws TypeMismatch, InvalidValue {
        this.checkDestroyed();
        if (this.limit > 0 && anyArray.length > this.limit) {
            throw new InvalidValue();
        }
        int n = anyArray.length;
        while (n-- > 0) {
            org.omg.CORBA.TypeCode typeCode = TypeCode.originalType(anyArray[n].type());
            if (typeCode.kind() == this.elementType.kind()) continue;
            throw new TypeMismatch();
        }
        this.length = anyArray.length;
        this.members.clear();
        for (n = 0; n < this.length; ++n) {
            this.members.add(anyArray[n]);
        }
        this.pos = this.length > 0 ? 0 : -1;
    }

    public org.omg.DynamicAny.DynAny[] get_elements_as_dyn_any() {
        this.checkDestroyed();
        org.omg.DynamicAny.DynAny[] dynAnyArray = new org.omg.DynamicAny.DynAny[this.members.size()];
        try {
            int n = this.members.size();
            while (n-- > 0) {
                dynAnyArray[n] = this.dynFactory.create_dyn_any((Any)this.members.get(n));
            }
            return dynAnyArray;
        }
        catch (InconsistentTypeCode inconsistentTypeCode) {
            throw this.unexpectedException(inconsistentTypeCode);
        }
    }

    public void set_elements_as_dyn_any(org.omg.DynamicAny.DynAny[] dynAnyArray) throws TypeMismatch, InvalidValue {
        this.checkDestroyed();
        org.omg.CORBA.Any[] anyArray = new org.omg.CORBA.Any[dynAnyArray.length];
        int n = dynAnyArray.length;
        while (n-- > 0) {
            anyArray[n] = dynAnyArray[n].to_any();
        }
        this.set_elements(anyArray);
    }

    public void destroy() {
        super.destroy();
        this.members.clear();
        this.elementType = null;
    }

    protected org.omg.CORBA.Any getRepresentation() {
        return (Any)this.members.get(this.pos);
    }

    public boolean next() {
        this.checkDestroyed();
        if (this.pos < this.length - 1) {
            ++this.pos;
            return true;
        }
        this.pos = -1;
        return false;
    }

    public boolean seek(int n) {
        this.checkDestroyed();
        if (n < 0) {
            this.pos = -1;
            return false;
        }
        if (n < this.length) {
            this.pos = n;
            return true;
        }
        this.pos = -1;
        return false;
    }

    public org.omg.DynamicAny.DynAny current_component() {
        this.checkDestroyed();
        if (this.pos == -1) {
            return null;
        }
        try {
            return this.dynFactory.create_dyn_any((Any)this.members.get(this.pos));
        }
        catch (InconsistentTypeCode inconsistentTypeCode) {
            throw this.unexpectedException(inconsistentTypeCode);
        }
    }

    public int component_count() {
        this.checkDestroyed();
        return this.get_length();
    }
}

