/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class CachedPreparedStatement
implements PreparedStatement {
    private PreparedStatement ps;
    private SynchronizedBoolean cached = new SynchronizedBoolean(true);
    private SynchronizedInt inUse = new SynchronizedInt(1);
    private int defaultMaxFieldSize;
    private int defaultMaxRows;
    private int defaultQueryTimeout;
    private int defaultFetchDirection;
    private int defaultFetchSize;
    private int currentMaxFieldSize;
    private int currentMaxRows;
    private int currentQueryTimeout;
    private int currentFetchDirection;
    private int currentFetchSize;

    public CachedPreparedStatement(PreparedStatement ps) throws SQLException {
        this.ps = ps;
        this.defaultMaxFieldSize = ps.getMaxFieldSize();
        this.defaultMaxRows = ps.getMaxRows();
        this.defaultQueryTimeout = ps.getQueryTimeout();
        this.defaultFetchDirection = ps.getFetchDirection();
        this.defaultFetchSize = ps.getFetchSize();
        this.currentMaxFieldSize = this.defaultMaxFieldSize;
        this.currentMaxRows = this.defaultMaxRows;
        this.currentQueryTimeout = this.defaultQueryTimeout;
        this.currentFetchDirection = this.defaultFetchDirection;
        this.currentFetchSize = this.defaultFetchSize;
    }

    public PreparedStatement getUnderlyingPreparedStatement() {
        return this.ps;
    }

    public ResultSet executeQuery() throws SQLException {
        return this.ps.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        return this.ps.executeUpdate();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.ps.setNull(parameterIndex, sqlType);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.ps.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.ps.setByte(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.ps.setShort(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.ps.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.ps.setLong(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.ps.setFloat(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.ps.setDouble(parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.ps.setBigDecimal(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.ps.setString(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.ps.setBytes(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.ps.setDate(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.ps.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.ps.setTimestamp(parameterIndex, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setAsciiStream(parameterIndex, x, length);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setUnicodeStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setBinaryStream(parameterIndex, x, length);
    }

    public void clearParameters() throws SQLException {
        this.ps.clearParameters();
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.ps.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.ps.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.ps.setObject(parameterIndex, x);
    }

    public boolean execute() throws SQLException {
        return this.ps.execute();
    }

    public void addBatch() throws SQLException {
        this.ps.addBatch();
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.ps.setCharacterStream(parameterIndex, reader, length);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.ps.setRef(i, x);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.ps.setBlob(i, x);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.ps.setClob(i, x);
    }

    public void setArray(int i, Array x) throws SQLException {
        this.ps.setArray(i, x);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.ps.getMetaData();
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.ps.setDate(parameterIndex, x, cal);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.ps.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.ps.setTimestamp(parameterIndex, x, cal);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.ps.setNull(paramIndex, sqlType, typeName);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.ps.setURL(parameterIndex, x);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.ps.getParameterMetaData();
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return this.ps.executeQuery(sql);
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.ps.executeUpdate(sql);
    }

    public boolean isInUse() {
        return this.inUse.get() > 0;
    }

    public void inUse() {
        this.inUse.increment();
    }

    public void agedOut() throws SQLException {
        this.cached.set(false);
        if (this.inUse.get() == 0) {
            this.ps.close();
        }
    }

    public void close() throws SQLException {
        this.inUse.decrement();
        if (this.inUse.get() == 0) {
            if (!this.cached.get()) {
                this.ps.close();
            } else {
                if (this.defaultMaxFieldSize != this.currentMaxFieldSize) {
                    this.ps.setMaxFieldSize(this.defaultMaxFieldSize);
                    this.currentMaxFieldSize = this.defaultMaxFieldSize;
                }
                if (this.defaultMaxRows != this.currentMaxRows) {
                    this.ps.setMaxRows(this.defaultMaxRows);
                    this.currentMaxRows = this.defaultMaxRows;
                }
                if (this.defaultQueryTimeout != this.currentQueryTimeout) {
                    this.ps.setQueryTimeout(this.defaultQueryTimeout);
                    this.currentQueryTimeout = this.defaultQueryTimeout;
                }
                if (this.defaultFetchDirection != this.currentFetchDirection) {
                    this.ps.setFetchDirection(this.defaultFetchDirection);
                    this.currentFetchDirection = this.defaultFetchDirection;
                }
                if (this.defaultFetchSize != this.currentFetchSize) {
                    this.ps.setFetchSize(this.defaultFetchSize);
                    this.currentFetchSize = this.defaultFetchSize;
                }
            }
        }
    }

    public int getMaxFieldSize() throws SQLException {
        return this.ps.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.ps.setMaxFieldSize(max);
        this.currentMaxFieldSize = max;
    }

    public int getMaxRows() throws SQLException {
        return this.ps.getMaxRows();
    }

    public void setMaxRows(int max) throws SQLException {
        this.ps.setMaxRows(max);
        this.currentMaxRows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ps.setEscapeProcessing(enable);
    }

    public int getQueryTimeout() throws SQLException {
        return this.ps.getQueryTimeout();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.ps.setQueryTimeout(seconds);
        this.currentQueryTimeout = seconds;
    }

    public void cancel() throws SQLException {
        this.ps.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.ps.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.ps.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.ps.setCursorName(name);
    }

    public boolean execute(String sql) throws SQLException {
        return this.ps.execute(sql);
    }

    public ResultSet getResultSet() throws SQLException {
        return this.ps.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return this.ps.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.ps.getMoreResults();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.ps.setFetchDirection(direction);
        this.currentFetchDirection = direction;
    }

    public int getFetchDirection() throws SQLException {
        return this.ps.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.ps.setFetchSize(rows);
        this.currentFetchSize = rows;
    }

    public int getFetchSize() throws SQLException {
        return this.ps.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.ps.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.ps.getResultSetType();
    }

    public void addBatch(String sql) throws SQLException {
        this.ps.addBatch(sql);
    }

    public void clearBatch() throws SQLException {
        this.ps.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.ps.executeBatch();
    }

    public Connection getConnection() throws SQLException {
        return this.ps.getConnection();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.ps.getMoreResults(current);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.ps.getGeneratedKeys();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.ps.executeUpdate(sql, autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.ps.executeUpdate(sql, columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.ps.executeUpdate(sql, columnNames);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.ps.execute(sql, autoGeneratedKeys);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.ps.execute(sql, columnIndexes);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.ps.execute(sql, columnNames);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.ps.getResultSetHoldability();
    }
}

