/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EAR;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.Ejb3JmxDeployment;
import org.jboss.ejb3.Ejb3ModuleMBean;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;

public class Ejb3Module
extends ServiceMBeanSupport
implements Ejb3ModuleMBean {
    public static final String BASE_EJB3_JMX_NAME = "jboss.j2ee:service=EJB3";
    private static final Logger log = Logger.getLogger(Ejb3Module.class);
    private Ejb3JmxDeployment deployment;
    private DeploymentInfo di;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ejb3Module(DeploymentInfo di) {
        EAR ear = null;
        if (di.parent != null && (di.parent.shortName.endsWith(".ear") || di.parent.shortName.endsWith(".ear/"))) {
            HashMap hashMap = di.parent.context;
            synchronized (hashMap) {
                ear = (EAR)di.parent.context.get("EJB3_EAR_METADATA");
                if (ear == null) {
                    ear = new EARImpl(di.parent.shortName);
                    di.parent.context.put("EJB3_EAR_METADATA", ear);
                }
            }
        }
        this.deployment = new Ejb3JmxDeployment(di, ear);
        if (ear != null) {
            ear.register(this.deployment);
        }
        this.di = di;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createService() throws Exception {
        super.createService();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.di.ucl);
            this.deployment.create();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.di.ucl);
            this.deployment.start();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        super.startService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopService() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.di.ucl);
            this.deployment.stop();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        super.stopService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyService() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.di.ucl);
            this.deployment.destroy();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        super.destroyService();
    }

    public Container getContainer(ObjectName name) {
        return this.deployment.getContainer(name);
    }

    public Map getContainers() {
        return this.deployment.getEjbContainers();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EARImpl
    implements EAR {
        private ConcurrentHashMap<String, Ejb3Deployment> deployments = new ConcurrentHashMap();
        private String shortName;
        private String baseName;

        public EARImpl(String shortName) {
            this.shortName = shortName;
            int idx = shortName.lastIndexOf(46);
            this.baseName = shortName.substring(0, idx);
        }

        @Override
        public Collection<Ejb3Deployment> getEjbDeployments() {
            return this.deployments.values();
        }

        @Override
        public void register(Ejb3Deployment deployment) {
            this.deployments.put(deployment.getDeploymentUnit().getShortName(), deployment);
        }

        @Override
        public void unregister(Ejb3Deployment deployment) {
            this.deployments.remove(deployment.getDeploymentUnit().getShortName());
        }

        @Override
        public Ejb3Deployment findRelativeDeployment(String relativeName) {
            String relativeShortName = relativeName.substring(3);
            return this.deployments.get(relativeShortName);
        }

        @Override
        public String getShortName() {
            return this.shortName;
        }

        @Override
        public String getBaseName() {
            return this.baseName;
        }
    }
}

