/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.simple;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.EJBNoSuchObjectException;
import org.jboss.annotation.ejb.cache.simple.CacheConfig;
import org.jboss.annotation.ejb.cache.simple.PersistenceManager;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Pool;
import org.jboss.ejb3.cache.StatefulCache;
import org.jboss.ejb3.cache.simple.StatefulSessionPersistenceManager;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.logging.Logger;

public class SimpleStatefulCache
implements StatefulCache {
    private static final Logger log = Logger.getLogger(SimpleStatefulCache.class);
    private Pool pool;
    private CacheMap cacheMap;
    private int maxSize = 1000;
    private StatefulSessionPersistenceManager pm;
    private long sessionTimeout = 300L;
    private SessionTimeoutTask timeoutTask;
    private boolean running = true;

    public void initialize(Container container) throws Exception {
        Advisor advisor = (Advisor)((Object)container);
        this.pool = container.getPool();
        this.cacheMap = new CacheMap();
        PersistenceManager pmConfig = (PersistenceManager)advisor.resolveAnnotation(PersistenceManager.class);
        this.pm = (StatefulSessionPersistenceManager)pmConfig.value().newInstance();
        this.pm.initialize(container);
        CacheConfig config = (CacheConfig)advisor.resolveAnnotation(CacheConfig.class);
        this.maxSize = config.maxSize();
        this.sessionTimeout = config.idleTimeoutSeconds();
        log.info("Initializing SimpleStatefulCache with maxSize: " + this.maxSize + " timeout: " + this.sessionTimeout + " for " + container.getObjectName().getCanonicalName());
        this.timeoutTask = new SessionTimeoutTask("SFSB Passivation Thread - " + container.getObjectName().getCanonicalName());
    }

    public void start() {
        this.running = true;
        this.timeoutTask.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        CacheMap cacheMap = this.cacheMap;
        synchronized (cacheMap) {
            this.running = false;
            this.timeoutTask.interrupt();
            this.cacheMap.clear();
            try {
                this.pm.destroy();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void passivate(StatefulBeanContext ctx) {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((EJBContainer)ctx.getContainer()).getClassloader());
            this.pm.passivateSession(ctx);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulBeanContext create() {
        StatefulBeanContext ctx = null;
        try {
            ctx = (StatefulBeanContext)this.pool.get();
            CacheMap cacheMap = this.cacheMap;
            synchronized (cacheMap) {
                this.cacheMap.put(ctx.getId(), ctx);
            }
            ctx.inUse = true;
            ctx.lastUsed = System.currentTimeMillis();
        }
        catch (EJBException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EJBException(e);
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulBeanContext create(Class[] initTypes, Object[] initValues) {
        StatefulBeanContext ctx = null;
        try {
            ctx = (StatefulBeanContext)this.pool.get(initTypes, initValues);
            CacheMap cacheMap = this.cacheMap;
            synchronized (cacheMap) {
                this.cacheMap.put(ctx.getId(), ctx);
            }
            ctx.inUse = true;
            ctx.lastUsed = System.currentTimeMillis();
        }
        catch (EJBException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EJBException(e);
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulBeanContext get(Object key) throws EJBException {
        StatefulBeanContext entry = null;
        CacheMap cacheMap = this.cacheMap;
        synchronized (cacheMap) {
            entry = (StatefulBeanContext)this.cacheMap.get(key);
        }
        if (entry == null) {
            StatefulBeanContext bean = this.pm.activateSession(key);
            if (bean == null) {
                throw new EJBNoSuchObjectException("Could not find Stateful bean: " + key);
            }
            entry = bean;
            CacheMap cacheMap2 = this.cacheMap;
            synchronized (cacheMap2) {
                this.cacheMap.put(key, entry);
            }
        }
        entry.inUse = true;
        entry.lastUsed = System.currentTimeMillis();
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(StatefulBeanContext ctx) {
        StatefulBeanContext statefulBeanContext = ctx;
        synchronized (statefulBeanContext) {
            ctx.inUse = false;
            ctx.lastUsed = System.currentTimeMillis();
            if (ctx.markedForPassivation) {
                this.passivate(ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object key) {
        StatefulBeanContext ctx = null;
        CacheMap cacheMap = this.cacheMap;
        synchronized (cacheMap) {
            ctx = (StatefulBeanContext)this.cacheMap.remove(key);
        }
        if (ctx != null) {
            this.pool.remove(ctx);
        }
    }

    private class SessionTimeoutTask
    extends Thread {
        public SessionTimeoutTask(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (SimpleStatefulCache.this.running) {
                try {
                    Thread.sleep(SimpleStatefulCache.this.sessionTimeout * 1000L);
                }
                catch (InterruptedException e) {
                    SimpleStatefulCache.this.running = false;
                    return;
                }
                try {
                    CacheMap e = SimpleStatefulCache.this.cacheMap;
                    synchronized (e) {
                        if (!SimpleStatefulCache.this.running) {
                            return;
                        }
                        Iterator it = SimpleStatefulCache.this.cacheMap.entrySet().iterator();
                        long now = System.currentTimeMillis();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            StatefulBeanContext centry = (StatefulBeanContext)entry.getValue();
                            if (now - centry.lastUsed < SimpleStatefulCache.this.sessionTimeout * 1000L) continue;
                            StatefulBeanContext statefulBeanContext = centry;
                            synchronized (statefulBeanContext) {
                                if (centry.inUse) {
                                    centry.markedForPassivation = true;
                                } else {
                                    SimpleStatefulCache.this.passivate(centry);
                                }
                                it.remove();
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    log.error("problem passivation thread", ex);
                }
            }
        }
    }

    private class CacheMap
    extends LinkedHashMap {
        public CacheMap() {
            super(SimpleStatefulCache.this.maxSize, 0.75f, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeEldestEntry(Map.Entry entry) {
            boolean removeIt;
            boolean bl = removeIt = this.size() > SimpleStatefulCache.this.maxSize;
            if (removeIt) {
                StatefulBeanContext centry;
                StatefulBeanContext statefulBeanContext = centry = (StatefulBeanContext)entry.getValue();
                synchronized (statefulBeanContext) {
                    if (centry.inUse) {
                        centry.markedForPassivation = true;
                    } else {
                        SimpleStatefulCache.this.passivate(centry);
                    }
                }
            }
            return removeIt;
        }
    }
}

