/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BodyRegionArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layout.RegionArea;

public class RegionBody
extends Region {
    public static final String REGION_CLASS = "body";

    public static FObj.Maker maker() {
        return new Maker();
    }

    protected RegionBody(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
    }

    public String getName() {
        return "fo:region-body";
    }

    RegionArea makeRegionArea(int allocationRectangleXPosition, int allocationRectangleYPosition, int allocationRectangleWidth, int allocationRectangleHeight) {
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        MarginProps mProps = this.propMgr.getMarginProps();
        BodyRegionArea body = new BodyRegionArea(allocationRectangleXPosition + mProps.marginLeft, allocationRectangleYPosition - mProps.marginTop, allocationRectangleWidth - mProps.marginLeft - mProps.marginRight, allocationRectangleHeight - mProps.marginTop - mProps.marginBottom);
        body.setBackground(this.propMgr.getBackgroundProps());
        int overflow = this.properties.get("overflow").getEnum();
        String columnCountAsString = this.properties.get("column-count").getString();
        int columnCount = 1;
        try {
            if (columnCountAsString.charAt(0) >= '0' && columnCountAsString.charAt(0) <= '9') {
                columnCount = Integer.parseInt(columnCountAsString);
            } else {
                this.log.error("Bad value on region body 'column-count'");
            }
        }
        catch (NumberFormatException nfe) {
            this.log.error("Bad value on region body 'column-count'");
            columnCount = 1;
        }
        if (columnCount > 1 && overflow == 101) {
            this.log.error("Setting 'column-count' to 1 because 'overflow' is set to 'scroll'");
            columnCount = 1;
        }
        body.setColumnCount(columnCount);
        int columnGap = this.properties.get("column-gap").getLength().mvalue();
        body.setColumnGap(columnGap);
        return body;
    }

    protected String getDefaultRegionName() {
        return "xsl-region-body";
    }

    public String getRegionClass() {
        return REGION_CLASS;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new RegionBody(parent, propertyList, systemId, line, column);
        }
    }
}

