/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.taglib.decorator;

import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.taglib.AbstractTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class PropertyTag
extends AbstractTag {
    private String propertyName;
    private String defaultValue;
    private boolean writeEntireProperty = false;

    public void setProperty(String string) {
        this.propertyName = string;
    }

    public void setDefault(String string) {
        this.defaultValue = string;
    }

    public final void setWriteEntireProperty(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        switch (string.charAt(0)) {
            case '1': 
            case 'T': 
            case 'Y': 
            case 't': 
            case 'y': {
                this.writeEntireProperty = true;
                break;
            }
            default: {
                this.writeEntireProperty = false;
            }
        }
    }

    public final int doEndTag() throws JspException {
        try {
            HTMLPage hTMLPage = (HTMLPage)this.getPage();
            String string = hTMLPage.getProperty(this.propertyName);
            if (string == null || string.trim().length() == 0) {
                string = this.defaultValue;
            }
            if (string != null) {
                JspWriter jspWriter = this.pageContext.getOut();
                if (this.writeEntireProperty) {
                    jspWriter.print(" ");
                    jspWriter.print(this.propertyName.substring(this.propertyName.lastIndexOf(46) + 1));
                    jspWriter.print("=\"");
                    jspWriter.print(string);
                    jspWriter.print("\"");
                } else {
                    jspWriter.print(string);
                }
            }
        }
        catch (Exception exception) {
            this.trace(exception);
        }
        return 6;
    }

    public void release() {
        this.defaultValue = null;
        this.propertyName = null;
        super.release();
    }
}

