/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.antlr.Tool;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.DecisionProbe;
import org.antlr.analysis.NFA;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.NFAToDFAConverter;
import org.antlr.analysis.Transition;
import org.antlr.runtime.IntStream;
import org.antlr.tool.FASerializer;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Interpreter;

public class DFA {
    public static final int REACHABLE_UNKNOWN = -2;
    public static final int REACHABLE_BUSY = -1;
    public static final int REACHABLE_NO = 0;
    public static final int REACHABLE_YES = 1;
    public static final int MAX_STATES_PER_ALT_IN_DFA = 400;
    public DFAState startState;
    public int decisionNumber = 0;
    public NFAState decisionNFAStartState;
    protected Map configurationsToDFAStateMap = new HashMap();
    protected Vector states = new Vector();
    protected int stateCounter = 0;
    protected int numberOfStates = 0;
    protected int user_k = -1;
    protected int max_k = -1;
    protected boolean reduced = true;
    protected boolean cyclic = false;
    protected List unreachableAlts;
    protected DFAState[] altToAcceptState;
    protected int nAlts = 0;
    public NFA nfa;
    protected NFAToDFAConverter nfaConverter;
    public DecisionProbe probe = new DecisionProbe(this);

    public DFA(int n, NFAState nFAState) {
        this.decisionNumber = n;
        this.decisionNFAStartState = nFAState;
        this.nfa = nFAState.nfa;
        this.nAlts = this.nfa.grammar.getNumberOfAltsForDecisionNFA(nFAState);
        this.initAltRelatedInfo();
        this.nfaConverter = new NFAToDFAConverter(this);
        this.nfaConverter.convert(nFAState);
        this.verify();
        if (!this.probe.isDeterministic() || this.probe.analysisAborted() || this.probe.analysisOverflowed()) {
            this.probe.issueWarnings();
        }
        if (Tool.internalOption_PrintDFA) {
            System.out.println("DFA d=" + n);
            FASerializer fASerializer = new FASerializer(this.nfa.grammar);
            String string = fASerializer.serialize(this.startState);
            System.out.println(string);
        }
    }

    public int predict(IntStream intStream) {
        Interpreter interpreter = new Interpreter(this.nfa.grammar, intStream);
        return interpreter.predict(this);
    }

    protected DFAState addState(DFAState dFAState) {
        if (this.getUserMaxLookahead() > 0) {
            this.configurationsToDFAStateMap.put(dFAState, dFAState);
            ++this.numberOfStates;
            return dFAState;
        }
        DFAState dFAState2 = (DFAState)this.configurationsToDFAStateMap.get(dFAState);
        if (dFAState2 != null) {
            return dFAState2;
        }
        this.configurationsToDFAStateMap.put(dFAState, dFAState);
        ++this.numberOfStates;
        return dFAState;
    }

    public void removeState(DFAState dFAState) {
        DFAState dFAState2 = (DFAState)this.configurationsToDFAStateMap.remove(dFAState);
        if (dFAState2 != null) {
            --this.numberOfStates;
        }
    }

    public Map getConfigurationsToDFAStateMap() {
        return this.configurationsToDFAStateMap;
    }

    public DFAState getState(int n) {
        return (DFAState)this.states.get(n);
    }

    public void setState(int n, DFAState dFAState) {
        this.states.set(n, dFAState);
    }

    public boolean isReduced() {
        return this.reduced;
    }

    public boolean isCyclic() {
        return this.cyclic && this.getUserMaxLookahead() == 0;
    }

    public boolean isTokensRuleDecision() {
        if (this.nfa.grammar.type != 1) {
            return false;
        }
        NFAState nFAState = this.getNFADecisionStartState();
        NFAState nFAState2 = this.nfa.grammar.getRuleStartState("Tokens");
        NFAState nFAState3 = (NFAState)nFAState2.transition((int)0).target;
        return nFAState == nFAState3;
    }

    public int getUserMaxLookahead() {
        if (this.user_k >= 0) {
            return this.user_k;
        }
        GrammarAST grammarAST = this.nfa.grammar.getDecisionBlockAST(this.decisionNumber);
        Integer n = (Integer)grammarAST.getOption("k");
        if (n == null) {
            this.user_k = 0;
            return 0;
        }
        this.user_k = n;
        return this.user_k;
    }

    public void setUserMaxLookahead(int n) {
        this.user_k = n;
    }

    public int getMaxLookaheadDepth() {
        if (this.isCyclic()) {
            return Integer.MAX_VALUE;
        }
        return this.max_k;
    }

    public List getUnreachableAlts() {
        return this.unreachableAlts;
    }

    public void verify() {
        this.doesStateReachAcceptState(this.startState);
    }

    protected boolean doesStateReachAcceptState(DFAState dFAState) {
        if (dFAState.isAcceptState()) {
            dFAState.setAcceptStateReachable(1);
            int n = dFAState.getUniquelyPredictedAlt();
            this.unreachableAlts.remove(new Integer(n));
            return true;
        }
        dFAState.setAcceptStateReachable(-1);
        boolean bl = false;
        for (int i = 0; i < dFAState.getNumberOfTransitions(); ++i) {
            Transition transition = dFAState.transition(i);
            DFAState dFAState2 = (DFAState)transition.target;
            int n = dFAState2.getAcceptStateReachable();
            if (n == -1) {
                this.cyclic = true;
                continue;
            }
            if (n == 1) {
                bl = true;
                continue;
            }
            if (n == 0 || !this.doesStateReachAcceptState(dFAState2)) continue;
            bl = true;
        }
        if (bl) {
            dFAState.setAcceptStateReachable(1);
        } else {
            dFAState.setAcceptStateReachable(0);
            this.reduced = false;
        }
        return bl;
    }

    public NFAState getNFADecisionStartState() {
        return this.decisionNFAStartState;
    }

    public DFAState getAcceptState(int n) {
        return this.altToAcceptState[n];
    }

    public void setAcceptState(int n, DFAState dFAState) {
        this.altToAcceptState[n] = dFAState;
    }

    public int getDecisionNumber() {
        return this.decisionNFAStartState.getDecisionNumber();
    }

    public GrammarAST getDecisionASTNode() {
        return this.decisionNFAStartState.getAssociatedASTNode();
    }

    public boolean isGreedy() {
        GrammarAST grammarAST = this.nfa.grammar.getDecisionBlockAST(this.decisionNumber);
        String string = (String)grammarAST.getOption("greedy");
        return string == null || !string.equals("false");
    }

    public DFAState newState() {
        DFAState dFAState = new DFAState(this);
        dFAState.stateNumber = this.stateCounter++;
        this.states.setSize(dFAState.stateNumber + 1);
        this.states.set(dFAState.stateNumber, dFAState);
        return dFAState;
    }

    public int getNumberOfStates() {
        return this.numberOfStates;
    }

    public int getNumberOfAlts() {
        return this.nAlts;
    }

    public boolean analysisAborted() {
        return this.probe.analysisAborted();
    }

    protected void initAltRelatedInfo() {
        this.unreachableAlts = new LinkedList();
        for (int i = 1; i <= this.nAlts; ++i) {
            this.unreachableAlts.add(new Integer(i));
        }
        this.altToAcceptState = new DFAState[this.nAlts + 1];
    }

    public String toString() {
        FASerializer fASerializer = new FASerializer(this.nfa.grammar);
        String string = fASerializer.serialize(this.startState);
        return string;
    }
}

