/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.jmx;

import cirrus.hibernate.Datastore;
import cirrus.hibernate.Hibernate;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.helpers.PropertiesHelper;
import cirrus.hibernate.jmx.HibernateServiceMBean;
import cirrus.hibernate.jmx.SessionFactoryStub;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HibernateService
implements HibernateServiceMBean {
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$jmx$HibernateServiceMBean == null ? (class$cirrus$hibernate$jmx$HibernateServiceMBean = HibernateService.class$("cirrus.hibernate.jmx.HibernateServiceMBean")) : class$cirrus$hibernate$jmx$HibernateServiceMBean));
    private final Properties props = new Properties();
    private String mapResources;
    private String boundName;
    static /* synthetic */ Class class$cirrus$hibernate$jmx$HibernateServiceMBean;

    public String getName() {
        return this.props.getProperty("hibernate.session_factory_name");
    }

    public String getMapResources() {
        return this.mapResources;
    }

    public void setMapResources(String mapResources) {
        this.mapResources = mapResources.trim();
    }

    public void addMapResource(String mapResource) {
        this.mapResources = this.mapResources == null || this.mapResources.length() == 0 ? mapResource.trim() : this.mapResources + ", " + mapResource.trim();
    }

    public String getDatasource() {
        return this.props.getProperty("hibernate.connection.datasource");
    }

    public void setDatasource(String datasource) {
        this.props.setProperty("hibernate.connection.datasource", datasource);
    }

    public String getDialect() {
        return this.props.getProperty("hibernate.dialect");
    }

    public void setDialect(String dialect) {
        this.props.setProperty("hibernate.dialect", dialect);
    }

    public String getJndiName() {
        return this.props.getProperty("hibernate.session_factory_name");
    }

    public void setJndiName(String jndiName) {
        this.props.setProperty("hibernate.session_factory_name", jndiName);
    }

    public boolean getUseOuterJoin() {
        String prop = this.props.getProperty("hibernate.use_outer_join");
        return Boolean.valueOf(prop);
    }

    public void setUseOuterJoin(boolean uoj) {
        this.props.setProperty("hibernate.use_outer_join", uoj ? "true" : "false");
    }

    public boolean getShowSql() {
        String prop = this.props.getProperty("hibernate.show_sql");
        return Boolean.valueOf(prop);
    }

    public void setShowSql(boolean showSql) {
        this.props.setProperty("hibernate.show_sql", showSql ? "true" : "false");
    }

    public String getUserName() {
        return this.props.getProperty("hibernate.connection.username");
    }

    public void setUserName(String userName) {
        this.props.setProperty("hibernate.connection.username", userName);
    }

    public String getPassword() {
        return this.props.getProperty("hibernate.connection.password");
    }

    public void setPassword(String password) {
        this.props.setProperty("hibernate.connection.password", password);
    }

    private String[] parseResourceList(String resourceList) {
        return PropertiesHelper.toStringArray(resourceList, ", ");
    }

    public void start() throws HibernateException {
        this.boundName = this.getJndiName();
        try {
            this.bindSessionFactory();
        }
        catch (HibernateException he) {
            log.info((Object)"Could not build SessionFactory using the MBean classpath - will try again using client classpath");
            String[] mappingFiles = this.parseResourceList(this.getMapResources());
            new SessionFactoryStub(mappingFiles, this.props);
        }
    }

    public void stop() {
        log.info((Object)"stopping service");
        try {
            new InitialContext().unbind(this.boundName);
        }
        catch (NamingException e) {
            log.warn((Object)"exception while unbinding factory from JNDI", (Throwable)e);
        }
    }

    private void bindSessionFactory() throws HibernateException {
        log.info((Object)("starting service at JNDI name: " + this.boundName));
        log.info((Object)("properties: " + this.props));
        Datastore ds = Hibernate.createDatastore();
        String[] mappingFiles = this.parseResourceList(this.getMapResources());
        int i = 0;
        while (i < mappingFiles.length) {
            log.info((Object)("compiling mapping: " + mappingFiles[i]));
            ds.storeResource(mappingFiles[i], Thread.currentThread().getContextClassLoader());
            ++i;
        }
        ds.buildSessionFactory(this.props);
    }

    public String getTransactionStrategy() {
        return this.props.getProperty("hibernate.transaction.factory_class");
    }

    public String getUserTransactionName() {
        return this.props.getProperty("jta.UserTransaction");
    }

    public void setTransactionStrategy(String txnStrategy) {
        this.props.setProperty("hibernate.transaction.factory_class", txnStrategy);
    }

    public void setUserTransactionName(String utName) {
        this.props.setProperty("jta.UserTransaction", utName);
    }

    public String getProperties() {
        return this.props.toString();
    }

    public void setProperty(String property, String value) {
        this.props.setProperty(property, value);
    }

    public String getTransactionManagerLookupStrategy() {
        return this.props.getProperty("hibernate.transaction.manager_lookup_class");
    }

    public void setTransactionManagerLookupStrategy(String lkpStrategy) {
        this.props.setProperty("hibernate.transaction.manager_lookup_class", lkpStrategy);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

