/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.hsqldb.Trace;
import org.hsqldb.jdbcConnection;
import org.hsqldb.jdbcResultSet;

public class jdbcStatement
implements Statement {
    private jdbcConnection cConnection;
    private jdbcResultSet rSet;
    private boolean bEscapeProcessing = true;
    private int iMaxRows;

    public ResultSet executeQuery(String sql) throws SQLException {
        this.fetchResult(sql);
        return this.rSet;
    }

    public int executeUpdate(String sql) throws SQLException {
        this.fetchResult(sql);
        if (this.rSet == null) {
            return -1;
        }
        return this.rSet.getUpdateCount();
    }

    public void close() {
        this.closeOldResult();
        this.rSet = null;
    }

    public int getMaxFieldSize() {
        return 0;
    }

    public void setMaxFieldSize(int max) {
    }

    public int getMaxRows() {
        return this.iMaxRows;
    }

    public void setMaxRows(int max) {
        this.iMaxRows = max;
    }

    public void setEscapeProcessing(boolean enable) {
        this.bEscapeProcessing = enable;
    }

    public int getQueryTimeout() {
        return 0;
    }

    public void setQueryTimeout(int seconds) {
    }

    public void cancel() {
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public void setCursorName(String name) {
    }

    public boolean execute(String sql) throws SQLException {
        this.fetchResult(sql);
        if (this.rSet == null) {
            return false;
        }
        return this.rSet.isResult();
    }

    public ResultSet getResultSet() {
        if (this.rSet != null && this.rSet.isResult()) {
            return this.rSet;
        }
        return null;
    }

    public int getUpdateCount() {
        if (this.rSet == null) {
            return -1;
        }
        return this.rSet.getUpdateCount();
    }

    public boolean getMoreResults() {
        if (this.rSet != null) {
            this.rSet.close();
            this.rSet = null;
        }
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw Trace.error(19);
        }
    }

    public int getFetchDirection() {
        return 1000;
    }

    public void setFetchSize(int rows) {
    }

    public int getFetchSize() {
        return 1;
    }

    public int getResultSetConcurrency() {
        return 1007;
    }

    public int getResultSetType() {
        return 1003;
    }

    public void addBatch(String sql) throws SQLException {
        throw Trace.error(19);
    }

    public void clearBatch() throws SQLException {
        throw Trace.error(19);
    }

    public int[] executeBatch() throws SQLException {
        throw Trace.error(19);
    }

    public Connection getConnection() {
        return this.cConnection;
    }

    jdbcStatement(jdbcConnection c) {
        this.cConnection = c;
    }

    private void fetchResult(String sql) throws SQLException {
        if (this.bEscapeProcessing) {
            sql = this.cConnection.nativeSQL(sql);
        }
        this.closeOldResult();
        if (this.iMaxRows == 0) {
            this.rSet = this.cConnection.execute(sql);
        } else {
            try {
                sql = "SET MAXROWS " + this.iMaxRows + ";" + sql;
                this.rSet = this.cConnection.execute(sql);
                this.cConnection.execute("SET MAXROWS 0");
            }
            catch (SQLException e) {
                this.cConnection.execute("SET MAXROWS 0");
                throw e;
            }
        }
    }

    private void closeOldResult() {
        if (this.rSet != null) {
            this.rSet.close();
            this.rSet = null;
        }
    }
}

