/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipInputStream;
import org.jboss.virtual.plugins.context.jar.AbstractJarHandler;
import org.jboss.virtual.plugins.context.jar.NestedJarFromStream;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoCopyNestedJarHandler
extends AbstractJarHandler {
    private static final long serialVersionUID = 1L;
    private transient JarEntry entry;
    private NestedJarFromStream njar;

    public NoCopyNestedJarHandler(VFSContext context, VirtualFileHandler parent, JarFile parentJar, JarEntry entry, URL url) throws IOException {
        super(context, parent, url, NoCopyNestedJarHandler.getEntryName(entry));
        try {
            InputStream is = parentJar.getInputStream(entry);
            ZipInputStream jis = is instanceof ZipInputStream ? (ZipInputStream)is : new ZipInputStream(is);
            this.njar = new NestedJarFromStream(context, parent, jis, url, entry);
        }
        catch (IOException original) {
            IOException e = new IOException("Error opening jar file: " + url + " reason=" + original.getMessage());
            e.setStackTrace(original.getStackTrace());
            throw e;
        }
        this.entry = entry;
    }

    protected JarEntry getEntry() {
        this.checkClosed();
        return this.entry;
    }

    @Override
    public long getLastModified() throws IOException {
        return this.getEntry().getTime();
    }

    @Override
    public long getSize() throws IOException {
        return this.getEntry().getSize();
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.getJar().getInputStream(this.getEntry());
    }

    @Override
    public VirtualFileHandler findChild(String path) throws IOException {
        return this.njar.findChild(path);
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        return super.getChildren(ignoreErrors);
    }
}

