/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.AckSenderWindow;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Streamable;
import org.jgroups.util.TimeScheduler;

public class TOTAL
extends Protocol {
    private static final String PROT_NAME = "TOTAL";
    private static final String TRACE_PROP = "trace";
    private final long[] AVG_RETRANSMIT_INTERVAL = new long[]{1000L, 2000L, 3000L, 4000L};
    private static final long NULL_ID = -1L;
    private static final int NULL_STATE = -1;
    private static final int RUN = 0;
    private static final int FLUSH = 1;
    private static final int BLOCK = 2;
    private final ReadWriteLock stateLock = new WriterPreferenceReadWriteLock();
    private int state = -1;
    private Address addr = null;
    private Address sequencerAddr = null;
    private long sequencerSeqID = -1L;
    private long localSeqID = -1L;
    private long seqID = -1L;
    private SortedMap reqTbl;
    private SortedMap upTbl;
    private AckSenderWindow retransmitter;

    private String addrToString(Object addr) {
        return addr == null ? "<null>" : (addr instanceof IpAddress ? ((IpAddress)addr).getIpAddress().getHostAddress() + ':' + ((IpAddress)addr).getPort() : addr.toString());
    }

    public String getName() {
        return PROT_NAME;
    }

    public boolean setProperties(Properties properties) {
        String value = properties.getProperty(TRACE_PROP);
        if (value != null) {
            properties.remove(TRACE_PROP);
        }
        if (properties.size() > 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("The following properties are not recognized: " + properties));
            }
            return false;
        }
        return true;
    }

    public Vector requiredDownServices() {
        return new Vector();
    }

    public Vector requiredUpServices() {
        return new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _deliverBcast() {
        SortedMap sortedMap = this.upTbl;
        synchronized (sortedMap) {
            Message msg;
            while ((msg = (Message)this.upTbl.remove(new Long(this.seqID + 1L))) != null) {
                Header header = (Header)msg.removeHeader(this.getName());
                if (header.localSequenceID != -1L) {
                    this.passUp(new Event(1, msg));
                }
                ++this.seqID;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _replayBcast() {
        SortedMap sortedMap = this.upTbl;
        synchronized (sortedMap) {
            if (this.upTbl.size() > 0 && this.log.isInfoEnabled()) {
                this.log.info((Object)"Replaying undelivered bcasts");
            }
            Iterator it = this.upTbl.entrySet().iterator();
            while (it.hasNext()) {
                Message msg = (Message)it.next().getValue();
                it.remove();
                if (!msg.getSrc().equals(this.addr)) {
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.info((Object)("During replay: discarding BCAST[" + ((Header)msg.getHeader((String)this.getName())).sequenceID + "] from " + this.addrToString(msg.getSrc())));
                    continue;
                }
                Header header = (Header)msg.removeHeader(this.getName());
                if (header.localSequenceID == -1L) continue;
                this._sendBcastRequest(msg, header.localSequenceID);
            }
        }
    }

    private Message _sendUcast(Message msg) {
        msg.putHeader(this.getName(), new Header(2, -1L, -1L));
        return msg;
    }

    private void _sendBcastRequest(Message msg) {
        this._sendBcastRequest(msg, ++this.localSeqID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sendBcastRequest(Message msg, long id) {
        SortedMap sortedMap = this.reqTbl;
        synchronized (sortedMap) {
            this.reqTbl.put(new Long(id), msg);
        }
        this._transmitBcastRequest(id);
        this.retransmitter.add(id, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _transmitBcastRequest(long seqID) {
        if (this.state == -1) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Transmit BCAST_REQ[" + seqID + "] in NULL_STATE"));
            }
            return;
        }
        if (this.state == 2) {
            return;
        }
        SortedMap sortedMap = this.reqTbl;
        synchronized (sortedMap) {
            if (!this.reqTbl.containsKey(new Long(seqID))) {
                this.retransmitter.ack(seqID);
                return;
            }
        }
        Message reqMsg = new Message(this.sequencerAddr, this.addr, new byte[0]);
        reqMsg.putHeader(this.getName(), new Header(0, seqID, -1L));
        this.passDown(new Event(1, reqMsg));
    }

    private void _recvUcast(Message msg) {
        msg.removeHeader(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _recvBcast(Message msg) {
        Header header = (Header)msg.getHeader(this.getName());
        SortedMap sortedMap = this.upTbl;
        synchronized (sortedMap) {
            if (header.sequenceID <= this.seqID) {
                return;
            }
            this.upTbl.put(new Long(header.sequenceID), msg);
        }
        this._deliverBcast();
    }

    private void _recvBcastRequest(Message msg) {
        if (!this.addr.equals(this.sequencerAddr)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Received bcast request but not a sequencer");
            }
            return;
        }
        if (this.state == 2) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"Blocked, discard bcast req");
            }
            return;
        }
        Header header = (Header)msg.getHeader(this.getName());
        ++this.sequencerSeqID;
        Message repMsg = new Message(msg.getSrc(), this.addr, new byte[0]);
        repMsg.putHeader(this.getName(), new Header(1, header.localSequenceID, this.sequencerSeqID));
        this.passDown(new Event(1, repMsg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _recvBcastReply(Header header) {
        long id;
        Message msg;
        if (this.state == 2) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"Blocked, discard bcast rep");
            }
            return;
        }
        SortedMap sortedMap = this.reqTbl;
        synchronized (sortedMap) {
            msg = (Message)this.reqTbl.remove(new Long(header.localSequenceID));
        }
        if (msg != null) {
            this.retransmitter.ack(header.localSequenceID);
            id = header.localSequenceID;
        } else {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Bcast reply to non-existent BCAST_REQ[" + header.localSequenceID + "], Sending NULL bcast"));
            }
            id = -1L;
            msg = new Message(null, this.addr, new byte[0]);
        }
        msg.putHeader(this.getName(), new Header(3, id, header.sequenceID));
        this.passDown(new Event(1, msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _retransmitBcastRequest(long seqID) {
        try {
            this.stateLock.readLock().acquire();
            try {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Retransmit BCAST_REQ[" + seqID + ']'));
                }
                this._transmitBcastRequest(seqID);
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.stateLock.readLock().release();
                throw throwable;
            }
            this.stateLock.readLock().release();
            {
            }
        }
        catch (InterruptedException e) {
            this.log.error((Object)"failed acquiring a read lock", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _upBlock() {
        try {
            this.stateLock.writeLock().acquire();
            try {
                this.state = 1;
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.stateLock.writeLock().release();
                throw throwable;
            }
            this.stateLock.writeLock().release();
            {
            }
        }
        catch (InterruptedException e) {
            this.log.error((Object)"failed acquiring the write lock", (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _upMsg(Event event) {
        try {
            boolean bl;
            block22: {
                boolean bl2;
                block21: {
                    boolean bl3;
                    block20: {
                        boolean bl4;
                        block19: {
                            boolean bl5;
                            block18: {
                                boolean bl6;
                                block17: {
                                    boolean bl7;
                                    block16: {
                                        this.stateLock.readLock().acquire();
                                        try {
                                            if (this.state == -1) {
                                                if (this.log.isErrorEnabled()) {
                                                    this.log.error((Object)"Up msg in NULL_STATE");
                                                }
                                                bl7 = false;
                                                Object var7_10 = null;
                                                break block16;
                                            }
                                            Message msg = (Message)event.getArg();
                                            org.jgroups.Header obj = msg.getHeader(this.getName());
                                            if (!(obj instanceof Header)) {
                                                if (this.log.isErrorEnabled()) {
                                                    this.log.error((Object)"No TOTAL.Header found");
                                                }
                                                bl6 = false;
                                                break block17;
                                            }
                                            Header header = (Header)obj;
                                            switch (header.type) {
                                                case 2: {
                                                    this._recvUcast(msg);
                                                    bl5 = true;
                                                    break block18;
                                                }
                                                case 3: {
                                                    this._recvBcast(msg);
                                                    bl4 = false;
                                                    break block19;
                                                }
                                                case 0: {
                                                    this._recvBcastRequest(msg);
                                                    bl3 = false;
                                                    break block20;
                                                }
                                                case 1: {
                                                    this._recvBcastReply(header);
                                                    bl2 = false;
                                                    break block21;
                                                }
                                                default: {
                                                    if (this.log.isErrorEnabled()) {
                                                        this.log.error((Object)"Unknown header type");
                                                    }
                                                    bl = false;
                                                    break;
                                                }
                                            }
                                            break block22;
                                        }
                                        catch (Throwable throwable) {
                                            Object var7_17 = null;
                                            this.stateLock.readLock().release();
                                            throw throwable;
                                        }
                                    }
                                    this.stateLock.readLock().release();
                                    return bl7;
                                }
                                Object var7_11 = null;
                                this.stateLock.readLock().release();
                                return bl6;
                            }
                            Object var7_12 = null;
                            this.stateLock.readLock().release();
                            return bl5;
                        }
                        Object var7_13 = null;
                        this.stateLock.readLock().release();
                        return bl4;
                    }
                    Object var7_14 = null;
                    this.stateLock.readLock().release();
                    return bl3;
                }
                Object var7_15 = null;
                this.stateLock.readLock().release();
                return bl2;
            }
            Object var7_16 = null;
            this.stateLock.readLock().release();
            return bl;
        }
        catch (InterruptedException e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)e.getMessage());
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _upSetLocalAddress(Event event) {
        try {
            this.stateLock.writeLock().acquire();
            try {
                this.addr = (Address)event.getArg();
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.stateLock.writeLock().release();
                throw throwable;
            }
            this.stateLock.writeLock().release();
            {
            }
        }
        catch (InterruptedException e) {
            this.log.error((Object)e.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _upViewChange(Event event) {
        try {
            this.stateLock.writeLock().acquire();
            try {
                this.state = 0;
                Address oldSequencerAddr = this.sequencerAddr;
                this.sequencerAddr = (Address)((View)event.getArg()).getMembers().elementAt(0);
                if (this.addr.equals(this.sequencerAddr)) {
                    this.sequencerSeqID = -1L;
                    if ((oldSequencerAddr == null || !this.addr.equals(oldSequencerAddr)) && this.log.isInfoEnabled()) {
                        this.log.info((Object)"I'm the new sequencer");
                    }
                }
                this.seqID = -1L;
                this._replayBcast();
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.stateLock.writeLock().release();
                throw throwable;
            }
            this.stateLock.writeLock().release();
            {
            }
        }
        catch (InterruptedException e) {
            this.log.error((Object)e.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downBlockOk() {
        try {
            this.stateLock.writeLock().acquire();
            try {
                this.state = 2;
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.stateLock.writeLock().release();
                throw throwable;
            }
            this.stateLock.writeLock().release();
            {
            }
        }
        catch (InterruptedException e) {
            this.log.error((Object)e.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _downMsg(Event event) {
        try {
            block12: {
                boolean bl;
                block11: {
                    boolean bl2;
                    block10: {
                        boolean bl3;
                        block9: {
                            this.stateLock.readLock().acquire();
                            try {
                                if (this.state == -1) {
                                    if (this.log.isErrorEnabled()) {
                                        this.log.error((Object)"Discard msg in NULL_STATE");
                                    }
                                    bl3 = false;
                                    Object var5_6 = null;
                                    break block9;
                                }
                                if (this.state == 2) {
                                    if (this.log.isErrorEnabled()) {
                                        this.log.error((Object)"Blocked, discard msg");
                                    }
                                    bl2 = false;
                                    break block10;
                                }
                                Message msg = (Message)event.getArg();
                                if (msg.getDest() == null) {
                                    this._sendBcastRequest(msg);
                                    bl = false;
                                    break block11;
                                }
                                msg = this._sendUcast(msg);
                                event.setArg(msg);
                                break block12;
                            }
                            catch (Throwable throwable) {
                                Object var5_10 = null;
                                this.stateLock.readLock().release();
                                throw throwable;
                            }
                        }
                        this.stateLock.readLock().release();
                        return bl3;
                    }
                    Object var5_7 = null;
                    this.stateLock.readLock().release();
                    return bl2;
                }
                Object var5_8 = null;
                this.stateLock.readLock().release();
                return bl;
            }
            Object var5_9 = null;
            this.stateLock.readLock().release();
            return true;
        }
        catch (InterruptedException e) {
            this.log.error((Object)e.getMessage());
        }
        return true;
    }

    public void start() throws Exception {
        TimeScheduler timer;
        TimeScheduler timeScheduler = timer = this.stack != null ? this.stack.timer : null;
        if (timer == null) {
            throw new Exception("TOTAL.start(): timer is null");
        }
        this.reqTbl = new TreeMap();
        this.upTbl = new TreeMap();
        this.retransmitter = new AckSenderWindow(new Command(), this.AVG_RETRANSMIT_INTERVAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.stateLock.writeLock().acquire();
            try {
                this.state = -1;
                this.retransmitter.reset();
                this.reqTbl.clear();
                this.upTbl.clear();
                this.addr = null;
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.stateLock.writeLock().release();
                throw throwable;
            }
            this.stateLock.writeLock().release();
            {
            }
        }
        catch (InterruptedException e) {
            this.log.error((Object)e.getMessage());
        }
    }

    public void up(Event event) {
        switch (event.getType()) {
            case 10: {
                if (this._upBlock()) break;
                return;
            }
            case 1: {
                if (this._upMsg(event)) break;
                return;
            }
            case 8: {
                if (this._upSetLocalAddress(event)) break;
                return;
            }
            case 6: {
                if (this._upViewChange(event)) break;
                return;
            }
        }
        this.passUp(event);
    }

    public void down(Event event) {
        switch (event.getType()) {
            case 11: {
                if (this.downBlockOk()) break;
                return;
            }
            case 1: {
                if (this._downMsg(event)) break;
                return;
            }
        }
        this.passDown(event);
    }

    private class Command
    implements AckSenderWindow.RetransmitCommand {
        Command() {
        }

        public void retransmit(long seqNo, Message msg) {
            TOTAL.this._retransmitBcastRequest(seqNo);
        }
    }

    public static class Header
    extends org.jgroups.Header
    implements Streamable {
        public static final int NULL_TYPE = -1;
        public static final int REQ = 0;
        public static final int REP = 1;
        public static final int UCAST = 2;
        public static final int BCAST = 3;
        public int type;
        public long localSequenceID;
        public long sequenceID;

        public Header() {
        }

        public Header(int type, long localSeqID, long seqID) {
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.type = type;
                    break;
                }
                default: {
                    this.type = -1;
                    throw new IllegalArgumentException("type");
                }
            }
            this.localSequenceID = localSeqID;
            this.sequenceID = seqID;
        }

        public String toString() {
            String typeName;
            StringBuffer buffer = new StringBuffer();
            buffer.append("[TOTAL.Header");
            switch (this.type) {
                case 0: {
                    typeName = "REQ";
                    break;
                }
                case 1: {
                    typeName = "REP";
                    break;
                }
                case 2: {
                    typeName = "UCAST";
                    break;
                }
                case 3: {
                    typeName = "BCAST";
                    break;
                }
                case -1: {
                    typeName = "NULL_TYPE";
                    break;
                }
                default: {
                    typeName = "";
                }
            }
            buffer.append(", type=" + typeName);
            buffer.append(", localID=" + this.localSequenceID);
            buffer.append(", seqID=" + this.sequenceID);
            buffer.append(']');
            return buffer.toString();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeLong(this.localSequenceID);
            out.writeLong(this.sequenceID);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.localSequenceID = in.readLong();
            this.sequenceID = in.readLong();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeInt(this.type);
            out.writeLong(this.localSequenceID);
            out.writeLong(this.sequenceID);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readInt();
            this.localSequenceID = in.readLong();
            this.sequenceID = in.readLong();
        }

        public long size() {
            return 20L;
        }
    }
}

