/*
 * Decompiled with CFR 0.152.
 */
package org.junitee.output;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Iterator;
import javax.servlet.http.HttpServletResponse;
import org.junitee.output.AbstractOutput;
import org.junitee.runner.TestInfo;
import org.junitee.runner.TestRunnerResults;
import org.junitee.runner.TestSuiteInfo;
import org.junitee.util.StringUtils;

public class XMLOutput
extends AbstractOutput {
    private NumberFormat numberFormat;
    private PrintWriter pw;
    private HttpServletResponse response;
    private String xsl;

    public XMLOutput(TestRunnerResults results, HttpServletResponse response, String xsl, boolean filterTrace) throws IOException {
        super(results, filterTrace);
        this.pw = response.getWriter();
        this.response = response;
        this.xsl = xsl;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setMaximumFractionDigits(3);
        this.numberFormat.setMinimumFractionDigits(3);
    }

    public void render() {
        this.response.setContentType("text/xml");
        this.printHeader();
        this.printErrorMessages();
        this.printResults();
        this.printFooter();
    }

    protected void printHeader() {
        this.pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (this.xsl != null) {
            this.pw.println("<?xml-stylesheet type=\"text/xsl\"  href=\"" + this.xsl + "\"?>");
        }
        this.pw.print("<testsuites");
        if (!this.isFinished()) {
            this.pw.print(" unfinished=\"true\" ");
        }
        this.pw.println(">");
    }

    protected void printFooter() {
        this.pw.println("</testsuites>");
    }

    private String elapsedTimeAsString(long value) {
        return this.numberFormat.format((double)value / 1000.0);
    }

    protected void printErrorMessages() {
        Iterator iterator = this.getErrorMessages().iterator();
        while (iterator.hasNext()) {
            String message = (String)iterator.next();
            this.pw.print("  <errorMessage><![CDATA[");
            this.pw.print(message);
            this.pw.println("]]></errorMessage>");
        }
    }

    protected void printResults() {
        Iterator suites = this.getSuiteInfo().iterator();
        while (suites.hasNext()) {
            TestSuiteInfo suite = (TestSuiteInfo)suites.next();
            String fullName = suite.getTestClassName();
            int pos = fullName.lastIndexOf(".");
            String pkgName = pos == -1 ? "" : fullName.substring(0, pos);
            String className = pos == -1 ? fullName : fullName.substring(pos + 1);
            this.pw.print("  <testsuite name=\"");
            this.pw.print(className);
            this.pw.print("\" package=\"");
            this.pw.print(pkgName);
            this.pw.print("\" tests=\"");
            this.pw.print(suite.getTests().size());
            this.pw.print("\" failures=\"");
            this.pw.print(suite.getFailures().size());
            this.pw.print("\" errors=\"");
            this.pw.print(suite.getErrors().size());
            this.pw.print("\" time=\"");
            this.pw.print(this.elapsedTimeAsString(suite.getElapsedTime()));
            this.pw.println("\">");
            Iterator tests = suite.getTests().iterator();
            while (tests.hasNext()) {
                String stackTrace;
                TestInfo test = (TestInfo)tests.next();
                this.pw.print("    <testcase name=\"");
                this.pw.print(test.getTestName());
                this.pw.print("\" time=\"");
                this.pw.print(this.elapsedTimeAsString(test.getElapsedTime()));
                this.pw.print("\"");
                if (test.successful()) {
                    this.pw.println("/>");
                } else {
                    this.pw.println(">");
                }
                if (test.hasError()) {
                    stackTrace = this.exceptionToString(test.getError());
                    if (this.isFilterTrace()) {
                        stackTrace = StringUtils.filterStack(stackTrace);
                    }
                    this.pw.print("      <error message=\"");
                    this.pw.print(StringUtils.xmlText(test.getError().getMessage()));
                    this.pw.print("\" type=\"");
                    this.pw.print(test.getError().getClass().getName());
                    this.pw.println("\">");
                    this.pw.println(StringUtils.xmlText(stackTrace));
                    this.pw.println(StringUtils.xmlText(this.getEJBExceptionDetail(test.getError())));
                    this.pw.println("      </error>");
                } else if (test.hasFailure()) {
                    stackTrace = this.exceptionToString(test.getFailure());
                    if (this.isFilterTrace()) {
                        stackTrace = StringUtils.filterStack(stackTrace);
                    }
                    this.pw.print("      <failure message=\"");
                    this.pw.print(StringUtils.xmlText(test.getFailure().getMessage()));
                    this.pw.print("\" type=\"");
                    this.pw.print(test.getFailure().getClass().getName());
                    this.pw.println("\">");
                    this.pw.println(StringUtils.xmlText(stackTrace));
                    this.pw.println("      </failure>");
                }
                if (test.successful()) continue;
                this.pw.println("    </testcase>");
            }
            this.pw.println("  </testsuite>");
        }
    }
}

