/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna;

import com.arjuna.ats.arjuna.ArjunaNames;
import com.arjuna.ats.arjuna.PersistenceRecord;
import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import java.io.PrintWriter;

public class CadaverRecord
extends PersistenceRecord {
    private boolean newStateIsValid;
    private OutputObjectState oldState;
    private int oType;
    private ObjectStore store;

    public CadaverRecord(OutputObjectState os, ObjectStore objStore, StateManager sm) {
        super(os, objStore, sm);
        this.newStateIsValid = os != null;
        this.oldState = null;
        this.oType = 463;
        this.store = objStore;
        if (this.store != null) {
            // empty if block
        }
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 4L, 8L, "CadaverRecord::CadaverRecord(" + os + ", " + sm.get_uid() + ")");
        }
    }

    public void finalize() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(2L, 4L, 8L, "CadaverRecord::finalize() for " + this.order());
        }
        this.oldState = null;
        this.store = null;
        super.finalize();
    }

    public boolean propagateOnAbort() {
        return true;
    }

    public int typeIs() {
        return 111;
    }

    public ClassName className() {
        return ArjunaNames.Implementation_AbstractRecord_CadaverRecord();
    }

    public int nestedAbort() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "CadaverRecord::nestedAbort() for " + this.order());
        }
        if (this.oldState != null) {
            this.newStateIsValid = false;
        }
        if (this.oType == 101 && tsLogger.arjLoggerI18N.isWarnEnabled()) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.CadaverRecord_1", new Object[]{this.order(), this.getTypeOfObject()});
        }
        return 7;
    }

    public int nestedPrepare() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "CadaverRecord::nestedPrepare() for " + this.order());
        }
        if (this.newStateIsValid) {
            return super.nestedPrepare();
        }
        return 1;
    }

    public int topLevelAbort() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "CadaverRecord::topLevelAbort() for " + this.order());
        }
        this.newStateIsValid = false;
        if (this.oType == 101 && tsLogger.arjLoggerI18N.isWarnEnabled()) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.CadaverRecord_1", new Object[]{this.order(), this.getTypeOfObject()});
        }
        return 7;
    }

    public int topLevelCommit() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "CadaverRecord::topLevelCommit() for " + this.order());
        }
        boolean res = true;
        OutputObjectState oState = this.state;
        if (oState != null && this.oType == 111) {
            if (this.store == null) {
                return 8;
            }
            try {
                res = this.store.commit_state(oState.stateUid(), oState.type());
            }
            catch (ObjectStoreException e) {
                res = false;
            }
        }
        return res ? 7 : 8;
    }

    public int topLevelPrepare() {
        OutputObjectState oState;
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "CadaverRecord::topLevelPrepare() for " + this.order());
        }
        int tlpOk = 1;
        OutputObjectState outputObjectState = oState = this.newStateIsValid ? this.state : this.oldState;
        if (oState != null) {
            if (this.oType == 111) {
                if (this.store == null) {
                    return 1;
                }
                try {
                    if (this.store.write_uncommitted(oState.stateUid(), oState.type(), oState) && this.shadowForced()) {
                        tlpOk = 0;
                    }
                }
                catch (ObjectStoreException objectStoreException) {}
            } else {
                tlpOk = 0;
            }
        }
        return tlpOk;
    }

    public void print(PrintWriter strm) {
        strm.println("Cadaver for:");
        super.print(strm);
    }

    public String type() {
        return "/StateManager/AbstractRecord/RecoveryRecord/PersistenceRecord/CadaverRecord";
    }

    public boolean doSave() {
        return this.oType == 111;
    }

    public static AbstractRecord create() {
        return new CadaverRecord();
    }

    public void merge(AbstractRecord mergewith) {
        this.oType = mergewith.typeIs();
        if (this.oldState != null) {
            if (this.newStateIsValid) {
                this.oldState = null;
            } else {
                this.setValue(this.oldState);
                this.newStateIsValid = true;
            }
        }
        this.oldState = new OutputObjectState((OutputObjectState)mergewith.value());
    }

    public boolean shouldMerge(AbstractRecord ar) {
        return this.order().equals(ar.order()) && (ar.typeIs() == 111 || ar.typeIs() == 101);
    }

    public boolean shouldReplace(AbstractRecord ar) {
        return this.order().equals(ar.order()) && (ar.typeIs() == 111 || ar.typeIs() == 101);
    }

    protected CadaverRecord() {
        this.newStateIsValid = false;
        this.oldState = null;
        this.oType = 463;
        this.store = null;
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 2L, 8L, "CadaverRecord::CadaverRecord ()");
        }
    }
}

