/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateless;

import java.lang.reflect.InvocationTargetException;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.annotation.ejb.RemoteHome;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.ejb3.JBossProxy;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.remoting.RemoteProxyFactory;
import org.jboss.ejb3.stateless.BaseStatelessProxyFactory;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.ejb3.stateless.StatelessHandleImpl;
import org.jboss.ejb3.stateless.StatelessRemoteProxy;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;

public class StatelessRemoteProxyFactory
extends BaseStatelessProxyFactory
implements RemoteProxyFactory {
    private static final Logger log = Logger.getLogger(StatelessRemoteProxyFactory.class);
    protected RemoteBinding binding;
    protected InvokerLocator locator;

    public void setRemoteBinding(RemoteBinding binding) {
        this.binding = binding;
    }

    protected Class[] getInterfaces() {
        Class[] remoteInterfaces = ProxyFactoryHelper.getRemoteInterfaces(this.container);
        StatelessContainer statelessContainer = (StatelessContainer)this.container;
        RemoteHome remoteHome = (RemoteHome)statelessContainer.resolveAnnotation(RemoteHome.class);
        Class[] interfaces = remoteHome != null ? new Class[remoteInterfaces.length + 2] : new Class[remoteInterfaces.length + 1];
        System.arraycopy(remoteInterfaces, 0, interfaces, 0, remoteInterfaces.length);
        interfaces[remoteInterfaces.length] = JBossProxy.class;
        if (remoteHome != null) {
            interfaces[remoteInterfaces.length + 1] = remoteHome.value();
        }
        return interfaces;
    }

    protected void initializeJndiName() {
        this.jndiName = ProxyFactoryHelper.getRemoteJndiName(this.container, this.binding);
    }

    public void init() throws Exception {
        super.init();
        String clientBindUrl = this.binding.clientBindUrl();
        this.locator = new InvokerLocator(clientBindUrl);
    }

    public void start() throws Exception {
        super.start();
    }

    public void stop() throws Exception {
        super.stop();
    }

    protected StatelessHandleImpl getHandle() {
        StatelessHandleImpl handle = new StatelessHandleImpl();
        RemoteBinding remoteBinding = (RemoteBinding)this.advisor.resolveAnnotation(RemoteBinding.class);
        if (remoteBinding != null) {
            handle.jndiName = remoteBinding.jndiBinding();
        }
        return handle;
    }

    public Object createProxy() {
        try {
            String containerId = this.container.getObjectName().getCanonicalName();
            String stackName = "StatelessSessionClientInterceptors";
            if (this.binding.interceptorStack() != null && !this.binding.interceptorStack().equals("")) {
                stackName = this.binding.interceptorStack();
            }
            AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
            StatelessRemoteProxy proxy = new StatelessRemoteProxy(containerId, stack.createInterceptors((Advisor)this.container, null), this.locator);
            this.setEjb21Objects(proxy);
            Object[] args = new Object[]{proxy};
            return this.proxyConstructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }
}

