/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.util.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import org.ajax4jsf.framework.util.message.Messages;

public class DiffusionFilterOp
implements BufferedImageOp {
    protected static final int[] diffusionMatrix = new int[]{0, 0, 0, 0, 0, 7, 3, 5, 1};
    private int[] matrix;
    private int sum;
    private boolean serpentine = true;
    private int[] colorMap;

    public DiffusionFilterOp() {
        this.setMatrix(diffusionMatrix);
    }

    public void setSerpentine(boolean serpentine) {
        this.serpentine = serpentine;
    }

    public boolean getSerpentine() {
        return this.serpentine;
    }

    public void setMatrix(int[] matrix) {
        this.matrix = matrix;
        this.sum = 0;
        for (int i = 0; i < matrix.length; ++i) {
            this.sum += matrix[i];
        }
    }

    public int[] getMatrix() {
        return this.matrix;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        } else if (dst.getType() != 13) {
            throw new IllegalArgumentException(Messages.getMessage("BUFFER_TYPE_ERROR"));
        }
        DataBufferByte dstBuffer = (DataBufferByte)dst.getRaster().getDataBuffer();
        byte[] dstData = dstBuffer.getData();
        IndexColorModel icm = (IndexColorModel)dst.getColorModel();
        this.colorMap = new int[icm.getMapSize()];
        icm.getRGBs(this.colorMap);
        int width = src.getWidth();
        int height = src.getHeight();
        DataBufferInt srcBuffer = (DataBufferInt)src.getRaster().getDataBuffer();
        int[] srcData = srcBuffer.getData();
        int index = 0;
        for (int y = 0; y < height; ++y) {
            int direction;
            boolean reverse;
            boolean bl = reverse = this.serpentine && (y & 1) == 1;
            if (reverse) {
                index = y * width + width - 1;
                direction = -1;
            } else {
                index = y * width;
                direction = 1;
            }
            for (int x = 0; x < width; ++x) {
                int rgb1 = srcData[index];
                int a1 = rgb1 >> 24 & 0xFF;
                int r1 = rgb1 >> 16 & 0xFF;
                int g1 = rgb1 >> 8 & 0xFF;
                int b1 = rgb1 & 0xFF;
                int idx = this.findIndex(r1, g1, b1, a1);
                dstData[index] = (byte)idx;
                int rgb2 = this.colorMap[idx];
                int a2 = rgb2 >> 24 & 0xFF;
                int r2 = rgb2 >> 16 & 0xFF;
                int g2 = rgb2 >> 8 & 0xFF;
                int b2 = rgb2 & 0xFF;
                int er = r1 - r2;
                int eg = g1 - g2;
                int eb = b1 - b2;
                int ea = a1 - a2;
                for (int i = -1; i <= 1; ++i) {
                    int iy = i + y;
                    if (0 > iy || iy >= height) continue;
                    for (int j = -1; j <= 1; ++j) {
                        int w;
                        int jx = j + x;
                        if (0 > jx || jx >= width || (w = reverse ? this.matrix[(i + 1) * 3 - j + 1] : this.matrix[(i + 1) * 3 + j + 1]) == 0) continue;
                        int k = reverse ? index - j : index + j;
                        rgb1 = srcData[k];
                        a1 = (rgb1 >> 24 & 0xFF) + ea * w / this.sum;
                        r1 = (rgb1 >> 16 & 0xFF) + er * w / this.sum;
                        g1 = (rgb1 >> 8 & 0xFF) + eg * w / this.sum;
                        b1 = (rgb1 & 0xFF) + eb * w / this.sum;
                        srcData[k] = DiffusionFilterOp.clamp(a1) << 24 | DiffusionFilterOp.clamp(r1) << 16 | DiffusionFilterOp.clamp(g1) << 8 | DiffusionFilterOp.clamp(b1);
                    }
                }
                index += direction;
            }
        }
        return dst;
    }

    private static int clamp(int c) {
        if (c < 0) {
            return 0;
        }
        if (c > 255) {
            return 255;
        }
        return c;
    }

    int findIndex(int r1, int g1, int b1, int a1) throws ArrayIndexOutOfBoundsException {
        int idx = 0;
        long dist = Long.MAX_VALUE;
        for (int i = 0; i < this.colorMap.length; ++i) {
            int rgb2 = this.colorMap[i];
            int a2 = rgb2 >> 24 & 0xFF;
            int da = a1 - a2;
            int r2 = rgb2 >> 16 & 0xFF;
            int dr = r1 - r2;
            int g2 = rgb2 >> 8 & 0xFF;
            int dg = g1 - g2;
            int b2 = rgb2 & 0xFF;
            int db = b1 - b2;
            long newdist = da * da + dr * dr + dg * dg + db * db;
            if (newdist >= dist) continue;
            idx = i;
            dist = newdist;
        }
        return idx;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        return new BufferedImage(src.getWidth(), src.getHeight(), 13);
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point2D.Float();
        }
        dstPt.setLocation(srcPt.getX(), srcPt.getY());
        return dstPt;
    }

    public Rectangle2D getBounds2D(BufferedImage src) {
        return src.getRaster().getBounds();
    }
}

