/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.info.plugins;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.beans.info.plugins.AbstractPropertyInfo;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.BeanInfoFactory;
import org.jboss.classadapter.spi.ClassAdapter;
import org.jboss.joinpoint.spi.JoinpointFactory;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

public class AbstractBeanInfo
extends JBossObject
implements BeanInfo {
    protected String name;
    protected ClassAdapter classAdapter;
    protected Set properties;
    protected Set constructors;
    protected Set methods;
    protected Set events;
    protected BeanInfoFactory beanInfoFactory;

    public AbstractBeanInfo(BeanInfoFactory beanInfoFactory, ClassAdapter classAdapter, Set set, Set set2, Set set3, Set set4) {
        this.beanInfoFactory = beanInfoFactory;
        this.name = classAdapter.getClassInfo().getName();
        this.classAdapter = classAdapter;
        this.properties = set;
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AbstractPropertyInfo abstractPropertyInfo = (AbstractPropertyInfo)iterator.next();
                abstractPropertyInfo.beanInfo = this;
            }
        }
        this.constructors = set2;
        this.methods = set3;
        this.events = set4;
    }

    public String getName() {
        return this.name;
    }

    public Set getProperties() {
        return this.properties;
    }

    public void setProperties(Set set) {
        this.properties = set;
    }

    public ClassInfo getClassInfo() {
        return this.classAdapter.getClassInfo();
    }

    public List getDependencies() {
        return this.classAdapter.getDependencies();
    }

    public JoinpointFactory getJoinpointFactory() {
        return this.classAdapter.getJoinpointFactory();
    }

    public Set getConstructors() {
        return this.constructors;
    }

    public void setConstructors(Set set) {
        this.constructors = set;
    }

    public Set getEvents() {
        return this.events;
    }

    public void setEvents(Set set) {
        this.events = set;
    }

    public Set getMethods() {
        return this.methods;
    }

    public void setMethods(Set set) {
        this.methods = set;
    }

    public BeanInfoFactory getBeanInfoFactory() {
        return this.beanInfoFactory;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AbstractBeanInfo)) {
            return false;
        }
        AbstractBeanInfo abstractBeanInfo = (AbstractBeanInfo)object;
        if (AbstractBeanInfo.notEqual((Object)this.name, (Object)abstractBeanInfo.name)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual((Object)this.classAdapter, (Object)abstractBeanInfo.classAdapter)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual((Object)this.properties, (Object)abstractBeanInfo.properties)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual((Object)this.methods, (Object)abstractBeanInfo.methods)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual((Object)this.constructors, (Object)abstractBeanInfo.constructors)) {
            return false;
        }
        return !AbstractBeanInfo.notEqual((Object)this.events, (Object)abstractBeanInfo.events);
    }

    public void toString(JBossStringBuilder jBossStringBuilder) {
        jBossStringBuilder.append("name=").append(this.name);
        jBossStringBuilder.append(" classInfo=");
        this.classAdapter.toShortString(jBossStringBuilder);
        jBossStringBuilder.append(" properties=");
        JBossObject.list((JBossStringBuilder)jBossStringBuilder, (Collection)this.properties);
        jBossStringBuilder.append(" methods=");
        JBossObject.list((JBossStringBuilder)jBossStringBuilder, (Collection)this.methods);
        jBossStringBuilder.append(" constructors=");
        JBossObject.list((JBossStringBuilder)jBossStringBuilder, (Collection)this.constructors);
        jBossStringBuilder.append(" events=");
        JBossObject.list((JBossStringBuilder)jBossStringBuilder, (Collection)this.events);
    }

    public void toShortString(JBossStringBuilder jBossStringBuilder) {
        jBossStringBuilder.append(this.name);
    }

    public int getHashCode() {
        return this.name.hashCode();
    }
}

